/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.lang.reflect.Type;
import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMessage;
import net.snowflake.client.jdbc.internal.google.gson.Gson;
import net.snowflake.client.jdbc.internal.google.gson.GsonBuilder;
import net.snowflake.client.jdbc.internal.google.gson.JsonElement;
import net.snowflake.client.jdbc.internal.google.gson.JsonNull;
import net.snowflake.client.jdbc.internal.google.gson.JsonObject;
import net.snowflake.client.jdbc.internal.google.gson.JsonSerializationContext;
import net.snowflake.client.jdbc.internal.google.gson.JsonSerializer;

public class FieldMaskedSerializer
implements JsonSerializer<ApiMessage> {
    private final List<String> fieldMask;

    public FieldMaskedSerializer(List<String> fieldMask) {
        this.fieldMask = fieldMask;
    }

    @Override
    public JsonElement serialize(ApiMessage requestBody, Type typeOfSrc, JsonSerializationContext context) {
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (this.fieldMask == null) {
            return gson.toJsonTree(requestBody, typeOfSrc);
        }
        JsonObject jsonObject = new JsonObject();
        for (String fieldName : this.fieldMask) {
            Object fieldValue = requestBody.getFieldValue(fieldName);
            if (fieldValue != null) {
                jsonObject.add(fieldName, gson.toJsonTree(fieldValue, fieldValue.getClass()));
                continue;
            }
            jsonObject.add(fieldName, JsonNull.INSTANCE);
        }
        return jsonObject;
    }
}

