/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.gscommon.util;

import java.util.regex.Pattern;

public class Wildcard {
    private static char SINGLE_CHAR = (char)95;
    private static char MULTIPLE_CHAR = (char)37;
    private static char ESCAPED_CHAR = (char)92;
    private static String NON_ESCAPED_SINGLE_CHAR_REGEX = String.format("(?<!\\%c)%c", Character.valueOf(ESCAPED_CHAR), Character.valueOf(SINGLE_CHAR));
    private static String NON_ESCAPED_MULTIPLE_CHAR_REGEX = String.format("(?<!\\%c)%c", Character.valueOf(ESCAPED_CHAR), Character.valueOf(MULTIPLE_CHAR));
    private static String WILDCARD_CHARS_REGEX = String.format("(%s|%s)", NON_ESCAPED_SINGLE_CHAR_REGEX, NON_ESCAPED_MULTIPLE_CHAR_REGEX);
    private static String WILDCARD_STRING_REGEX = String.format(".*%s.*", WILDCARD_CHARS_REGEX);
    private static Pattern WILDCARD_STRING_PATTERN = Pattern.compile(WILDCARD_STRING_REGEX);

    public static String toRegexStr(String wildcardPattern) {
        Pattern separator = Pattern.compile(WILDCARD_CHARS_REGEX);
        String[] nonWildCardCharBlocks = separator.split(wildcardPattern);
        StringBuilder regexBuilder = new StringBuilder();
        int currentIndex = 0;
        for (String block : nonWildCardCharBlocks) {
            int len = block.length();
            if (len > 0) {
                String strippedBlock = Wildcard.stripEscapedChar(block);
                regexBuilder.append(Pattern.quote(strippedBlock));
            }
            if ((currentIndex += len) >= wildcardPattern.length()) continue;
            char charToConvert = wildcardPattern.charAt(currentIndex);
            assert (charToConvert == SINGLE_CHAR || charToConvert == MULTIPLE_CHAR);
            regexBuilder.append(charToConvert == SINGLE_CHAR ? "." : ".*");
            ++currentIndex;
        }
        while (currentIndex < wildcardPattern.length()) {
            char charToConvert = wildcardPattern.charAt(currentIndex);
            assert (charToConvert == SINGLE_CHAR || charToConvert == MULTIPLE_CHAR);
            regexBuilder.append(charToConvert == SINGLE_CHAR ? "." : ".*");
            ++currentIndex;
        }
        return regexBuilder.toString();
    }

    public static Pattern toRegexPattern(String wildcardPattern, boolean isCaseSensitive) {
        if (wildcardPattern == null) {
            return null;
        }
        return isCaseSensitive ? Pattern.compile(Wildcard.toRegexStr(wildcardPattern)) : Pattern.compile(Wildcard.toRegexStr(wildcardPattern), 2);
    }

    public static boolean isWildcardPatternStr(String inputString) {
        if (inputString == null) {
            return false;
        }
        return WILDCARD_STRING_PATTERN.matcher(inputString).matches();
    }

    private static String stripEscapedChar(String inputString) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < inputString.length(); ++i) {
            if (inputString.charAt(i) == ESCAPED_CHAR && !escaped) {
                escaped = true;
                continue;
            }
            sb.append(inputString.charAt(i));
            escaped = false;
        }
        return sb.toString();
    }
}

