/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonPointer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.BaseJsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ContainerNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.MissingNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.TextNode;

public class ObjectNode
extends ContainerNode<ObjectNode> {
    private final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            objectNode._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return objectNode;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ObjectNode) {
                return (ObjectNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
        }
        ObjectNode objectNode = this.objectNode();
        this._children.put(string, objectNode);
        return objectNode;
    }

    @Override
    public ArrayNode withArray(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ArrayNode) {
                return (ArrayNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
        }
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string, arrayNode);
        return arrayNode;
    }

    @Override
    public JsonNode findValue(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode jsonNode = entry.getValue().findValue(string);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(entry.getValue());
                continue;
            }
            list = entry.getValue().findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(entry.getValue().asText());
                continue;
            }
            list = entry.getValue().findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return this;
            }
            JsonNode jsonNode = entry.getValue().findParent(string);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(this);
                continue;
            }
            list = entry.getValue().findParents(string, list);
        }
        return list;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._children.put(string, jsonNode);
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> map) {
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode objectNode) {
        this._children.putAll(objectNode._children);
        return this;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode without(String string) {
        this._children.remove(string);
        return this;
    }

    public ObjectNode without(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode remove(String string) {
        return this._children.remove(string);
    }

    public ObjectNode remove(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> map) {
        return this.setAll(map);
    }

    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        this._children.keySet().retainAll(collection);
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        return this._put(string, this.pojoNode(object));
    }

    public ObjectNode putNull(String string) {
        this._children.put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, short s) {
        return this._put(string, this.numberNode(s));
    }

    public ObjectNode put(String string, Short s) {
        return this._put(string, s == null ? this.nullNode() : this.numberNode((short)s));
    }

    public ObjectNode put(String string, int n) {
        return this._put(string, this.numberNode(n));
    }

    public ObjectNode put(String string, Integer n) {
        return this._put(string, n == null ? this.nullNode() : this.numberNode((int)n));
    }

    public ObjectNode put(String string, long l) {
        return this._put(string, this.numberNode(l));
    }

    public ObjectNode put(String string, Long l) {
        return this._put(string, l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ObjectNode put(String string, float f) {
        return this._put(string, this.numberNode(f));
    }

    public ObjectNode put(String string, Float f) {
        return this._put(string, f == null ? this.nullNode() : this.numberNode(f.floatValue()));
    }

    public ObjectNode put(String string, double d) {
        return this._put(string, this.numberNode(d));
    }

    public ObjectNode put(String string, Double d) {
        return this._put(string, d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        return this._put(string, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ObjectNode put(String string, String string2) {
        return this._put(string, string2 == null ? this.nullNode() : this.textNode(string2));
    }

    public ObjectNode put(String string, boolean bl) {
        return this._put(string, this.booleanNode(bl));
    }

    public ObjectNode put(String string, Boolean bl) {
        return this._put(string, bl == null ? this.nullNode() : this.booleanNode(bl));
    }

    public ObjectNode put(String string, byte[] byArray) {
        return this._put(string, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        int n = 0;
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            ++n;
            TextNode.appendQuoted(stringBuilder, entry.getKey());
            stringBuilder.append(':');
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected ObjectNode _put(String string, JsonNode jsonNode) {
        this._children.put(string, jsonNode);
        return this;
    }
}

