/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.ResourceBundleManager;

public class SnowflakeSQLException
extends SQLException {
    static final Logger logger = Logger.getLogger(SnowflakeSQLException.class.getName());
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.jdbc_error_messages");
    private String queryId = "unknown";

    public SnowflakeSQLException(String queryId, String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
        this.queryId = queryId;
        logger.log(Level.FINER, "Snowflake exception: " + reason + ", sqlState:" + sqlState + ", vendorCode:" + vendorCode + ", queryId: " + queryId);
    }

    public SnowflakeSQLException(String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode);
        logger.log(Level.FINER, "Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)) + ", sqlState:" + sqlState + ", vendorCode:" + vendorCode);
    }

    public SnowflakeSQLException(String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode);
        logger.log(Level.FINER, "Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params) + ", sqlState:" + sqlState + ", vendorCode:" + vendorCode);
    }

    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode, ex);
        logger.log(Level.FINER, "Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), ex);
    }

    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode, ex);
        logger.log(Level.FINER, "Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), ex);
    }

    public String getQueryId() {
        return this.queryId;
    }
}

