/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.EnumSet;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.ContextualDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std.StdDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class EnumSetDeserializer
extends StdDeserializer<EnumSet<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 3479455075597887177L;
    protected final JavaType _enumType;
    protected final Class<Enum> _enumClass;
    protected JsonDeserializer<Enum<?>> _enumDeserializer;

    public EnumSetDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        super(EnumSet.class);
        this._enumType = javaType;
        this._enumClass = javaType.getRawClass();
        this._enumDeserializer = jsonDeserializer;
    }

    public EnumSetDeserializer withDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._enumDeserializer == jsonDeserializer) {
            return this;
        }
        return new EnumSetDeserializer(this._enumType, jsonDeserializer);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._enumDeserializer;
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(this._enumType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty);
        return this.withDeserializer(jsonDeserializer);
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            throw deserializationContext.mappingException(EnumSet.class);
        }
        EnumSet enumSet = this.constructSet();
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            if (jsonToken == JsonToken.VALUE_NULL) {
                throw deserializationContext.mappingException(this._enumClass);
            }
            Enum<?> enum_ = this._enumDeserializer.deserialize(jsonParser, deserializationContext);
            if (enum_ == null) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private EnumSet constructSet() {
        return EnumSet.noneOf(this._enumClass);
    }
}

