/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.apache.http.HttpClientConnection;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.apache.http.config.ConnectionConfig;
import net.snowflake.client.jdbc.internal.apache.http.config.SocketConfig;
import net.snowflake.client.jdbc.internal.apache.http.impl.pool.BasicConnFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.pool.BasicPoolEntry;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import net.snowflake.client.jdbc.internal.apache.http.pool.AbstractConnPool;
import net.snowflake.client.jdbc.internal.apache.http.pool.ConnFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

