/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.util.ClassUtil;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.util.FixedViewColumn;

public class SnowflakeUtil {
    public static final int EXTRA_TYPES_TIMESTAMP_LTZ = 50000;
    public static final int EXTRA_TYPES_TIMESTAMP_TZ = 50001;

    public static void checkErrorAndThrowException(JsonNode rootNode) throws SnowflakeSQLException {
        String errorMessage;
        int errorCode;
        String sqlState;
        if (rootNode.path("success").asBoolean()) {
            return;
        }
        String queryId = "unknown";
        if (!rootNode.path("data").path("sqlState").isMissingNode()) {
            sqlState = rootNode.path("data").path("sqlState").asText();
            errorCode = rootNode.path("data").path("errorCode").asInt();
            queryId = rootNode.path("data").path("queryId").asText();
            errorMessage = rootNode.path("message").asText();
        } else {
            sqlState = "XX000";
            if (!rootNode.path("code").isMissingNode()) {
                errorCode = rootNode.path("code").asInt();
                errorMessage = rootNode.path("message").asText();
            } else {
                errorCode = ErrorCode.INTERNAL_ERROR.getMessageCode();
                errorMessage = "no_error_code_from_server";
            }
        }
        throw new SnowflakeSQLException(queryId, errorMessage, sqlState, errorCode);
    }

    public static SnowflakeColumnMetadata extractColumnMetadata(JsonNode colNode) throws SnowflakeSQLException {
        String extColTypeName;
        int colType;
        String colName = colNode.path("name").asText();
        String internalColTypeName = colNode.path("type").asText();
        boolean nullable = colNode.path("nullable").asBoolean();
        int precision = colNode.path("precision").asInt();
        int scale = colNode.path("scale").asInt();
        int length = colNode.path("length").asInt();
        boolean fixed = colNode.path("fixed").asBoolean();
        SnowflakeType baseType = SnowflakeType.fromString(internalColTypeName);
        switch (baseType) {
            case TEXT: {
                colType = 12;
                extColTypeName = "VARCHAR";
                break;
            }
            case CHAR: {
                colType = 1;
                extColTypeName = "CHAR";
                break;
            }
            case INTEGER: {
                colType = 4;
                extColTypeName = "INTEGER";
                break;
            }
            case FIXED: {
                colType = 3;
                extColTypeName = "NUMBER";
                break;
            }
            case REAL: {
                colType = 8;
                extColTypeName = "DOUBLE";
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_LTZ: {
                colType = 50000;
                extColTypeName = "TIMESTAMPLTZ";
                break;
            }
            case TIMESTAMP_NTZ: {
                colType = 93;
                extColTypeName = "TIMESTAMPNTZ";
                break;
            }
            case TIMESTAMP_TZ: {
                colType = 50001;
                extColTypeName = "TIMESTAMPTZ";
                break;
            }
            case DATE: {
                colType = 91;
                extColTypeName = "DATE";
                break;
            }
            case TIME: {
                colType = 92;
                extColTypeName = "TIME";
                break;
            }
            case BOOLEAN: {
                colType = 16;
                extColTypeName = "BOOLEAN";
                break;
            }
            case ARRAY: {
                colType = 12;
                extColTypeName = "ARRAY";
                break;
            }
            case OBJECT: {
                colType = 12;
                extColTypeName = "OBJECT";
                break;
            }
            case VARIANT: {
                colType = 12;
                extColTypeName = "VARIANT";
                break;
            }
            case BINARY: {
                colType = -2;
                extColTypeName = "BINARY";
                break;
            }
            default: {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unknown column type: " + internalColTypeName);
            }
        }
        String colSrcDatabase = colNode.path("database").asText();
        String colSrcSchema = colNode.path("schema").asText();
        String colSrcTable = colNode.path("table").asText();
        return new SnowflakeColumnMetadata(colName, colType, nullable, length, precision, scale, extColTypeName, fixed, baseType, colSrcDatabase, colSrcSchema, colSrcTable);
    }

    public static String javaTypeToSFType(int javaType) throws SnowflakeSQLException {
        return SnowflakeType.javaTypeToSFType(javaType).name();
    }

    public static String concatFilePathNames(String leftPath, String rightPath, String fileSep) {
        String leftPathTrimmed = leftPath.trim();
        String rightPathTrimmed = rightPath.trim();
        if (leftPathTrimmed.endsWith(fileSep) && rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + rightPathTrimmed.substring(1);
        }
        if (!leftPathTrimmed.endsWith(fileSep) && !rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + fileSep + rightPathTrimmed;
        }
        return leftPathTrimmed + rightPathTrimmed;
    }

    public static String greatestCommonPrefix(String val1, String val2) {
        if (val1 == null || val2 == null) {
            return null;
        }
        StringBuilder greatestCommonPrefix = new StringBuilder();
        int len = Math.min(val1.length(), val2.length());
        for (int idx = 0; idx < len && val1.charAt(idx) == val2.charAt(idx); ++idx) {
            greatestCommonPrefix.append(val1.charAt(idx));
        }
        return greatestCommonPrefix.toString();
    }

    public static List<SnowflakeColumnMetadata> describeFixedViewColumns(Class clazz) throws SnowflakeSQLException {
        Field[] columns = ClassUtil.getAnnotatedDeclaredFields(clazz, FixedViewColumn.class, true);
        Arrays.sort(columns, new FixedViewColumn.OrdinalComparatorForFields());
        ArrayList<SnowflakeColumnMetadata> rowType = new ArrayList<SnowflakeColumnMetadata>();
        for (Field column : columns) {
            String typeName;
            int colType;
            FixedViewColumn columnAnnotation = column.getAnnotation(FixedViewColumn.class);
            Class<?> type = column.getType();
            SnowflakeType stype = SnowflakeType.TEXT;
            if (type == Integer.TYPE) {
                colType = 4;
                typeName = "INTEGER";
                stype = SnowflakeType.INTEGER;
            }
            if (type == Long.TYPE) {
                colType = 3;
                typeName = "DECIMAL";
                stype = SnowflakeType.INTEGER;
            } else if (type == String.class) {
                colType = 12;
                typeName = "VARCHAR";
                stype = SnowflakeType.TEXT;
            } else {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unsupported column type: " + type.getName());
            }
            rowType.add(new SnowflakeColumnMetadata(columnAnnotation.name(), colType, false, 20480, 10, 0, typeName, true, stype, "", "", ""));
        }
        return rowType;
    }

    public static void logResponseDetails(HttpResponse response, Logger logger) {
        Header[] headers;
        if (response == null) {
            logger.log(Level.SEVERE, "null response");
            return;
        }
        if (response.getStatusLine() != null) {
            logger.log(Level.SEVERE, "Response status line reason: {0}", response.getStatusLine().getReasonPhrase());
        }
        if ((headers = response.getAllHeaders()) != null) {
            for (Header header : headers) {
                logger.log(Level.SEVERE, "Header name: {0}, value: {1}", new Object[]{header.getName(), header.getValue()});
            }
        }
        if (response.getEntity() != null) {
            try {
                StringWriter writer = new StringWriter();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                IOUtils.copy((Reader)bufferedReader, (Writer)writer);
                logger.log(Level.SEVERE, "Response content: {0}", writer.toString());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to read content due to exception: {0}", ex.getMessage());
            }
        }
    }

    public static ThreadPoolExecutor createDefaultExecutorService(final String threadNamePrefix, int parallel) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(threadNamePrefix + this.threadCount++);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(parallel, threadFactory);
    }

    public static Throwable getRootCause(Exception ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

