/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.SystemDefaultHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.message.BasicHeader;
import net.snowflake.client.jdbc.internal.apache.http.message.HeaderGroup;
import net.snowflake.client.jdbc.internal.apache.http.params.BasicHttpParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpConnectionParams;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.ClientAuthnParameter;

public class SessionUtil {
    public static final String SF_QUERY_DATABASE = "databaseName";
    public static final String SF_QUERY_SCHEMA = "schemaName";
    public static final String SF_QUERY_WAREHOUSE = "warehouse";
    public static final String SF_QUERY_ROLE = "roleName";
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    private static final String SF_PATH_AUTHENTICATOR_REQUEST = "/session/authenticator-request";
    private static final String SF_PATH_LOGIN_REQUEST = "/session/v1/login-request";
    private static final String SF_PATH_TOKEN_REQUEST = "/session/token-request";
    public static final String SF_QUERY_SESSION_DELETE = "delete";
    private static final String SF_PATH_SESSION = "/session";
    private static ObjectMapper mapper = new ObjectMapper();
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_BASIC_AUTHTYPE = "Basic";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    private static int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT = 60000;
    private static int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private static int DEFAULT_HEALTH_CHECK_INTERVAL = 45;
    static final Logger logger = Logger.getLogger(SessionUtil.class.getName());

    public static LoginOutput openSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        Map<String, Object> commonParams;
        long masterTokenValidityInSeconds;
        String remMeToken;
        String masterToken;
        String sessionToken;
        URI loginURI;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for opening session");
        AssertUtil.assertTrue(loginInput.getUserName() != null, "missing user name for opening session");
        AssertUtil.assertTrue(loginInput.getPassword() != null, "missing password for opening session");
        AssertUtil.assertTrue(loginInput.getAppId() != null, "missing app id for opening session");
        AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for opening session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for opening session");
        String samlResponse = null;
        String databaseVersion = null;
        int databaseMajorVersion = 0;
        int databaseMinorVersion = 0;
        String newClientForUpgrade = null;
        int healthCheckInterval = DEFAULT_HEALTH_CHECK_INTERVAL;
        int httpClientSocketTimeout = loginInput.getSocketTimeout();
        try {
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            if (loginInput.getDatabaseName() != null) {
                uriBuilder.addParameter(SF_QUERY_DATABASE, loginInput.getDatabaseName());
            }
            if (loginInput.getSchemaName() != null) {
                uriBuilder.addParameter(SF_QUERY_SCHEMA, loginInput.getSchemaName());
            }
            if (loginInput.getWarehouse() != null) {
                uriBuilder.addParameter(SF_QUERY_WAREHOUSE, loginInput.getWarehouse());
            }
            if (loginInput.getRole() != null) {
                uriBuilder.addParameter(SF_QUERY_ROLE, loginInput.getRole());
            }
            if (loginInput.getAuthenticator() != null && !loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name())) {
                samlResponse = SessionUtil.getSamlResponseUsingOkta(loginInput);
            }
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            uriBuilder.setPath(SF_PATH_LOGIN_REQUEST);
            loginURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Exception when buildingt URL", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:1");
        }
        HttpClient httpClient = loginInput.getHttpClient();
        HttpPost postRequest = null;
        try {
            String clientInfoJSONStr;
            Properties clientInfo;
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            if (loginInput.getAuthenticator() == null || loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name())) {
                data.put(ClientAuthnParameter.LOGIN_NAME.name(), loginInput.getUserName());
                data.put(ClientAuthnParameter.PASSWORD.name(), loginInput.getPassword());
            } else {
                data.put(ClientAuthnParameter.RAW_SAML_RESPONSE.name(), samlResponse);
            }
            HashMap<String, Object> clientEnv = new HashMap<String, Object>();
            clientEnv.put("OS", System.getProperty("os.name"));
            clientEnv.put("OS_VERSION", System.getProperty("os.version"));
            clientEnv.put("JAVA_VERSION", System.getProperty("java.version"));
            clientEnv.put("JAVA_RUNTIME", System.getProperty("java.runtime.name"));
            clientEnv.put("JAVA_VM", System.getProperty("java.vm.name"));
            boolean CRLEnabled = SessionUtil.checkCRLSystemProperty();
            clientEnv.put("CRL_ENABLED", CRLEnabled);
            String appName = System.getProperty("sun.java.command");
            if (appName != null) {
                if (appName.indexOf(" ") > 0) {
                    appName = appName.substring(0, appName.indexOf(" "));
                }
                clientEnv.put("APPLICATION", appName);
            }
            if ((clientInfo = loginInput.getClientInfo()) != null) {
                for (Map.Entry<Object, Object> property : clientInfo.entrySet()) {
                    if (property == null || property.getKey() == null || property.getValue() == null) continue;
                    clientEnv.put(property.getKey().toString(), property.getValue().toString());
                }
            }
            if ((clientInfoJSONStr = System.getProperty("snowflake.client.info")) != null) {
                JsonNode clientInfoJSON = null;
                try {
                    clientInfoJSON = mapper.readTree(clientInfoJSONStr);
                }
                catch (Throwable ex) {
                    logger.log(Level.WARNING, "failed to process snowflake.client.info property as JSON: " + clientInfoJSONStr, ex);
                }
                if (clientInfoJSON != null) {
                    Iterator<Map.Entry<String, JsonNode>> fields = clientInfoJSON.fields();
                    while (fields.hasNext()) {
                        Map.Entry<String, JsonNode> field = fields.next();
                        clientEnv.put(field.getKey(), field.getValue().asText());
                    }
                }
            }
            data.put(ClientAuthnParameter.CLIENT_ENVIRONMENT.name(), clientEnv);
            Map<String, Object> sessionParameter = loginInput.getSessionParameters();
            if (sessionParameter != null) {
                data.put(ClientAuthnParameter.SESSION_PARAMETERS.name(), loginInput.getSessionParameters());
            }
            if (loginInput.getAccountName() != null) {
                data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            }
            if (loginInput.isPasscodeInPassword()) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
            } else if (loginInput.getPasscode() != null) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
                data.put(ClientAuthnParameter.PASSCODE.name(), loginInput.getPasscode());
            } else {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "push");
            }
            logger.log(Level.FINER, "implementation version = " + SnowflakeDriver.implementVersion);
            logger.log(Level.FINER, "svn revision = " + SnowflakeDriver.svnRevision);
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            if (loginInput.getAppBuildId() != null) {
                data.put(ClientAuthnParameter.CLIENT_BUILD_ID.name(), loginInput.getAppBuildId());
            }
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            postRequest = new HttpPost(loginURI);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, SF_HEADER_BASIC_AUTHTYPE);
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            logger.log(Level.FINER, "login response: {0}", theString);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.log(Level.FINE, "response = {0}", theString);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            sessionToken = jsonNode.path("data").path("token").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
            remMeToken = jsonNode.path("data").path("remMeToken").asText();
            masterTokenValidityInSeconds = jsonNode.path("data").path("masterValidityInSeconds").asLong();
            String serverVersion = jsonNode.path("data").path("serverVersion").asText();
            commonParams = SessionUtil.getCommonParams(jsonNode.path("data").path("parameters"));
            if (serverVersion != null) {
                logger.log(Level.FINE, "server version = " + serverVersion);
                databaseVersion = serverVersion.indexOf(" ") > 0 ? serverVersion.substring(0, serverVersion.indexOf(" ")) : serverVersion;
            } else {
                logger.log(Level.WARNING, "server version is null");
            }
            if (databaseVersion != null) {
                String[] components = databaseVersion.split("\\.");
                if (components != null && components.length >= 2) {
                    try {
                        databaseMajorVersion = Integer.parseInt(components[0]);
                        databaseMinorVersion = Integer.parseInt(components[1]);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Exception encountered when parsing server version: " + databaseVersion + ", Exception: " + ex.getMessage());
                    }
                }
            } else {
                logger.log(Level.WARNING, "database version is null");
            }
            if (!jsonNode.path("data").path("newClientForUpgrade").isNull()) {
                newClientForUpgrade = jsonNode.path("data").path("newClientForUpgrade").asText();
                logger.log(Level.FINE, "new client: {0}", newClientForUpgrade);
            }
            int healthCheckIntervalFromGS = jsonNode.path("data").path("healthCheckInterval").asInt();
            logger.log(Level.FINER, "health check interval = " + healthCheckIntervalFromGS);
            if (healthCheckIntervalFromGS > 0 && healthCheckIntervalFromGS != healthCheckInterval) {
                healthCheckInterval = healthCheckIntervalFromGS;
                httpClientSocketTimeout = loginInput.getSocketTimeout() + healthCheckIntervalFromGS * 1000;
                BasicHttpParams httpParams = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout(httpParams, loginInput.getConnectionTimeout());
                HttpConnectionParams.setSoTimeout(httpParams, httpClientSocketTimeout);
                ((SystemDefaultHttpClient)httpClient).setParams(httpParams);
                logger.log(Level.FINER, "adjusted connection timeout to = {0}", loginInput.getConnectionTimeout());
                logger.log(Level.FINER, "adjusted socket timeout to = {0}", httpClientSocketTimeout);
            }
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOException when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Exception when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
        }
        return new LoginOutput(sessionToken, masterToken, masterTokenValidityInSeconds, remMeToken, databaseVersion, databaseMajorVersion, databaseMinorVersion, newClientForUpgrade, healthCheckInterval, httpClientSocketTimeout, commonParams);
    }

    public static LoginOutput renewSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        String masterToken;
        String sessionToken;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for renewing session");
        AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for renewing session");
        AssertUtil.assertTrue(loginInput.getMasterToken() != null, "missing master token for renewing session");
        AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for renewing session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for renewing session");
        HttpPost postRequest = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            uriBuilder.setPath(SF_PATH_TOKEN_REQUEST);
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            postRequest = new HttpPost(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Exception when creating http request", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:3");
        }
        try {
            String json = "{\"oldSessionToken\":\"" + loginInput.getSessionToken() + "\", \"requestType\":" + 0 + "}";
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getMasterToken() + "\"");
            logger.log(Level.FINE, "old session token: " + loginInput.getSessionToken() + ", request type: 0, master token: " + loginInput.getMasterToken());
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.log(Level.FINE, "response = " + theString);
                String errorCode = jsonNode.path("code").asText();
                String message = jsonNode.path("message").asText();
                EventHandler eh = EventUtil.getEventHandlerInstance();
                eh.triggerBasicEvent(Event.EventType.NETWORK_ERROR, "SessionUtil:renewSession failure, error code=" + errorCode + ", message=" + message, true);
                SnowflakeUtil.checkErrorAndThrowException(jsonNode);
            }
            sessionToken = jsonNode.path("data").path("sessionToken").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOException when renewing session: " + postRequest, ex);
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
        LoginOutput loginOutput = new LoginOutput();
        loginOutput.setSessionToken(sessionToken).setMasterToken(masterToken);
        return loginOutput;
    }

    public static void closeSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        block4: {
            logger.log(Level.FINER, " public void close() throws SFException");
            AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for closing session");
            AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for closing session");
            AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for closing session");
            AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "missing login timeout for closing session");
            HttpPost postRequest = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_SESSION_DELETE, "true");
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
                uriBuilder.setPath(SF_PATH_SESSION);
                postRequest = new HttpPost(uriBuilder.build());
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getSessionToken() + "\"");
                String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
                logger.log(Level.FINER, "connection close response: {0}", theString);
                JsonNode rootNode = mapper.readTree(theString);
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("unexpected URI syntax exception", ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "unexpected IO exception for: " + postRequest, ex);
            }
            catch (SnowflakeSQLException ex) {
                if (ex.getErrorCode() == 390112) break block4;
                throw ex;
            }
        }
    }

    private static String getSamlResponseUsingOkta(LoginInput loginInput) throws SnowflakeSQLException {
        try {
            HttpClient httpClient = loginInput.getHttpClient();
            URIBuilder fedUriBuilder = new URIBuilder(loginInput.getServerUrl());
            fedUriBuilder.setPath(SF_PATH_AUTHENTICATOR_REQUEST);
            URI fedUrlUri = fedUriBuilder.build();
            HttpPost postRequest = new HttpPost(fedUrlUri);
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            data.put(ClientAuthnParameter.AUTHENTICATOR.name(), loginInput.getAuthenticator());
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            logger.log(Level.FINER, "authenticator-request response: {0}", theString);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.log(Level.FINE, "response = " + theString);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            JsonNode dataNode = jsonNode.path("data");
            String tokenUrl = dataNode.path("tokenUrl").asText();
            String oktaUrl = dataNode.path("ssoUrl").asText();
            URL url = new URL(tokenUrl);
            URI tokenUri = url.toURI();
            postRequest = new HttpPost(tokenUri);
            StringEntity params = new StringEntity("{\"username\":\"" + loginInput.getUserName() + "\",\"password\":\"" + loginInput.getPassword() + "\"}");
            postRequest.setEntity(params);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader(new BasicHeader("Accept", "application/json"));
            headers.addHeader(new BasicHeader("Content-Type", "application/json"));
            postRequest.setHeaders(headers.getAllHeaders());
            theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            postRequest = null;
            logger.log(Level.FINER, "authenticator-request response: {0}", theString);
            jsonNode = mapper.readTree(theString);
            String oneTimeToken = jsonNode.get("cookieToken").asText();
            url = new URL(oktaUrl);
            URI oktaGetUri = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath()).setParameter("RelayState", "%2Fsome%2Fdeep%2Flink").setParameter("onetimetoken", oneTimeToken).build();
            HttpGet httpGet = new HttpGet(oktaGetUri);
            headers.clear();
            headers.addHeader(new BasicHeader("Accept", "*/*"));
            httpGet.setHeaders(headers.getAllHeaders());
            return HttpUtil.executeRequest(httpGet, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOException when authenticating with " + loginInput.getAuthenticator(), ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Exception when authenticating with " + loginInput.getAuthenticator(), ex);
            throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
        }
    }

    public static boolean checkCRLSystemProperty() {
        String enableCRLDP = System.getProperty("com.sun.security.enableCRLDP");
        String checkRevocation = System.getProperty("com.sun.net.ssl.checkRevocation");
        boolean CRLEnabled = false;
        if (enableCRLDP != null && "true".equalsIgnoreCase(enableCRLDP) && checkRevocation != null && "true".equalsIgnoreCase(checkRevocation)) {
            CRLEnabled = true;
        }
        return CRLEnabled;
    }

    public static Map<String, Object> getCommonParams(JsonNode paramsNode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (JsonNode child : paramsNode) {
            if (!child.hasNonNull("name")) {
                logger.log(Level.SEVERE, "Common Parameter JsonNode encountered with no parameter name!");
                continue;
            }
            String paramName = child.path("name").asText();
            if (!child.hasNonNull("value")) {
                logger.log(Level.FINE, "No value found for Common Parameter {0}", child.path("name").asText());
                continue;
            }
            if ("TIMEZONE".equalsIgnoreCase(paramName) || "TIMESTAMP_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "TIMESTAMP_NTZ_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "TIMESTAMP_LTZ_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "TIMESTAMP_TZ_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "DATE_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "TIME_OUTPUT_FORMAT".equalsIgnoreCase(paramName) || "BINARY_OUTPUT_FORMAT".equalsIgnoreCase(paramName)) {
                parameters.put(paramName, child.path("value").asText());
            } else if ("CLIENT_RESULT_PREFETCH_SLOTS".equalsIgnoreCase(paramName) || "CLIENT_RESULT_PREFETCH_THREADS".equalsIgnoreCase(paramName) || "CLIENT_PREFETCH_THREADS".equalsIgnoreCase(paramName) || "CLIENT_MEMORY_LIMIT".equalsIgnoreCase(paramName)) {
                parameters.put(paramName, child.path("value").asInt());
            } else if ("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ".equalsIgnoreCase(paramName) || "JDBC_EXECUTE_RETURN_COUNT_FOR_DML".equalsIgnoreCase(paramName) || "JDBC_SHARING_WITH_CANONICAL".equalsIgnoreCase(paramName) || "JDBC_REWRITE_WITH_CANONICAL".equalsIgnoreCase(paramName) || "CLIENT_DISABLE_INCIDENTS".equalsIgnoreCase(paramName) || "CLIENT_SESSION_KEEP_ALIVE".equalsIgnoreCase(paramName) || "JDBC_USE_JSON_PARSER".equalsIgnoreCase(paramName) || "AUTOCOMMIT".equalsIgnoreCase(paramName) || "JDBC_EFFICIENT_CHUNK_STORAGE".equalsIgnoreCase(paramName)) {
                parameters.put(paramName, child.path("value").asBoolean());
            } else {
                logger.log(Level.FINE, "Unknown Common Parameter: {0}", paramName);
            }
            logger.log(Level.FINER, "Parameter {0}: {1}", new Object[]{paramName, child.path("value").asText()});
        }
        return parameters;
    }

    public static void updateSfDriverParamValues(Map<String, Object> parameters, SFSession session) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logger.log(Level.FINE, "processing parameter {0}", entry.getKey());
            if ("CLIENT_DISABLE_INCIDENTS".equalsIgnoreCase(entry.getKey())) {
                SnowflakeDriver.setDisableIncidents((Boolean)entry.getValue());
                continue;
            }
            if ("JDBC_EXECUTE_RETURN_COUNT_FOR_DML".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setExecuteReturnCountForDML((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_SESSION_KEEP_ALIVE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableHeartbeat((Boolean)entry.getValue());
                continue;
            }
            if (!"AUTOCOMMIT".equalsIgnoreCase(entry.getKey())) continue;
            boolean autoCommit = (Boolean)entry.getValue();
            if (session == null || session.getAutoCommit() == autoCommit) continue;
            session.setAutoCommit(autoCommit);
        }
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT;
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT;
    }

    public static class LoginOutput {
        String sessionToken;
        String masterToken;
        long masterTokenValidityInSeconds;
        String remMeToken;
        String databaseVersion;
        int databaseMajorVersion;
        int databaseMinorVersion;
        String newClientForUpgrade;
        int healthCheckInterval;
        int httpClientSocketTimeout;
        Map<String, Object> commonParams;

        public LoginOutput() {
        }

        public LoginOutput(String sessionToken, String masterToken, long masterTokenValidityInSeconds, String remMeToken, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String newClientForUpgrade, int healthCheckInterval, int httpClientSocketTimeout, Map<String, Object> commonParams) {
            this.sessionToken = sessionToken;
            this.masterToken = masterToken;
            this.remMeToken = remMeToken;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.newClientForUpgrade = newClientForUpgrade;
            this.healthCheckInterval = healthCheckInterval;
            this.httpClientSocketTimeout = httpClientSocketTimeout;
            this.commonParams = commonParams;
            this.masterTokenValidityInSeconds = masterTokenValidityInSeconds;
        }

        public LoginOutput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public LoginOutput setMasterToken(String masterToken) {
            this.masterToken = masterToken;
            return this;
        }

        public LoginOutput setRemMeToken(String remMeToken) {
            this.remMeToken = remMeToken;
            return this;
        }

        public LoginOutput setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public LoginOutput setDatabaseMajorVersion(int databaseMajorVersion) {
            this.databaseMajorVersion = databaseMajorVersion;
            return this;
        }

        public LoginOutput setDatabaseMinorVersion(int databaseMinorVersion) {
            this.databaseMinorVersion = databaseMinorVersion;
            return this;
        }

        public LoginOutput setNewClientForUpgrade(String newClientForUpgrade) {
            this.newClientForUpgrade = newClientForUpgrade;
            return this;
        }

        public LoginOutput setHealthCheckInterval(int healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public LoginOutput setHttpClientSocketTimeout(int httpClientSocketTimeout) {
            this.httpClientSocketTimeout = httpClientSocketTimeout;
            return this;
        }

        public LoginOutput setCommonParams(Map<String, Object> commonParams) {
            this.commonParams = commonParams;
            return this;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getMasterToken() {
            return this.masterToken;
        }

        public String getRemMeToken() {
            return this.remMeToken;
        }

        public String getDatabaseVersion() {
            return this.databaseVersion;
        }

        public int getDatabaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        public int getDatabaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        public String getNewClientForUpgrade() {
            return this.newClientForUpgrade;
        }

        public int getHealthCheckInterval() {
            return this.healthCheckInterval;
        }

        public int getHttpClientSocketTimeout() {
            return this.httpClientSocketTimeout;
        }

        public Map<String, Object> getCommonParams() {
            return this.commonParams;
        }

        public long getMasterTokenValidityInSeconds() {
            return this.masterTokenValidityInSeconds;
        }
    }

    public static class LoginInput {
        private String serverUrl;
        private String databaseName;
        private String schemaName;
        private String warehouse;
        private String role;
        private String authenticator;
        private HttpClient httpClient;
        private String accountName;
        private int loginTimeout = -1;
        private String userName;
        private String password;
        private Properties clientInfo;
        private boolean passcodeInPassword;
        private String passcode;
        private int connectionTimeout = SessionUtil.access$000();
        private int socketTimeout = SessionUtil.access$100();
        private String appId;
        private String appVersion;
        private String appBuildId;
        private String sessionToken;
        private String masterToken;
        private Map<String, Object> sessionParameters;

        public LoginInput() {
        }

        public LoginInput(String serverUrl, String databaseName, String schemaName, String warehouse, String role, String authenticator, HttpClient httpClient, String accountName, int loginTimeout, String userName, String password, Properties clientInfo, boolean passcodeInPassword, String passcode, int connectionTimeout, int socketTimeout, String appId, String appVersion, String appBuildId, String sessionToken, String masterToken, Map<String, Object> sessionParameters) {
            this.serverUrl = serverUrl;
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.warehouse = warehouse;
            this.role = role;
            this.authenticator = authenticator;
            this.httpClient = httpClient;
            this.accountName = accountName;
            this.loginTimeout = loginTimeout;
            this.userName = userName;
            this.password = password;
            this.clientInfo = clientInfo;
            this.passcodeInPassword = passcodeInPassword;
            this.passcode = passcode;
            this.connectionTimeout = connectionTimeout;
            this.socketTimeout = socketTimeout;
            this.appId = appId;
            this.appVersion = appVersion;
            this.appBuildId = appBuildId;
            this.sessionToken = sessionToken;
            this.masterToken = masterToken;
            this.sessionParameters = sessionParameters;
        }

        public LoginInput setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public LoginInput setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public LoginInput setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public LoginInput setWarehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public LoginInput setRole(String role) {
            this.role = role;
            return this;
        }

        public LoginInput setAuthenticator(String authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public LoginInput setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public LoginInput setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public LoginInput setLoginTimeout(int loginTimeout) {
            this.loginTimeout = loginTimeout;
            return this;
        }

        public LoginInput setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public LoginInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public LoginInput setClientInfo(Properties clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public LoginInput setPasscodeInPassword(boolean passcodeInPassword) {
            this.passcodeInPassword = passcodeInPassword;
            return this;
        }

        public LoginInput setPasscode(String passcode) {
            this.passcode = passcode;
            return this;
        }

        public LoginInput setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public LoginInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public LoginInput setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public LoginInput setAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public LoginInput setAppBuildId(String appBuildId) {
            this.appBuildId = appBuildId;
            return this;
        }

        public LoginInput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public LoginInput setMasterToken(String masterToken) {
            this.masterToken = masterToken;
            return this;
        }

        public LoginInput setSessionParameters(Map<String, Object> sessionParameters) {
            this.sessionParameters = sessionParameters;
            return this;
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getWarehouse() {
            return this.warehouse;
        }

        public String getRole() {
            return this.role;
        }

        public String getAuthenticator() {
            return this.authenticator;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public int getLoginTimeout() {
            return this.loginTimeout;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Properties getClientInfo() {
            return this.clientInfo;
        }

        public String getPasscode() {
            return this.passcode;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public boolean isPasscodeInPassword() {
            return this.passcodeInPassword;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getAppBuildId() {
            return this.appBuildId;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getMasterToken() {
            return this.masterToken;
        }

        public Map<String, Object> getSessionParameters() {
            return this.sessionParameters;
        }
    }
}

