/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.logs.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.FilteredLogEvent;
import net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.SearchedLogStream;

public class FilterLogEventsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<FilteredLogEvent> events;
    private ListWithAutoConstructFlag<SearchedLogStream> searchedLogStreams;
    private String nextToken;

    public List<FilteredLogEvent> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<FilteredLogEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public FilterLogEventsResult withEvents(FilteredLogEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<FilteredLogEvent>(events.length));
        }
        for (FilteredLogEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public FilterLogEventsResult withEvents(Collection<FilteredLogEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public List<SearchedLogStream> getSearchedLogStreams() {
        if (this.searchedLogStreams == null) {
            this.searchedLogStreams = new ListWithAutoConstructFlag();
            this.searchedLogStreams.setAutoConstruct(true);
        }
        return this.searchedLogStreams;
    }

    public void setSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
        if (searchedLogStreams == null) {
            this.searchedLogStreams = null;
            return;
        }
        ListWithAutoConstructFlag searchedLogStreamsCopy = new ListWithAutoConstructFlag(searchedLogStreams.size());
        searchedLogStreamsCopy.addAll(searchedLogStreams);
        this.searchedLogStreams = searchedLogStreamsCopy;
    }

    public FilterLogEventsResult withSearchedLogStreams(SearchedLogStream ... searchedLogStreams) {
        if (this.getSearchedLogStreams() == null) {
            this.setSearchedLogStreams(new ArrayList<SearchedLogStream>(searchedLogStreams.length));
        }
        for (SearchedLogStream value : searchedLogStreams) {
            this.getSearchedLogStreams().add(value);
        }
        return this;
    }

    public FilterLogEventsResult withSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
        if (searchedLogStreams == null) {
            this.searchedLogStreams = null;
        } else {
            ListWithAutoConstructFlag searchedLogStreamsCopy = new ListWithAutoConstructFlag(searchedLogStreams.size());
            searchedLogStreamsCopy.addAll(searchedLogStreams);
            this.searchedLogStreams = searchedLogStreamsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public FilterLogEventsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getSearchedLogStreams() != null) {
            sb.append("SearchedLogStreams: " + this.getSearchedLogStreams() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getSearchedLogStreams() == null ? 0 : this.getSearchedLogStreams().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResult)) {
            return false;
        }
        FilterLogEventsResult other = (FilterLogEventsResult)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getSearchedLogStreams() == null ^ this.getSearchedLogStreams() == null) {
            return false;
        }
        if (other.getSearchedLogStreams() != null && !other.getSearchedLogStreams().equals(this.getSearchedLogStreams())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public FilterLogEventsResult clone() {
        try {
            return (FilterLogEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

