/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFFixedViewResultSet;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeFixedView;
import net.snowflake.client.jdbc.SnowflakeS3Client;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSimulatedUploadFailure;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.AmazonS3Exception;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectListing;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectSummary;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.codec.digest.DigestUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.FileUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.filefilter.WildcardFileFilter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.io.ByteStreams;
import net.snowflake.client.jdbc.internal.google.common.io.CountingOutputStream;
import net.snowflake.client.jdbc.internal.snowflake.common.core.S3FileEncryptionMaterial;
import net.snowflake.client.jdbc.internal.snowflake.common.util.ClassUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.util.FixedViewColumn;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeFileTransferAgent
implements SnowflakeFixedView {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeFileTransferAgent.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    static final int S3_TRANSFER_MAX_RETRIES = 3;
    static final int CLIENT_SIDE_MAX_RETRIES = 25;
    static final int CLIENT_SIDE_RETRY_BACKOFF_MIN = 1000;
    static final int CLIENT_SIDE_RETRY_BACKOFF_MAX_EXPONENT = 4;
    static final int MAX_BUFFER_SIZE = 0x8000000;
    public static final String SRC_FILE_NAME_FOR_STREAM = "stream";
    private static final String EXPIRED_AWS_TOKEN_ERROR_CODE = "ExpiredToken";
    private static final String FILE_PROTOCOL = "file://";
    private static String localFSFileSep = System.getProperty("file.separator");
    private static int DEFAULT_PARALLEL = 10;
    private String command;
    private Set<String> sourceFiles;
    private Set<String> bigSourceFiles;
    private Set<String> smallSourceFiles;
    private static final int BIG_FILE_THRESHOLD = 0x1000000;
    private Map<String, FileMetadata> fileMetadataMap;
    private String stageLocationType;
    private String stageLocation;
    private Map stageCredentials;
    private String stageRegion;
    private String localLocation;
    private boolean showEncryptionParameter;
    private int parallel = DEFAULT_PARALLEL;
    private SFSession connection;
    private SFStatement statement;
    private InputStream sourceStream;
    private boolean sourceFromStream;
    private long sourceStreamSize;
    private boolean compressSourceFromStream;
    private String destFileNameForStreamSource;
    private List<S3FileEncryptionMaterial> encryptionMaterial;
    HashMap<String, S3FileEncryptionMaterial> srcFileToEncMat;
    private CommandType commandType = CommandType.UPLOAD;
    private boolean autoCompress = true;
    private boolean overwrite = false;
    private int currentRowIndex;
    private List<Object> statusRows;
    private SnowflakeS3Client s3Client = null;
    private static final String SOURCE_COMPRESSION_AUTO_DETECT = "auto_detect";
    private static final String SOURCE_COMPRESSION_NONE = "none";
    private String sourceCompression = "auto_detect";
    private ExecutorService threadExecutor = null;
    private Boolean canceled = false;

    public Map getStageCredentials() {
        return new HashMap(this.stageCredentials);
    }

    public List<S3FileEncryptionMaterial> getEncryptionMaterial() {
        return new ArrayList<S3FileEncryptionMaterial>(this.encryptionMaterial);
    }

    public Map<String, S3FileEncryptionMaterial> getSrcToMaterialsMap() {
        return new HashMap<String, S3FileEncryptionMaterial>(this.srcFileToEncMat);
    }

    public String getStageLocation() {
        return this.stageLocation;
    }

    private void initEncryptionMaterial(CommandType commandType, JsonNode jsonNode) throws SnowflakeSQLException, JsonProcessingException {
        this.encryptionMaterial = new ArrayList<S3FileEncryptionMaterial>();
        JsonNode rootNode = jsonNode.path("data").path("encryptionMaterial");
        if (commandType == CommandType.UPLOAD) {
            logger.debug("initEncryptionMaterial: UPLOAD");
            S3FileEncryptionMaterial encMat = null;
            if (!rootNode.isMissingNode() && !rootNode.isNull()) {
                encMat = mapper.treeToValue(rootNode, S3FileEncryptionMaterial.class);
            }
            this.encryptionMaterial.add(encMat);
        } else {
            logger.debug("initEncryptionMaterial: DOWNLOAD");
            if (!rootNode.isMissingNode() && !rootNode.isNull()) {
                this.encryptionMaterial = Arrays.asList((Object[])mapper.treeToValue(rootNode, S3FileEncryptionMaterial[].class));
            }
        }
    }

    private static InputStreamWithMetadata compressStreamWithGZIP(InputStream inputStream) throws SnowflakeSQLException {
        FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
        try {
            DigestOutputStream digestStream = new DigestOutputStream(tempStream, MessageDigest.getInstance("SHA-256"));
            CountingOutputStream countingStream = new CountingOutputStream(digestStream);
            GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)countingStream, true);
            IOUtils.copy(inputStream, (OutputStream)gzipStream);
            inputStream.close();
            gzipStream.finish();
            gzipStream.flush();
            countingStream.flush();
            return new InputStreamWithMetadata(countingStream.getCount(), Base64.encodeAsString(digestStream.getMessageDigest().digest()), tempStream);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.error("Exception compressing input stream", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "error encountered for compression");
        }
    }

    private static InputStreamWithMetadata compressStreamWithGZIPNoDigest(InputStream inputStream) throws SnowflakeSQLException {
        try {
            FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
            CountingOutputStream countingStream = new CountingOutputStream(tempStream);
            GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)countingStream, true);
            IOUtils.copy(inputStream, (OutputStream)gzipStream);
            inputStream.close();
            gzipStream.finish();
            gzipStream.flush();
            countingStream.flush();
            return new InputStreamWithMetadata(countingStream.getCount(), null, tempStream);
        }
        catch (IOException ex) {
            logger.error("Exception compressing input stream", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "error encountered for compression");
        }
    }

    private static InputStreamWithMetadata computeDigest(InputStream is, boolean resetStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        if (resetStream) {
            FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
            DigestOutputStream digestStream = new DigestOutputStream(tempStream, md);
            IOUtils.copy(is, (OutputStream)digestStream);
            return new InputStreamWithMetadata(-1L, Base64.encodeAsString(digestStream.getMessageDigest().digest()), tempStream);
        }
        DigestOutputStream digestStream = new DigestOutputStream(ByteStreams.nullOutputStream(), md);
        IOUtils.copy(is, (OutputStream)digestStream);
        return new InputStreamWithMetadata(-1L, Base64.encodeAsString(digestStream.getMessageDigest().digest()), null);
    }

    public static Callable<Void> getUploadFileCallable(final String stageLocationType, final String stageLocation, final String srcFilePath, final boolean requireCompress, final Map<String, FileMetadata> fileMetadataMap, final SnowflakeS3Client s3Client, final SFSession connection, final String command, final InputStream inputStream, final boolean sourceFromStream, final long sourceDataSize, final int parallel, final File srcFile, final S3FileEncryptionMaterial encMat, final String stageRegion) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long uploadSize;
                block28: {
                    logger.debug("Entering getUploadFileCallable...");
                    FileMetadata metadata = (FileMetadata)fileMetadataMap.get(srcFilePath);
                    InputStream uploadStream = inputStream;
                    File fileToUpload = null;
                    if (inputStream == null) {
                        try {
                            uploadStream = new FileInputStream(srcFilePath);
                        }
                        catch (FileNotFoundException ex) {
                            metadata.resultStatus = ResultStatus.ERROR;
                            metadata.errorDetails = ex.getMessage();
                            throw ex;
                        }
                    }
                    if (metadata == null) {
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing file metadata for: " + srcFilePath);
                    }
                    String destFileName = metadata.destFileName;
                    uploadSize = sourceDataSize;
                    String digest = null;
                    logger.debug("Dest file name={}, orig size={}", destFileName, uploadSize);
                    FileBackedOutputStream fileBackedOutputStream = null;
                    try {
                        if (requireCompress) {
                            InputStreamWithMetadata compressedSizeAndStream = encMat == null ? SnowflakeFileTransferAgent.compressStreamWithGZIPNoDigest(uploadStream) : SnowflakeFileTransferAgent.compressStreamWithGZIP(uploadStream);
                            fileBackedOutputStream = compressedSizeAndStream.fileBackedOutputStream;
                            uploadSize = compressedSizeAndStream.size;
                            digest = compressedSizeAndStream.digest;
                            if (compressedSizeAndStream.fileBackedOutputStream.getFile() != null) {
                                fileToUpload = compressedSizeAndStream.fileBackedOutputStream.getFile();
                            }
                            logger.debug("New size after compression: {}", uploadSize);
                        } else if (encMat != null) {
                            InputStreamWithMetadata result = SnowflakeFileTransferAgent.computeDigest(uploadStream, sourceFromStream);
                            digest = result.digest;
                            fileBackedOutputStream = result.fileBackedOutputStream;
                            if (!sourceFromStream) {
                                fileToUpload = srcFile;
                            } else if (result.fileBackedOutputStream.getFile() != null) {
                                fileToUpload = result.fileBackedOutputStream.getFile();
                            }
                        } else if (!sourceFromStream && srcFile != null) {
                            fileToUpload = srcFile;
                        }
                        logger.debug("Started copying file from: {} to {}:{} destName: {} auto compressed? {} size={}", srcFilePath, stageLocationType, stageLocation, destFileName, requireCompress ? "yes" : "no", uploadSize);
                        if (connection.getInjectFileUploadFailure() != null && srcFilePath.endsWith(connection.getInjectFileUploadFailure())) {
                            throw new SnowflakeSimulatedUploadFailure(srcFile != null ? srcFile.getName() : "Unknown");
                        }
                        if ("LOCAL_FS".equalsIgnoreCase(stageLocationType)) {
                            SnowflakeFileTransferAgent.pushFileToLocal(stageLocation, srcFilePath, destFileName, uploadStream, fileBackedOutputStream);
                            break block28;
                        }
                        if ("S3".equalsIgnoreCase(stageLocationType)) {
                            SnowflakeFileTransferAgent.pushFileToS3(stageLocation, srcFilePath, destFileName, uploadStream, fileBackedOutputStream, uploadSize, digest, metadata.destCompressionType, s3Client, connection, command, parallel, fileToUpload, fileToUpload == null, encMat, stageRegion);
                            metadata.isEncrypted = encMat != null;
                            break block28;
                        }
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unknown stage type: " + stageLocationType);
                    }
                    catch (SnowflakeSimulatedUploadFailure ex) {
                        metadata.resultStatus = ResultStatus.ERROR;
                        metadata.errorDetails = ex.getMessage();
                        throw ex;
                    }
                    catch (Throwable ex) {
                        logger.error("Exception encountered during file upload", ex);
                        metadata.resultStatus = ResultStatus.ERROR;
                        metadata.errorDetails = ex.getMessage();
                        throw ex;
                    }
                    finally {
                        if (fileBackedOutputStream != null) {
                            try {
                                fileBackedOutputStream.reset();
                            }
                            catch (IOException ex) {
                                logger.warn("failed to clean up temp file: {}", ex);
                            }
                        }
                        if (inputStream == null) {
                            IOUtils.closeQuietly(uploadStream);
                        }
                    }
                }
                logger.debug("filePath: {}", srcFilePath);
                metadata.destFileSize = uploadSize;
                metadata.resultStatus = ResultStatus.UPLOADED;
                return null;
            }
        };
    }

    public static Callable<Void> getDownloadFileCallable(final String stageLocationType, final String stageLocation, Map credentials, final String srcFilePath, final String localLocation, final Map<String, FileMetadata> fileMetadataMap, final SnowflakeS3Client s3Client, final SFSession connection, final String command, final int parallel, final S3FileEncryptionMaterial encMat, final String stageRegion) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long downloadSize;
                String destFileName;
                block5: {
                    logger.debug("Entering getDownloadFileCallable...");
                    FileMetadata metadata = (FileMetadata)fileMetadataMap.get(srcFilePath);
                    if (metadata == null) {
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing file metadata for: " + srcFilePath);
                    }
                    destFileName = metadata.destFileName;
                    logger.debug("Started copying file from: {}:{} file path:{} to {} destName:{}", stageLocationType, stageLocation, srcFilePath, localLocation, destFileName);
                    try {
                        if ("LOCAL_FS".equalsIgnoreCase(stageLocationType)) {
                            SnowflakeFileTransferAgent.pullFileFromLocal(stageLocation, srcFilePath, localLocation, destFileName);
                            break block5;
                        }
                        if ("S3".equalsIgnoreCase(stageLocationType)) {
                            SnowflakeFileTransferAgent.pullFileFromS3(stageLocation, srcFilePath, destFileName, localLocation, s3Client, connection, command, parallel, encMat, stageRegion);
                            metadata.isEncrypted = encMat != null;
                            break block5;
                        }
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unknown stage type: " + stageLocationType);
                    }
                    catch (Throwable ex) {
                        logger.error("Exception encountered during file download", ex);
                        metadata.resultStatus = ResultStatus.ERROR;
                        metadata.errorDetails = ex.getMessage();
                        throw ex;
                    }
                }
                logger.debug("filePath: {}", srcFilePath);
                File destFile = new File(localLocation + localFSFileSep + destFileName);
                metadata.destFileSize = downloadSize = destFile.length();
                metadata.resultStatus = ResultStatus.DOWNLOADED;
                return null;
            }
        };
    }

    public SnowflakeFileTransferAgent(String command, SFSession connection, SFStatement statement) throws SnowflakeSQLException {
        this.command = command;
        this.connection = connection;
        this.statement = statement;
        logger.debug("Start parsing");
        this.parseCommand();
        if ("S3".equalsIgnoreCase(this.stageLocationType)) {
            this.s3Client = SnowflakeFileTransferAgent.createS3Client(this.stageCredentials, this.parallel, null, this.stageRegion);
        }
    }

    private void parseCommand() throws SnowflakeSQLException {
        String[] src_locations;
        JsonNode jsonNode = SnowflakeFileTransferAgent.parseCommandInGS(this.statement, this.command);
        if (!jsonNode.path("data").path("command").isMissingNode()) {
            this.commandType = CommandType.valueOf(jsonNode.path("data").path("command").asText());
        }
        JsonNode locationsNode = jsonNode.path("data").path("src_locations");
        assert (locationsNode.isArray());
        try {
            src_locations = mapper.readValue(locationsNode.toString(), String[].class);
            this.initEncryptionMaterial(this.commandType, jsonNode);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to parse the locations due to: " + ex.getMessage());
        }
        this.showEncryptionParameter = jsonNode.path("data").path("clientShowEncryptionParameter").asBoolean();
        String localFilePathFromGS = null;
        if (this.commandType == CommandType.UPLOAD) {
            if (src_locations.length > 0) {
                localFilePathFromGS = src_locations[0];
            }
            this.sourceFiles = SnowflakeFileTransferAgent.expandFileNames(src_locations);
            this.autoCompress = jsonNode.path("data").path("autoCompress").asBoolean(true);
            if (!jsonNode.path("data").path("sourceCompression").isMissingNode()) {
                this.sourceCompression = jsonNode.path("data").path("sourceCompression").asText();
            }
        } else {
            this.srcFileToEncMat = new HashMap();
            if (src_locations.length == this.encryptionMaterial.size()) {
                for (int srcFileIdx = 0; srcFileIdx < src_locations.length; ++srcFileIdx) {
                    this.srcFileToEncMat.put(src_locations[srcFileIdx], this.encryptionMaterial.get(srcFileIdx));
                }
            }
            this.sourceFiles = new HashSet<String>(Arrays.asList(src_locations));
            localFilePathFromGS = this.localLocation = jsonNode.path("data").path("localLocation").asText();
            if (this.localLocation.startsWith("~")) {
                this.localLocation = System.getProperty("user.home") + this.localLocation.substring(1);
            }
            if (this.localLocation.contains("~")) {
                throw new SnowflakeSQLException("58030", ErrorCode.PATH_NOT_DIRECTORY.getMessageCode(), this.localLocation);
            }
            if (!new File(this.localLocation).isAbsolute()) {
                String cwd = System.getProperty("user.dir");
                logger.debug("Adding current working dir to relative file path.");
                this.localLocation = cwd + localFSFileSep + this.localLocation;
            }
            if (new File(this.localLocation).isFile()) {
                throw new SnowflakeSQLException("58030", ErrorCode.PATH_NOT_DIRECTORY.getMessageCode(), this.localLocation);
            }
        }
        this.verifyLocalFilePath(localFilePathFromGS);
        this.stageLocation = jsonNode.path("data").path("stageInfo").path("location").asText();
        this.parallel = jsonNode.path("data").path("parallel").asInt();
        this.overwrite = jsonNode.path("data").path("overwrite").asBoolean(false);
        this.stageLocationType = jsonNode.path("data").path("stageInfo").path("locationType").asText();
        if (!jsonNode.path("data").path("stageInfo").path("region").isMissingNode()) {
            this.stageRegion = jsonNode.path("data").path("stageInfo").path("region").asText();
        }
        if ("LOCAL_FS".equalsIgnoreCase(this.stageLocationType)) {
            if (this.stageLocation.startsWith("~")) {
                this.stageLocation = System.getProperty("user.home") + this.stageLocation.substring(1);
            }
            if (!new File(this.stageLocation).isAbsolute()) {
                String cwd = System.getProperty("user.dir");
                logger.debug("Adding current working dir to stage file path.");
                this.stageLocation = cwd + localFSFileSep + this.stageLocation;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Command type: {}", new Object[]{this.commandType});
            if (this.commandType == CommandType.UPLOAD) {
                logger.debug("autoCompress: {}", this.autoCompress);
                logger.debug("source compression: {}", this.sourceCompression);
            } else {
                logger.debug("local download location: {}", this.localLocation);
            }
            logger.debug("Source files:");
            for (String srcFile : this.sourceFiles) {
                logger.debug("file: {}", srcFile);
            }
            logger.debug("stageLocation: {}", this.stageLocation);
            logger.debug("parallel: {}", this.parallel);
            logger.debug("overwrite: {}", this.overwrite);
            logger.debug("destLocationType: {}", this.stageLocationType);
            logger.debug("stageRegion: {}", this.stageRegion);
        }
        this.stageCredentials = SnowflakeFileTransferAgent.extractStageCreds(jsonNode);
    }

    private void verifyLocalFilePath(String localFilePathFromGS) throws SnowflakeSQLException {
        if (this.command == null) {
            logger.error("null command");
            return;
        }
        if (this.command.indexOf(FILE_PROTOCOL) < 0) {
            logger.error("file:// prefix not found in command: {}", this.command);
            return;
        }
        int localFilePathBeginIdx = this.command.indexOf(FILE_PROTOCOL) + FILE_PROTOCOL.length();
        boolean isLocalFilePathQuoted = localFilePathBeginIdx > FILE_PROTOCOL.length() && this.command.charAt(localFilePathBeginIdx - 1 - FILE_PROTOCOL.length()) == '\'';
        int localFilePathEndIdx = 0;
        String localFilePath = "";
        if (isLocalFilePathQuoted) {
            localFilePathEndIdx = this.command.indexOf("'", localFilePathBeginIdx);
            if (localFilePathEndIdx > localFilePathBeginIdx) {
                localFilePath = this.command.substring(localFilePathBeginIdx, localFilePathEndIdx);
            }
            localFilePath = localFilePath.replaceAll("\\\\\\\\", "\\\\");
        } else {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            char[] delimiterChars = new char[]{' ', '\n', ';'};
            for (int i = 0; i < delimiterChars.length; ++i) {
                int charIndex = this.command.indexOf(delimiterChars[i], localFilePathBeginIdx);
                if (charIndex == -1) continue;
                indexList.add(charIndex);
            }
            int n = localFilePathEndIdx = indexList.isEmpty() ? -1 : (Integer)Collections.min(indexList);
            if (localFilePathEndIdx > localFilePathBeginIdx) {
                localFilePath = this.command.substring(localFilePathBeginIdx, localFilePathEndIdx);
            } else if (localFilePathEndIdx == -1) {
                localFilePath = this.command.substring(localFilePathBeginIdx);
            }
        }
        if (!localFilePath.isEmpty() && !localFilePath.equals(localFilePathFromGS)) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected local file path from GS. From GS: " + localFilePathFromGS + ", expected: " + localFilePath);
        }
        if (localFilePath.isEmpty()) {
            logger.warn("fail to parse local file path from command: {}", this.command);
        } else {
            logger.trace("local file path from GS matches local parsing: {}", localFilePath);
        }
    }

    private static JsonNode parseCommandInGS(SFStatement statement, String command) throws SnowflakeSQLException {
        Object result = null;
        try {
            result = statement.executeHelper(command, "application/json", null, false);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        JsonNode jsonNode = (JsonNode)result;
        logger.debug("response: {}", jsonNode.toString());
        SnowflakeUtil.checkErrorAndThrowException(jsonNode);
        return jsonNode;
    }

    private static Map extractStageCreds(JsonNode rootNode) throws SnowflakeSQLException {
        JsonNode credsNode = rootNode.path("data").path("stageInfo").path("creds");
        Map stageCredentials = null;
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            stageCredentials = (Map)mapper.readValue(credsNode.toString(), (TypeReference)typeRef);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to parse the credentials (" + (credsNode != null ? credsNode.toString() : "null") + ") due to exception: " + ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("aws id: {}", stageCredentials.get("AWS_ID"));
            logger.debug("aws key: {}", stageCredentials.get("AWS_KEY"));
            logger.debug("aws token: {}", stageCredentials.get("AWS_TOKEN"));
        }
        return stageCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        try {
            logger.debug("Start init metadata");
            this.initFileMetadata();
            logger.debug("Start checking file types");
            if (this.commandType == CommandType.UPLOAD) {
                this.processFileCompressionTypes();
            }
            if (!this.overwrite) {
                logger.debug("Start filtering");
                this.filterExistingFiles();
            }
            Boolean bl = this.canceled;
            // MONITORENTER : bl
            if (this.canceled.booleanValue()) {
                logger.debug("File transfer canceled by user");
                this.threadExecutor = null;
                boolean bl2 = false;
                // MONITOREXIT : bl
                return bl2;
            }
            // MONITOREXIT : bl
            if (this.commandType == CommandType.DOWNLOAD) {
                File dir = new File(this.localLocation);
                if (!dir.exists()) {
                    boolean created = dir.mkdirs();
                    if (created) {
                        logger.debug("directory created: {}", this.localLocation);
                    } else {
                        logger.debug("directory not created {}", this.localLocation);
                    }
                }
                this.downloadFiles();
            } else if (this.sourceFromStream) {
                this.uploadStream();
            } else {
                this.segregateFilesBySize();
                if (this.bigSourceFiles != null) {
                    logger.debug("start uploading big files");
                    this.uploadFiles(this.bigSourceFiles, 1);
                    logger.debug("end uploading big files");
                }
                if (this.smallSourceFiles != null) {
                    logger.debug("start uploading small files");
                    this.uploadFiles(this.smallSourceFiles, this.parallel);
                    logger.debug("end uploading small files");
                }
            }
            this.createStatusRows();
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (this.s3Client != null) {
                this.s3Client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadStream() throws SnowflakeSQLException {
        try {
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-stream-upload-worker-", 1);
            FileMetadata fileMetadata = this.fileMetadataMap.get(SRC_FILE_NAME_FOR_STREAM);
            S3FileEncryptionMaterial encMat = this.encryptionMaterial.get(0);
            if (this.commandType == CommandType.UPLOAD) {
                this.threadExecutor.submit(SnowflakeFileTransferAgent.getUploadFileCallable(this.stageLocationType, this.stageLocation, SRC_FILE_NAME_FOR_STREAM, this.compressSourceFromStream, this.fileMetadataMap, "S3".equalsIgnoreCase(this.stageLocationType) ? SnowflakeFileTransferAgent.createS3Client(this.stageCredentials, this.parallel, encMat, this.stageRegion) : null, this.connection, this.command, this.sourceStream, true, this.sourceStreamSize, this.parallel, null, encMat, this.stageRegion));
            } else if (this.commandType == CommandType.DOWNLOAD) {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode());
            }
            this.threadExecutor.shutdown();
            try {
                this.threadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
            logger.debug("Done with uploading from a stream");
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles() throws SnowflakeSQLException {
        try {
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-file-download-worker-", 1);
            for (String srcFile : this.sourceFiles) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus != ResultStatus.UNKNOWN) {
                    logger.debug("Skipping {}, status: {}, details: {}", new Object[]{srcFile, fileMetadata.resultStatus, fileMetadata.errorDetails});
                    continue;
                }
                S3FileEncryptionMaterial encMat = this.srcFileToEncMat.get(srcFile);
                this.threadExecutor.submit(SnowflakeFileTransferAgent.getDownloadFileCallable(this.stageLocationType, this.stageLocation, this.stageCredentials, srcFile, this.localLocation, this.fileMetadataMap, "S3".equalsIgnoreCase(this.stageLocationType) ? SnowflakeFileTransferAgent.createS3Client(this.stageCredentials, this.parallel, encMat, this.stageRegion) : null, this.connection, this.command, this.parallel, encMat, this.stageRegion));
                logger.debug("submitted download job for: {}", srcFile);
            }
            this.threadExecutor.shutdown();
            try {
                this.threadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
            logger.debug("Done with downloading");
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFiles(Set<String> fileList, int parallel) throws SnowflakeSQLException {
        try {
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-file-upload-worker-", parallel);
            for (String srcFile : fileList) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus != ResultStatus.UNKNOWN) {
                    logger.debug("Skipping {}, status: {}, details: {}", new Object[]{srcFile, fileMetadata.resultStatus, fileMetadata.errorDetails});
                    continue;
                }
                File srcFileObj = new File(srcFile);
                this.threadExecutor.submit(SnowflakeFileTransferAgent.getUploadFileCallable(this.stageLocationType, this.stageLocation, srcFile, fileMetadata.requireCompress, this.fileMetadataMap, "S3".equalsIgnoreCase(this.stageLocationType) ? SnowflakeFileTransferAgent.createS3Client(this.stageCredentials, parallel, this.encryptionMaterial.get(0), this.stageRegion) : null, this.connection, this.command, null, false, srcFileObj.length(), parallel > 1 ? 1 : this.parallel, srcFileObj, this.encryptionMaterial.get(0), this.stageRegion));
                logger.debug("submitted copy job for: {}", srcFile);
            }
            this.threadExecutor.shutdown();
            try {
                this.threadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
            logger.debug("Done with uploading");
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    private void segregateFilesBySize() {
        for (String srcFile : this.sourceFiles) {
            if (new File(srcFile).length() > 0x1000000L) {
                if (this.bigSourceFiles == null) {
                    this.bigSourceFiles = new HashSet<String>(this.sourceFiles.size());
                }
                this.bigSourceFiles.add(srcFile);
                continue;
            }
            if (this.smallSourceFiles == null) {
                this.smallSourceFiles = new HashSet<String>(this.sourceFiles.size());
            }
            this.smallSourceFiles.add(srcFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Boolean bl = this.canceled;
        synchronized (bl) {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
            this.canceled = true;
        }
    }

    public static Set<String> expandFileNames(String[] filePathList) throws SnowflakeSQLException {
        HashSet<String> result = new HashSet<String>();
        HashMap<String, ArrayList<String>> locationToFilePatterns = new HashMap<String, ArrayList<String>>();
        String cwd = System.getProperty("user.dir");
        for (String path : filePathList) {
            if (!new File(path = path.replace("~", System.getProperty("user.home"))).isAbsolute()) {
                logger.debug("Adding current working dir to relative file path.");
                path = cwd + localFSFileSep + path;
            }
            if (!(path.contains("*") || path.contains("?") || path.contains("[") && path.contains("]"))) {
                result.add(path);
                continue;
            }
            int lastFileSepIndex = path.lastIndexOf(localFSFileSep);
            if (lastFileSepIndex < 0 && !"/".equals(localFSFileSep)) {
                lastFileSepIndex = path.lastIndexOf("/");
            }
            String loc = path.substring(0, lastFileSepIndex + 1);
            String filePattern = path.substring(lastFileSepIndex + 1);
            ArrayList<String> filePatterns = (ArrayList<String>)locationToFilePatterns.get(loc);
            if (filePatterns == null) {
                filePatterns = new ArrayList<String>();
                locationToFilePatterns.put(loc, filePatterns);
            }
            filePatterns.add(filePattern);
        }
        for (Map.Entry entry : locationToFilePatterns.entrySet()) {
            try {
                File dir = new File((String)entry.getKey());
                logger.debug("Listing files under: {} with patterns: {}", entry.getKey(), ((List)entry.getValue()).toString());
                for (File file : FileUtils.listFiles(dir, new WildcardFileFilter((List)entry.getValue()), null)) {
                    result.add(file.getCanonicalPath());
                }
            }
            catch (Exception ex) {
                throw new SnowflakeSQLException(ex, "22000", (int)ErrorCode.FAIL_LIST_FILES.getMessageCode(), "Exception: " + ex.getMessage() + ", Dir=" + (String)entry.getKey() + ", Patterns=" + ((List)entry.getValue()).toString());
            }
        }
        logger.debug("Expanded file paths: ");
        for (String string : result) {
            logger.debug("file: {}", string);
        }
        return result;
    }

    private static boolean pushFileToLocal(String stageLocation, String filePath, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutStr) throws SQLException {
        stageLocation = stageLocation.replace("~", System.getProperty("user.home"));
        try {
            logger.debug("Copy file. srcFile={}, destination={}, destFileName={}", filePath, stageLocation, destFileName);
            File destFile = new File(SnowflakeUtil.concatFilePathNames(stageLocation, destFileName, localFSFileSep));
            if (fileBackedOutStr != null) {
                inputStream = fileBackedOutStr.asByteSource().openStream();
            }
            FileUtils.copyInputStreamToFile(inputStream, destFile);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex.getMessage());
        }
        return true;
    }

    private static boolean pullFileFromLocal(String sourceLocation, String filePath, String destLocation, String destFileName) throws SQLException {
        try {
            logger.debug("Copy file. srcFile={}, destination={}, destFileName={}", sourceLocation + localFSFileSep + filePath, destLocation, destFileName);
            File srcFile = new File(SnowflakeUtil.concatFilePathNames(sourceLocation, filePath, localFSFileSep));
            FileUtils.copyFileToDirectory(srcFile, new File(destLocation));
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushFileToS3(String stageLocation, String filePath, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutStr, long uploadSize, String digest, FileCompressionType compressionType, SnowflakeS3Client initialS3Client, SFSession connection, String command, int parallel, File srcFile, boolean uploadFromStream, S3FileEncryptionMaterial encMat, String stageRegion) throws SQLException, IOException {
        S3Location s3Location = SnowflakeFileTransferAgent.extractBucketNameAndPath(stageLocation);
        if (s3Location.path != null && !s3Location.path.isEmpty()) {
            destFileName = s3Location.path + (!s3Location.path.endsWith("/") ? "/" : "") + destFileName;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("upload object. bucketName={}, key={}, srcFile={}, encryption={}", s3Location.bucketName, destFileName, filePath, encMat == null ? "NULL" : Long.toString(encMat.getSmkId()) + "|" + encMat.getQueryId());
        }
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(uploadSize);
        if (digest != null) {
            meta.addUserMetadata("sfc-digest", digest);
        }
        if (compressionType != null && compressionType.isSupported()) {
            meta.setContentEncoding(compressionType.name().toLowerCase());
        }
        try {
            SnowflakeS3Client.upload(initialS3Client, connection, command, parallel, 25, uploadFromStream, s3Location.bucketName, srcFile, destFileName, inputStream, fileBackedOutStr, meta, stageRegion);
        }
        finally {
            if (uploadFromStream && inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static SnowflakeS3Client handleS3Exception(Exception ex, int retryCount, String operation, S3FileEncryptionMaterial encMat, SFSession connection, String command, int parallel, SnowflakeS3Client s3Client, String stageRegion) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support.";
            logger.error("JCE Unlimited Strength policy files missing: {}. {}.", ex.getMessage(), ex.getCause().getMessage());
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = msg + " The target directory on your system is: " + Paths.get(bootLib, "security").toString();
                logger.error(msg);
            }
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, msg);
        }
        if (ex instanceof AmazonClientException) {
            if (retryCount > 25) {
                AmazonServiceException ex1;
                String extendedRequestId = SOURCE_COMPRESSION_NONE;
                if (ex instanceof AmazonS3Exception) {
                    ex1 = (AmazonS3Exception)ex;
                    extendedRequestId = ((AmazonS3Exception)ex1).getExtendedRequestId();
                }
                if (ex instanceof AmazonServiceException) {
                    ex1 = (AmazonServiceException)ex;
                    throw new SnowflakeSQLException(ex1, "58000", (int)ErrorCode.S3_OPERATION_ERROR.getMessageCode(), operation, ex1.getErrorType().toString(), ex1.getErrorCode(), ex1.getMessage(), ex1.getRequestId(), extendedRequestId);
                }
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during " + operation + ", retry count: {}", ex.getMessage(), retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = 1000;
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, 4);
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return SnowflakeFileTransferAgent.renewExpiredAWSToken(connection, command, parallel, s3Client, (AmazonClientException)ex, encMat, stageRegion);
        }
        if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > 25) {
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during " + operation + ", retry count: {}", ex.getMessage(), retryCount);
            return s3Client;
        }
        throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
    }

    static SnowflakeS3Client renewExpiredAWSToken(SFSession connection, String command, int parallel, SnowflakeS3Client s3Client, AmazonClientException ex, S3FileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        AmazonS3Exception s3ex;
        if (ex instanceof AmazonS3Exception && (s3ex = (AmazonS3Exception)ex).getErrorCode().equalsIgnoreCase(EXPIRED_AWS_TOKEN_ERROR_CODE)) {
            SFStatement statement = new SFStatement(connection);
            JsonNode jsonNode = SnowflakeFileTransferAgent.parseCommandInGS(statement, command);
            Map stageCredentials = SnowflakeFileTransferAgent.extractStageCreds(jsonNode);
            s3Client = SnowflakeFileTransferAgent.createS3Client(stageCredentials, parallel, encMat, stageRegion);
        }
        return s3Client;
    }

    private static void pullFileFromS3(String stageLocation, String filePath, String destFileName, String localLocation, SnowflakeS3Client initialS3Client, SFSession connection, String command, int parallel, S3FileEncryptionMaterial encMat, String stageRegion) throws SQLException {
        S3Location s3Location = SnowflakeFileTransferAgent.extractBucketNameAndPath(stageLocation);
        String stageFilePath = filePath;
        if (!s3Location.path.isEmpty()) {
            stageFilePath = SnowflakeUtil.concatFilePathNames(s3Location.path, filePath, "/");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Download object. bucketName={}, key={}, srcFile={}, encryption={}", s3Location.bucketName, stageFilePath, filePath, encMat == null ? "NULL" : Long.toString(encMat.getSmkId()) + "|" + encMat.getQueryId());
        }
        SnowflakeS3Client.download(initialS3Client, connection, command, localLocation, destFileName, parallel, s3Location.bucketName, stageFilePath, stageRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterExistingFiles() throws SnowflakeSQLException {
        HashMap<String, String> destFileNameToSrcFileMap = new HashMap<String, String>(this.fileMetadataMap.size());
        logger.debug("Build reverse map from destination file name to source file");
        for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
            if (entry.getValue().destFileName != null) {
                String prevSrcFile = destFileNameToSrcFileMap.put(entry.getValue().destFileName, entry.getKey());
                if (prevSrcFile == null) continue;
                FileMetadata prevFileMetadata = this.fileMetadataMap.get(prevSrcFile);
                prevFileMetadata.resultStatus = ResultStatus.COLLISION;
                prevFileMetadata.errorDetails = prevSrcFile + " has same name as " + entry.getKey();
                continue;
            }
            logger.debug("No dest file name found for: {}", entry.getKey());
            logger.debug("Status: {}", new Object[]{entry.getValue().resultStatus});
        }
        if (destFileNameToSrcFileMap.size() == 0) {
            return;
        }
        Object[] stageFileNames = this.commandType == CommandType.UPLOAD ? destFileNameToSrcFileMap.keySet().toArray(new String[0]) : destFileNameToSrcFileMap.values().toArray(new String[0]);
        Arrays.sort(stageFileNames);
        String greatestCommonPrefix = SnowflakeUtil.greatestCommonPrefix((String)stageFileNames[0], (String)stageFileNames[stageFileNames.length - 1]);
        logger.debug("Greatest common prefix: {}", greatestCommonPrefix);
        if ("S3".equalsIgnoreCase(this.stageLocationType)) {
            logger.debug("check existing files on s3 for the common prefix");
            S3Location s3Location = SnowflakeFileTransferAgent.extractBucketNameAndPath(this.stageLocation);
            ObjectListing objList = null;
            int retryCount = 0;
            while (true) {
                try {
                    objList = this.s3Client.listObjects(s3Location.bucketName, SnowflakeUtil.concatFilePathNames(s3Location.path, greatestCommonPrefix, "/"));
                }
                catch (Exception ex) {
                    logger.warn("Listing objects for filtering encountered exception: {}", ex.getMessage());
                    this.s3Client = SnowflakeFileTransferAgent.handleS3Exception(ex, ++retryCount, "listObjects", null, this.connection, this.command, this.parallel, this.s3Client, this.stageRegion);
                    if (retryCount <= 25) continue;
                }
                break;
            }
            List<S3ObjectSummary> s3Objects = objList.getObjectSummaries();
            for (S3ObjectSummary obj : s3Objects) {
                logger.debug("Existing object: key={} size={} etag={}", obj.getKey(), obj.getSize(), obj.getETag());
                int idxOfLastFileSep = obj.getKey().lastIndexOf("/");
                String s3ObjFileName = obj.getKey().substring(idxOfLastFileSep + 1);
                String mappedSrcFile = (String)destFileNameToSrcFileMap.get(s3ObjFileName);
                if (mappedSrcFile == null) continue;
                logger.debug("Next compare digest for {} against {} on S3", mappedSrcFile, s3ObjFileName);
                String localFile = null;
                try {
                    ObjectMetadata meta;
                    String string = localFile = this.commandType == CommandType.UPLOAD ? mappedSrcFile : this.localLocation + s3ObjFileName;
                    if (this.commandType == CommandType.DOWNLOAD && !new File(localFile).exists()) {
                        logger.debug("File does not exist locally, will download {}", mappedSrcFile);
                        continue;
                    }
                    if (!this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress && Math.abs(obj.getSize() - new File(localFile).length()) > 16L) {
                        logger.debug("Size diff between S3 and local, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                        continue;
                    }
                    try {
                        meta = this.s3Client.getObjectMetadata(obj.getBucketName(), obj.getKey());
                    }
                    catch (Exception ex) {
                        AmazonS3Exception s3Ex;
                        if (ex instanceof AmazonS3Exception && (s3Ex = (AmazonS3Exception)ex).getStatusCode() == 404) {
                            logger.warn("File returned from listing but found missing {} when getting its metadata. Bucket={}, key={}", obj.getBucketName(), obj.getKey());
                            continue;
                        }
                        logger.error("Fetching object metadata encountered exception: {}", ex.getMessage());
                        throw ex;
                    }
                    String objDigest = meta.getUserMetadata().get("sfc-digest");
                    boolean remoteEncrypted = MatDesc.parse(meta.getUserMetadata().get("x-amz-matdesc")) != null;
                    InputStream fileStream = null;
                    String hashText = null;
                    ArrayList<FileBackedOutputStream> fileBackedOutputStreams = new ArrayList<FileBackedOutputStream>();
                    try {
                        InputStreamWithMetadata res;
                        fileStream = new FileInputStream(localFile);
                        if (this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress) {
                            logger.debug("Compressing stream for digest check");
                            res = SnowflakeFileTransferAgent.compressStreamWithGZIP(fileStream);
                            fileStream = res.fileBackedOutputStream.asByteSource().openStream();
                            fileBackedOutputStreams.add(res.fileBackedOutputStream);
                        }
                        if (objDigest != null) {
                            res = SnowflakeFileTransferAgent.computeDigest(fileStream, false);
                            hashText = res.digest;
                            fileBackedOutputStreams.add(res.fileBackedOutputStream);
                        } else if (!remoteEncrypted) {
                            hashText = DigestUtils.md5Hex(fileStream);
                        }
                    }
                    finally {
                        if (fileStream != null) {
                            ((InputStream)fileStream).close();
                        }
                        for (FileBackedOutputStream stream : fileBackedOutputStreams) {
                            if (stream == null) continue;
                            try {
                                stream.reset();
                            }
                            catch (IOException ex) {
                                logger.warn("failed to clean up temp file: {}", ex);
                            }
                        }
                    }
                    if (hashText == null || objDigest != null && !hashText.equals(objDigest) || objDigest == null && !hashText.equals(obj.getETag())) {
                        logger.debug("digest diff between S3 and local, will {} {}, local digest: {}, s3 digest: {}", this.commandType.name().toLowerCase(), mappedSrcFile, hashText, obj.getETag());
                        continue;
                    }
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Error reading: " + localFile);
                }
                logger.debug("digest same between S3 and local, will not upload {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                this.skipFile(mappedSrcFile, s3ObjFileName);
            }
        } else if ("LOCAL_FS".equalsIgnoreCase(this.stageLocationType)) {
            for (Object stageFileName : stageFileNames) {
                Object localFile;
                String stageFilePath = SnowflakeUtil.concatFilePathNames(this.stageLocation, (String)stageFileName, localFSFileSep);
                File stageFile = new File(stageFilePath);
                if (!stageFile.exists()) continue;
                Object mappedSrcFile = this.commandType == CommandType.UPLOAD ? (String)destFileNameToSrcFileMap.get(stageFileName) : stageFileName;
                Object object = localFile = this.commandType == CommandType.UPLOAD ? mappedSrcFile : this.localLocation + this.fileMetadataMap.get((Object)mappedSrcFile).destFileName;
                if (!this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress && stageFile.length() != new File((String)localFile).length()) {
                    logger.debug("Size diff between stage and local, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                    continue;
                }
                String localFileHashText = null;
                String stageFileHashText = null;
                ArrayList<FileBackedOutputStream> fileBackedOutputStreams = new ArrayList<FileBackedOutputStream>();
                InputStream localFileStream = null;
                try {
                    Object res;
                    localFileStream = new FileInputStream((String)localFile);
                    if (this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress) {
                        logger.debug("Compressing stream for digest check");
                        res = SnowflakeFileTransferAgent.compressStreamWithGZIP(localFileStream);
                        fileBackedOutputStreams.add(((InputStreamWithMetadata)res).fileBackedOutputStream);
                        localFileStream = ((InputStreamWithMetadata)res).fileBackedOutputStream.asByteSource().openStream();
                    }
                    res = SnowflakeFileTransferAgent.computeDigest(localFileStream, false);
                    localFileHashText = ((InputStreamWithMetadata)res).digest;
                    fileBackedOutputStreams.add(((InputStreamWithMetadata)res).fileBackedOutputStream);
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Error reading local file: " + (String)localFile);
                }
                finally {
                    for (FileBackedOutputStream stream : fileBackedOutputStreams) {
                        if (stream == null) continue;
                        try {
                            stream.reset();
                        }
                        catch (IOException ex) {
                            logger.warn("failed to clean up temp file: {}", ex);
                        }
                    }
                    IOUtils.closeQuietly(localFileStream);
                }
                FileBackedOutputStream fileBackedOutputStream = null;
                FileInputStream stageFileStream = null;
                try {
                    stageFileStream = new FileInputStream(stageFilePath);
                    InputStreamWithMetadata res = SnowflakeFileTransferAgent.computeDigest(stageFileStream, false);
                    stageFileHashText = res.digest;
                    fileBackedOutputStream = res.fileBackedOutputStream;
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Error reading stage file: " + stageFilePath);
                }
                finally {
                    try {
                        if (fileBackedOutputStream != null) {
                            fileBackedOutputStream.reset();
                        }
                    }
                    catch (IOException ex) {
                        logger.warn("failed to clean up temp file: {}", ex);
                    }
                    IOUtils.closeQuietly(stageFileStream);
                }
                if (!stageFileHashText.equals(localFileHashText)) {
                    logger.debug("digest diff between local and stage, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                    continue;
                }
                logger.debug("digest matches between local and stage, will skip {}", mappedSrcFile);
                this.skipFile((String)mappedSrcFile, (String)stageFileName);
            }
        } else {
            logger.error("Existing file check not supported for FS type={}", this.stageLocationType);
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unsupported stage location type: " + this.stageLocationType);
        }
    }

    private void skipFile(String srcFilePath, String destFileName) {
        FileMetadata fileMetadata = this.fileMetadataMap.get(srcFilePath);
        if (fileMetadata != null) {
            if (fileMetadata.resultStatus == null || fileMetadata.resultStatus == ResultStatus.UNKNOWN) {
                logger.debug("Mark {} as skipped", srcFilePath);
                fileMetadata.resultStatus = ResultStatus.SKIPPED;
                fileMetadata.errorDetails = "File with same destination name and checksum already exists: " + destFileName;
            } else {
                logger.debug("No need to mark as skipped for: {} status was already marked as: {}", new Object[]{srcFilePath, fileMetadata.resultStatus});
            }
        }
    }

    private void initFileMetadata() throws SnowflakeSQLException {
        block6: {
            block5: {
                this.fileMetadataMap = new HashMap<String, FileMetadata>(this.sourceFiles.size());
                if (this.commandType != CommandType.UPLOAD) break block5;
                if (this.sourceFromStream) {
                    FileMetadata fileMetadata = new FileMetadata();
                    this.fileMetadataMap.put(SRC_FILE_NAME_FOR_STREAM, fileMetadata);
                    fileMetadata.srcFileName = SRC_FILE_NAME_FOR_STREAM;
                } else {
                    for (String sourceFile : this.sourceFiles) {
                        FileMetadata fileMetadata = new FileMetadata();
                        this.fileMetadataMap.put(sourceFile, fileMetadata);
                        File file = new File(sourceFile);
                        fileMetadata.srcFileName = file.getName();
                        fileMetadata.srcFileSize = file.length();
                        if (!file.exists()) {
                            logger.warn("File doesn't exist: {}", sourceFile);
                            throw new SnowflakeSQLException("22000", ErrorCode.FILE_NOT_FOUND.getMessageCode(), sourceFile);
                        }
                        if (!file.isDirectory()) continue;
                        logger.warn("Not a file, but directory: {}", sourceFile);
                        throw new SnowflakeSQLException("22000", ErrorCode.FILE_IS_DIRECTORY.getMessageCode(), sourceFile);
                    }
                }
                break block6;
            }
            if (this.commandType != CommandType.DOWNLOAD) break block6;
            for (String sourceFile : this.sourceFiles) {
                FileMetadata fileMetadata = new FileMetadata();
                this.fileMetadataMap.put(sourceFile, fileMetadata);
                fileMetadata.srcFileName = sourceFile;
                fileMetadata.destFileName = sourceFile.substring(sourceFile.lastIndexOf("/") + 1);
            }
        }
    }

    private FileCompressionType mimeTypeToCompressionType(String mimeTypeStr) throws MimeTypeParseException {
        MimeType mimeType = null;
        if (mimeTypeStr != null) {
            mimeType = new MimeType(mimeTypeStr);
        }
        if (mimeType != null && mimeType.getSubType() != null) {
            return FileCompressionType.lookupByMimeSubType(mimeType.getSubType().toLowerCase());
        }
        return null;
    }

    private void processFileCompressionTypes() throws SnowflakeSQLException {
        boolean autoDetect = true;
        FileCompressionType userSpecifiedSourceCompression = null;
        if (SOURCE_COMPRESSION_AUTO_DETECT.equalsIgnoreCase(this.sourceCompression)) {
            autoDetect = true;
        } else if (SOURCE_COMPRESSION_NONE.equalsIgnoreCase(this.sourceCompression)) {
            autoDetect = false;
        } else {
            userSpecifiedSourceCompression = FileCompressionType.lookupByMimeSubType(this.sourceCompression.toLowerCase());
            if (userSpecifiedSourceCompression == null) {
                throw new SnowflakeSQLException("0A000", ErrorCode.COMPRESSION_TYPE_NOT_KNOWN.getMessageCode(), this.sourceCompression);
            }
            if (!userSpecifiedSourceCompression.isSupported()) {
                throw new SnowflakeSQLException("0A000", ErrorCode.COMPRESSION_TYPE_NOT_SUPPORTED.getMessageCode(), this.sourceCompression);
            }
            autoDetect = false;
        }
        if (!this.sourceFromStream) {
            for (String srcFile : this.sourceFiles) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus == ResultStatus.NONEXIST || fileMetadata.resultStatus == ResultStatus.DIRECTORY) continue;
                File file = new File(srcFile);
                String srcFileName = file.getName();
                String mimeTypeStr = null;
                Object mimeType = null;
                FileCompressionType currentFileCompressionType = null;
                try {
                    if (autoDetect) {
                        mimeTypeStr = Files.probeContentType(file.toPath());
                        if (mimeTypeStr == null) {
                            try (FileInputStream f = new FileInputStream(file);){
                                byte[] magic = new byte[4];
                                if (f.read(magic, 0, 4) == 4 && Arrays.equals(magic, new byte[]{80, 65, 82, 49})) {
                                    mimeTypeStr = "snowflake/parquet";
                                }
                            }
                        }
                        if (mimeTypeStr != null) {
                            logger.debug("Mime type for {} is: {}", srcFile, mimeTypeStr);
                            currentFileCompressionType = this.mimeTypeToCompressionType(mimeTypeStr);
                        }
                        if (currentFileCompressionType == null && (mimeTypeStr = this.getMimeTypeFromFileExtension(srcFile)) != null) {
                            logger.debug("Mime type for {} is: {}", srcFile, mimeTypeStr);
                            currentFileCompressionType = this.mimeTypeToCompressionType(mimeTypeStr);
                        }
                    } else {
                        currentFileCompressionType = userSpecifiedSourceCompression;
                    }
                    if (currentFileCompressionType != null) {
                        fileMetadata.srcCompressionType = currentFileCompressionType;
                        if (currentFileCompressionType.isSupported()) {
                            fileMetadata.destCompressionType = currentFileCompressionType;
                            fileMetadata.requireCompress = false;
                            fileMetadata.destFileName = srcFileName;
                            logger.debug("File compression detected as {} for: {}", currentFileCompressionType.name(), srcFile);
                            continue;
                        }
                        throw new SnowflakeSQLException("0A000", ErrorCode.COMPRESSION_TYPE_NOT_SUPPORTED.getMessageCode(), currentFileCompressionType.name());
                    }
                    logger.debug("Compression not found for file: {}", srcFile);
                    fileMetadata.requireCompress = this.autoCompress;
                    fileMetadata.srcCompressionType = null;
                    if (this.autoCompress) {
                        fileMetadata.destFileName = srcFileName + FileCompressionType.GZIP.fileExtension;
                        fileMetadata.destCompressionType = FileCompressionType.GZIP;
                        continue;
                    }
                    fileMetadata.destFileName = srcFileName;
                    fileMetadata.destCompressionType = null;
                }
                catch (MimeTypeParseException ex) {
                    logger.error("Exception encountered when processing file compression types", ex);
                    fileMetadata.resultStatus = ResultStatus.ERROR;
                    fileMetadata.errorDetails = "Failed to parse mime type: " + mimeTypeStr;
                }
                catch (Exception ex) {
                    if (ex instanceof SnowflakeSQLException) {
                        logger.debug("Exception encountered when processing file compression types", ex);
                    } else {
                        logger.debug("Exception encountered when processing file compression types", ex);
                    }
                    fileMetadata.resultStatus = ResultStatus.ERROR;
                    fileMetadata.errorDetails = ex.getMessage();
                }
            }
        } else {
            FileMetadata fileMetadata = this.fileMetadataMap.get(SRC_FILE_NAME_FOR_STREAM);
            fileMetadata.srcCompressionType = userSpecifiedSourceCompression;
            fileMetadata.destCompressionType = this.compressSourceFromStream ? FileCompressionType.GZIP : userSpecifiedSourceCompression;
            fileMetadata.destFileName = this.compressSourceFromStream && !this.destFileNameForStreamSource.endsWith(FileCompressionType.GZIP.fileExtension) ? this.destFileNameForStreamSource + FileCompressionType.GZIP.fileExtension : this.destFileNameForStreamSource;
        }
    }

    private String getMimeTypeFromFileExtension(String srcFile) {
        String srcFileLowCase = srcFile.toLowerCase();
        for (FileCompressionType compressionType : FileCompressionType.values()) {
            if (!srcFileLowCase.endsWith(compressionType.fileExtension)) continue;
            return compressionType.mimeType + "/" + (String)compressionType.mimeSubTypes.get(0);
        }
        return null;
    }

    private static SnowflakeS3Client createS3Client(Map stageCredentials, int parallel, String stageRegion) throws SnowflakeSQLException {
        return SnowflakeFileTransferAgent.createS3Client(stageCredentials, parallel, null, stageRegion);
    }

    private static SnowflakeS3Client createS3Client(Map stageCredentials, int parallel, S3FileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        SnowflakeS3Client s3Client;
        logger.debug("createS3Client encryption={}", encMat == null ? "no" : "yes");
        String awsID = (String)stageCredentials.get("AWS_ID");
        String awsKey = (String)stageCredentials.get("AWS_KEY");
        String awsToken = (String)stageCredentials.get("AWS_TOKEN");
        logger.debug("aws id={}, aws key={}, aws token={}", awsID, awsKey, awsToken);
        AWSCredentials awsCredentials = awsToken != null ? new BasicSessionCredentials(awsID, awsKey, awsToken) : new BasicAWSCredentials(awsID, awsKey);
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallel + 1);
        clientConfig.setMaxErrorRetry(3);
        logger.debug("s3 client configuration: maxConnection={}, connectionTimeout={}, socketTimeout={}, maxErrorRetry={}", clientConfig.getMaxConnections(), clientConfig.getConnectionTimeout(), clientConfig.getSocketTimeout(), clientConfig.getMaxErrorRetry());
        String httpsProxyHost = System.getProperty("https.proxyHost");
        if (httpsProxyHost != null) {
            clientConfig.setProxyHost(httpsProxyHost);
            clientConfig.setProxyPort(Integer.parseInt(System.getProperty("https.proxyPort")));
        }
        try {
            s3Client = new SnowflakeS3Client(awsCredentials, clientConfig, encMat, stageRegion);
        }
        catch (Throwable ex) {
            logger.debug("Exception creating s3 client", ex);
            throw ex;
        }
        logger.debug("s3 client created");
        return s3Client;
    }

    public static S3Location extractBucketNameAndPath(String stageLocation) {
        String bucketName = stageLocation;
        String s3path = "";
        if (stageLocation.contains("/")) {
            bucketName = stageLocation.substring(0, stageLocation.indexOf("/"));
            s3path = stageLocation.substring(stageLocation.indexOf("/") + 1);
        }
        return new S3Location(bucketName, s3path);
    }

    @Override
    public List<SnowflakeColumnMetadata> describeColumns() throws Exception {
        return SnowflakeUtil.describeFixedViewColumns(this.commandType == CommandType.UPLOAD ? (this.showEncryptionParameter ? UploadCommandEncryptionFacade.class : UploadCommandFacade.class) : (this.showEncryptionParameter ? DownloadCommandEncryptionFacade.class : DownloadCommandFacade.class));
    }

    @Override
    public List<Object> getNextRow() throws Exception {
        if (this.currentRowIndex < this.statusRows.size()) {
            return ClassUtil.getFixedViewObjectAsRow(this.commandType == CommandType.UPLOAD ? (this.showEncryptionParameter ? UploadCommandEncryptionFacade.class : UploadCommandFacade.class) : (this.showEncryptionParameter ? DownloadCommandEncryptionFacade.class : DownloadCommandFacade.class), this.statusRows.get(this.currentRowIndex++));
        }
        return null;
    }

    private void createStatusRows() {
        boolean sortResult;
        this.statusRows = new ArrayList<Object>();
        for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
            FileMetadata fileMetadata = entry.getValue();
            if (this.commandType == CommandType.UPLOAD) {
                this.statusRows.add(this.showEncryptionParameter ? new UploadCommandEncryptionFacade(fileMetadata.srcFileName, fileMetadata.destFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.srcFileSize, fileMetadata.destFileSize, fileMetadata.srcCompressionType == null ? "NONE" : fileMetadata.srcCompressionType.name(), fileMetadata.destCompressionType == null ? "NONE" : fileMetadata.destCompressionType.name(), fileMetadata.isEncrypted) : new UploadCommandFacade(fileMetadata.srcFileName, fileMetadata.destFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.srcFileSize, fileMetadata.destFileSize, fileMetadata.srcCompressionType == null ? "NONE" : fileMetadata.srcCompressionType.name(), fileMetadata.destCompressionType == null ? "NONE" : fileMetadata.destCompressionType.name()));
                continue;
            }
            if (this.commandType != CommandType.DOWNLOAD) continue;
            this.statusRows.add(this.showEncryptionParameter ? new DownloadCommandEncryptionFacade(fileMetadata.srcFileName.startsWith("/") ? fileMetadata.srcFileName.substring(1) : fileMetadata.srcFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.destFileSize, fileMetadata.isEncrypted) : new DownloadCommandFacade(fileMetadata.srcFileName.startsWith("/") ? fileMetadata.srcFileName.substring(1) : fileMetadata.srcFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.destFileSize));
        }
        Object sortProperty = null;
        sortProperty = this.connection.getSFSessionProperty("sort");
        boolean bl = sortResult = sortProperty != null && (Boolean)sortProperty != false;
        if (sortResult) {
            Comparator<Object> comparator = this.commandType == CommandType.UPLOAD ? new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String srcFileNameA = ((UploadCommandFacade)a).srcFile;
                    String srcFileNameB = ((UploadCommandFacade)b).srcFile;
                    return srcFileNameA.compareTo(srcFileNameB);
                }
            } : new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String srcFileNameA = ((DownloadCommandFacade)a).file;
                    String srcFileNameB = ((DownloadCommandFacade)b).file;
                    return srcFileNameA.compareTo(srcFileNameB);
                }
            };
            Collections.sort(this.statusRows, comparator);
        }
    }

    public Object getResultSet() throws SnowflakeSQLException {
        return new SFFixedViewResultSet(this);
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setSourceStream(InputStream sourceStream) {
        this.sourceStream = sourceStream;
        this.sourceFromStream = true;
    }

    public void setDestFileNameForStreamSource(String destFileNameForStreamSource) {
        this.destFileNameForStreamSource = destFileNameForStreamSource;
    }

    public void setSourceStreamSize(long sourceStreamSize) {
        this.sourceStreamSize = sourceStreamSize;
    }

    public void setCompressSourceFromStream(boolean compressSourceFromStream) {
        this.compressSourceFromStream = compressSourceFromStream;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    static class InputStreamWithMetadata {
        long size;
        String digest;
        FileBackedOutputStream fileBackedOutputStream;

        InputStreamWithMetadata(long size, String digest, FileBackedOutputStream fileBackedOutputStream) {
            this.size = size;
            this.digest = digest;
            this.fileBackedOutputStream = fileBackedOutputStream;
        }
    }

    public static enum FileCompressionType {
        GZIP(".gz", "application", Arrays.asList("gzip", "x-gzip"), true),
        DEFLATE(".deflate", "application", Arrays.asList("zlib", "deflate"), true),
        RAW_DEFLATE(".raw_deflate", "application", Arrays.asList("raw_deflate"), true),
        BZIP2(".bz2", "application", Arrays.asList("bzip2", "x-bzip2", "x-bz2", "x-bzip", "bz2"), true),
        ZSTD(".zst", "application", Arrays.asList("zstd"), true),
        BROTLI(".br", "application", Arrays.asList("brotli"), true),
        LZIP(".lz", "application", Arrays.asList("lzip", "x-lzip"), false),
        LZMA(".lzma", "application", Arrays.asList("lzma", "x-lzma"), false),
        LZO(".lzo", "application", Arrays.asList("lzop", "x-lzop"), false),
        XZ(".xz", "application", Arrays.asList("xz", "x-xz"), false),
        COMPRESS(".Z", "application", Arrays.asList("compress", "x-compress"), false),
        PARQUET(".parquet", "snowflake", Collections.singletonList("parquet"), true);

        private String fileExtension;
        private String mimeType;
        private List<String> mimeSubTypes;
        private boolean supported;
        static final Map<String, FileCompressionType> mimeSubTypeToCompressionMap;

        private FileCompressionType(String fileExtension, String mimeType, List<String> mimeSubTypes, boolean isSupported) {
            this.fileExtension = fileExtension;
            this.mimeType = mimeType;
            this.mimeSubTypes = mimeSubTypes;
            this.supported = isSupported;
        }

        public static FileCompressionType lookupByMimeSubType(String mimeSubType) {
            return mimeSubTypeToCompressionMap.get(mimeSubType);
        }

        public boolean isSupported() {
            return this.supported;
        }

        static {
            mimeSubTypeToCompressionMap = new HashMap<String, FileCompressionType>();
            for (FileCompressionType compression : FileCompressionType.values()) {
                for (String mimeSubType : compression.mimeSubTypes) {
                    mimeSubTypeToCompressionMap.put(mimeSubType, compression);
                }
            }
        }
    }

    private class FileMetadata {
        public String srcFileName;
        public long srcFileSize;
        public String destFileName;
        public long destFileSize;
        public boolean requireCompress;
        public ResultStatus resultStatus = ResultStatus.UNKNOWN;
        public String errorDetails = "";
        public FileCompressionType srcCompressionType;
        public FileCompressionType destCompressionType;
        public boolean isEncrypted = false;

        private FileMetadata() {
        }
    }

    public class DownloadCommandEncryptionFacade
    extends DownloadCommandFacade {
        @FixedViewColumn(name="encryption", ordinal=35)
        private String encryption;

        public DownloadCommandEncryptionFacade(String file, String resultStatus, String errorDetails, long size, boolean isEncrypted) {
            super(file, resultStatus, errorDetails, size);
            this.encryption = isEncrypted ? "DECRYPTED" : "";
        }
    }

    public class DownloadCommandFacade {
        @FixedViewColumn(name="file", ordinal=10)
        private String file;
        @FixedViewColumn(name="size", ordinal=20)
        private long size;
        @FixedViewColumn(name="status", ordinal=30)
        private String resultStatus;
        @FixedViewColumn(name="message", ordinal=40)
        private String errorDetails;

        public DownloadCommandFacade(String file, String resultStatus, String errorDetails, long size) {
            this.file = file;
            this.resultStatus = resultStatus;
            this.errorDetails = errorDetails;
            this.size = size;
        }
    }

    public class UploadCommandEncryptionFacade
    extends UploadCommandFacade {
        @FixedViewColumn(name="encryption", ordinal=75)
        private String encryption;

        public UploadCommandEncryptionFacade(String srcFile, String destFile, String resultStatus, String errorDetails, long srcSize, long destSize, String srcCompressionType, String destCompressionType, boolean isEncrypted) {
            super(srcFile, destFile, resultStatus, errorDetails, srcSize, destSize, srcCompressionType, destCompressionType);
            this.encryption = isEncrypted ? "ENCRYPTED" : "";
        }
    }

    public class UploadCommandFacade {
        @FixedViewColumn(name="source", ordinal=10)
        private String srcFile;
        @FixedViewColumn(name="target", ordinal=20)
        private String destFile;
        @FixedViewColumn(name="source_size", ordinal=30)
        private long srcSize;
        @FixedViewColumn(name="target_size", ordinal=40)
        private long destSize = -1L;
        @FixedViewColumn(name="source_compression", ordinal=50)
        private String srcCompressionType;
        @FixedViewColumn(name="target_compression", ordinal=60)
        private String destCompressionType;
        @FixedViewColumn(name="status", ordinal=70)
        private String resultStatus;
        @FixedViewColumn(name="message", ordinal=80)
        private String errorDetails;

        public UploadCommandFacade(String srcFile, String destFile, String resultStatus, String errorDetails, long srcSize, long destSize, String srcCompressionType, String destCompressionType) {
            this.srcFile = srcFile;
            this.destFile = destFile;
            this.resultStatus = resultStatus;
            this.errorDetails = errorDetails;
            this.srcSize = srcSize;
            this.destSize = destSize;
            this.srcCompressionType = srcCompressionType;
            this.destCompressionType = destCompressionType;
        }
    }

    public static enum UploadColumns {
        source,
        target,
        source_size,
        target_size,
        source_compression,
        target_compression,
        status,
        encryption,
        message;

    }

    private static class S3Location {
        String bucketName;
        String path;

        public S3Location(String s3BucketName, String s3path) {
            this.bucketName = s3BucketName;
            this.path = s3path;
        }
    }

    public static enum ResultStatus {
        UNKNOWN("Unknown status"),
        UPLOADED("File uploaded"),
        UNSUPPORTED("File type not supported"),
        ERROR("Error encountered"),
        SKIPPED("Skipped since file exists"),
        NONEXIST("File does not exist"),
        COLLISION("File name collides with another file"),
        DIRECTORY("Not a file, but directory"),
        DOWNLOADED("File downloaded");

        private String desc;

        public String getDesc() {
            return this.desc;
        }

        private ResultStatus(String desc) {
            this.desc = desc;
        }
    }

    public static enum CommandType {
        UPLOAD,
        DOWNLOAD;

    }
}

