/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GrantListEntry;

public class ListGrantsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<GrantListEntry> grants;
    private String nextMarker;
    private Boolean truncated;

    public List<GrantListEntry> getGrants() {
        if (this.grants == null) {
            this.grants = new ListWithAutoConstructFlag();
            this.grants.setAutoConstruct(true);
        }
        return this.grants;
    }

    public void setGrants(Collection<GrantListEntry> grants) {
        if (grants == null) {
            this.grants = null;
            return;
        }
        ListWithAutoConstructFlag grantsCopy = new ListWithAutoConstructFlag(grants.size());
        grantsCopy.addAll(grants);
        this.grants = grantsCopy;
    }

    public ListGrantsResult withGrants(GrantListEntry ... grants) {
        if (this.getGrants() == null) {
            this.setGrants(new ArrayList<GrantListEntry>(grants.length));
        }
        for (GrantListEntry value : grants) {
            this.getGrants().add(value);
        }
        return this;
    }

    public ListGrantsResult withGrants(Collection<GrantListEntry> grants) {
        if (grants == null) {
            this.grants = null;
        } else {
            ListWithAutoConstructFlag grantsCopy = new ListWithAutoConstructFlag(grants.size());
            grantsCopy.addAll(grants);
            this.grants = grantsCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListGrantsResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public ListGrantsResult withTruncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrants() != null) {
            sb.append("Grants: " + this.getGrants() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("Truncated: " + this.isTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrants() == null ? 0 : this.getGrants().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGrantsResult)) {
            return false;
        }
        ListGrantsResult other = (ListGrantsResult)obj;
        if (other.getGrants() == null ^ this.getGrants() == null) {
            return false;
        }
        if (other.getGrants() != null && !other.getGrants().equals(this.getGrants())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        return other.isTruncated() == null || other.isTruncated().equals(this.isTruncated());
    }

    public ListGrantsResult clone() {
        try {
            return (ListGrantsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

