/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFDate;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFInstant;
import net.snowflake.client.jdbc.internal.snowflake.common.util.TimeUtil;

public class SFTimestamp
extends SFInstant {
    private final Timestamp timestamp;
    private final TimeZone timeZone;
    private static final int BITS_FOR_TIMEZONE = 14;
    private static final int MASK_OF_TIMEZONE = 16383;

    public static SFTimestamp fromMilliseconds(long ms, TimeZone tz) {
        SFTimestamp res = new SFTimestamp(new Timestamp(ms), tz);
        return res;
    }

    public static SFTimestamp fromNanoseconds(long ns, TimeZone tz) {
        return SFTimestamp.fromNanoseconds(new BigDecimal(ns), tz);
    }

    public static SFTimestamp fromNanoseconds(BigDecimal ns, TimeZone tz) {
        Timestamp t = TimeUtil.timestampFromNs(ns);
        SFTimestamp res = new SFTimestamp(t, tz);
        return res;
    }

    public static TimeZone convertTimezoneIndexToTimeZone(int timezoneIndex) {
        assert (timezoneIndex >= 0 && timezoneIndex <= 2880);
        boolean negate = (timezoneIndex -= 1440) < 0;
        timezoneIndex = Math.abs(timezoneIndex);
        int hour = timezoneIndex / 60;
        assert (hour >= 0 && hour <= 24);
        int min = timezoneIndex % 60;
        assert (min >= 0 && min <= 59);
        String tzName = String.format("GMT%s%02d:%02d", negate ? "-" : "+", hour, min);
        return TimeZone.getTimeZone(tzName);
    }

    public static SFTimestamp fromBinary(BigDecimal binary, int scale, TimeZone tz) {
        BigDecimal nanoseconds;
        if (tz != null) {
            nanoseconds = binary.scaleByPowerOfTen(9 - scale);
        } else {
            BigInteger secsWithTzOff = binary.toBigIntegerExact();
            BigInteger tzOff = secsWithTzOff.and(BigInteger.valueOf(16383L));
            BigInteger secsWoTzOff = secsWithTzOff.shiftRight(14);
            nanoseconds = new BigDecimal(secsWoTzOff).scaleByPowerOfTen(9 - scale);
            tz = SFTimestamp.convertTimezoneIndexToTimeZone(tzOff.intValue());
        }
        return SFTimestamp.fromNanoseconds(nanoseconds, tz);
    }

    public static SFTimestamp fromDate(Date date, int nanos, TimeZone tz) {
        Timestamp t = new Timestamp(date.getTime());
        t.setNanos(nanos);
        SFTimestamp res = new SFTimestamp(t, tz);
        return res;
    }

    public static SFTimestamp fromSFDate(SFDate sfd, TimeZone tz) {
        GregorianCalendar calUTC = CalendarCache.get(SFInstant.GMT, "GMT-source");
        calUTC.setTime(sfd.getDate());
        GregorianCalendar calLocal = CalendarCache.get(tz);
        calLocal.set(calUTC.get(1), calUTC.get(2), calUTC.get(5));
        Timestamp t = new Timestamp(calLocal.getTimeInMillis());
        SFTimestamp res = new SFTimestamp(t, tz);
        return res;
    }

    public SFTimestamp(Timestamp ts, TimeZone tz) {
        this.timestamp = ts != null ? ts : new Timestamp(new Date().getTime());
        this.timeZone = tz != null ? tz : SFInstant.GMT;
    }

    public SFTimestamp(Timestamp ts) {
        this(ts, SFInstant.GMT);
    }

    public SFTimestamp(SFDate date) {
        this(new Timestamp(date.getTime()), SFInstant.GMT);
    }

    public SFTimestamp() {
        this(null, null);
    }

    public SFTimestamp(SFTimestamp sft) {
        if (sft.timestamp != null) {
            Timestamp t = new Timestamp(((Date)sft.timestamp).getTime());
            t.setNanos(sft.timestamp.getNanos());
            this.timestamp = t;
            this.timeZone = (TimeZone)sft.timeZone.clone();
        } else {
            this.timestamp = null;
            this.timeZone = SFInstant.GMT;
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public SFTimestamp changeTimeZone(TimeZone timeZone) {
        return new SFTimestamp(this.timestamp, timeZone);
    }

    public SFTimestamp moveToTimeZone(TimeZone newTimeZone) {
        int offsetMillisInOldTZ = this.getTimeZone().getOffset(this.getTime());
        GregorianCalendar calendar = CalendarCache.get(this.getTimeZone());
        calendar.setTimeInMillis(this.getTime());
        int millisecondWithinDay = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int offsetMillisInNewTZ = newTimeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), millisecondWithinDay);
        int offsetMillis = offsetMillisInOldTZ - offsetMillisInNewTZ;
        long newMillis = this.getTime() + (long)offsetMillis;
        Timestamp newSqlTs = new Timestamp(newMillis);
        newSqlTs.setNanos(this.getNanos());
        return new SFTimestamp(newSqlTs, newTimeZone);
    }

    public SFTimestamp adjustScale(int scale) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Invalid timestamp scale " + scale);
        }
        int zeroesAtEnd = 9 - scale;
        int powerOfTen = SFInstant.POWERS_OF_TEN[zeroesAtEnd];
        int extraDigits = this.getNanos() % powerOfTen;
        if (extraDigits == 0) {
            return this;
        }
        Timestamp newSqlTs = new Timestamp(this.getTime());
        newSqlTs.setNanos(this.getNanos() - extraDigits);
        return new SFTimestamp(newSqlTs, this.getTimeZone());
    }

    public String toUTCString() {
        String nanoStr = String.format(".%1$09d", this.timestamp.getNanos());
        TimeZone tstz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat tsf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss" + nanoStr + "XXX");
        tsf.setTimeZone(tstz);
        String res = tsf.format(this.timestamp.getTime());
        return res;
    }

    public int compareTo(SFTimestamp other) {
        return this.timestamp.compareTo(other.timestamp);
    }

    public boolean equals(SFTimestamp other) {
        return this.timestamp.equals(other.timestamp);
    }

    public long getTime() {
        return this.timestamp.getTime();
    }

    public int getNanos() {
        return this.timestamp.getNanos();
    }

    public int hashCode() {
        return this.toBinary(9, false).hashCode();
    }

    public BigInteger toBinary(int scale, boolean includeTimeZone) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Scale must be between 0 and 9");
        }
        BigDecimal timeInMs = new BigDecimal(this.timestamp.getTime());
        BigDecimal timeInSec = timeInMs.scaleByPowerOfTen(-3).setScale(0, RoundingMode.FLOOR);
        BigDecimal timeInNs = timeInSec.scaleByPowerOfTen(9);
        BigDecimal ns = new BigDecimal(this.timestamp.getNanos());
        timeInNs = timeInNs.add(ns);
        BigDecimal scaledTime = timeInNs.scaleByPowerOfTen(scale - 9);
        scaledTime = scaledTime.setScale(0, RoundingMode.DOWN);
        BigInteger fcpInt = scaledTime.unscaledValue();
        if (includeTimeZone) {
            int offsetMillis = this.timeZone.getOffset(this.timestamp.getTime());
            int offsetMin = offsetMillis / 60000;
            assert (offsetMin >= -1440 && offsetMin <= 1440);
            fcpInt = fcpInt.shiftLeft(14);
            fcpInt = fcpInt.add(BigInteger.valueOf((offsetMin += 1440) & 0x3FFF));
        }
        return fcpInt;
    }

    @Override
    public int extract(int field) {
        TimeZone tz = this.timeZone == null ? SFInstant.GMT : this.timeZone;
        return this.extract(field, tz, this.timestamp.getTime());
    }

    public String toString() {
        return "SFTimestamp(timestamp='" + this.timestamp + "' timeZone='" + this.timeZone + "')";
    }
}

