/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.sax;

import java.util.ArrayList;
import java.util.Arrays;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import net.snowflake.client.jdbc.internal.apache.tika.sax.CleanPhoneText;
import net.snowflake.client.jdbc.internal.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PhoneExtractingContentHandler
extends ContentHandlerDecorator {
    private Metadata metadata;
    private static final String PHONE_NUMBERS = "phonenumbers";
    private StringBuilder stringBuilder;

    public PhoneExtractingContentHandler(ContentHandler handler, Metadata metadata) {
        super(handler);
        this.metadata = metadata;
        this.stringBuilder = new StringBuilder();
    }

    protected PhoneExtractingContentHandler() {
        this(new DefaultHandler(), new Metadata());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String text = new String(Arrays.copyOfRange(ch, start, start + length));
            this.stringBuilder.append(text);
            super.characters(ch, start, length);
        }
        catch (SAXException e) {
            this.handleException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        ArrayList<String> numbers = CleanPhoneText.extractPhoneNumbers(this.stringBuilder.toString());
        for (String number : numbers) {
            this.metadata.add(PHONE_NUMBERS, number);
        }
    }
}

