/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer;

import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Encryption;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.ServiceUtils;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.GetObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3Object;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.DownloadImpl;

final class DownloadTaskImpl
implements ServiceUtils.RetryableS3DownloadTask {
    private final AmazonS3 s3;
    private final DownloadImpl download;
    private final GetObjectRequest getObjectRequest;

    DownloadTaskImpl(AmazonS3 s3, DownloadImpl download, GetObjectRequest getObjectRequest) {
        this.s3 = s3;
        this.download = download;
        this.getObjectRequest = getObjectRequest;
    }

    @Override
    public S3Object getS3ObjectStream() {
        S3Object s3Object = this.s3.getObject(this.getObjectRequest);
        this.download.setS3Object(s3Object);
        return s3Object;
    }

    @Override
    public boolean needIntegrityCheck() {
        return !(this.s3 instanceof AmazonS3Encryption) && !ServiceUtils.skipMd5CheckPerRequest(this.getObjectRequest);
    }
}

