/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.ObjectIdGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DatabindContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationConfig;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.ContextAttributes;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.Annotated;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContextualSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.FilterProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ResolvableSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.SerializerCache;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.SerializerFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.FailingSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.NullSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ClassUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.RootNameLookup;

public abstract class SerializerProvider
extends DatabindContext {
    @Deprecated
    protected static final JavaType TYPE_OBJECT = TypeFactory.defaultInstance().uncheckedSimpleType(Object.class);
    protected static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final Class<?> _serializationView;
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected final RootNameLookup _rootNames;
    protected transient ContextAttributes _attributes;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _nullValueSerializer = NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected final boolean _stdNullValueSerializer;

    public SerializerProvider() {
        this._config = null;
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
        this._rootNames = new RootNameLookup();
        this._serializationView = null;
        this._attributes = null;
        this._stdNullValueSerializer = true;
    }

    protected SerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        if (serializationConfig == null) {
            throw new NullPointerException();
        }
        this._serializerFactory = serializerFactory;
        this._config = serializationConfig;
        this._serializerCache = serializerProvider._serializerCache;
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._stdNullValueSerializer = this._nullValueSerializer == DEFAULT_NULL_KEY_SERIALIZER;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._rootNames = serializerProvider._rootNames;
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
        this._serializationView = serializationConfig.getActiveView();
        this._attributes = serializationConfig.getAttributes();
    }

    public void setDefaultKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._keySerializer = jsonSerializer;
    }

    public void setNullValueSerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullValueSerializer = jsonSerializer;
    }

    public void setNullKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullKeySerializer = jsonSerializer;
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public final Class<?> getActiveView() {
        return this._serializationView;
    }

    @Deprecated
    public final Class<?> getSerializationView() {
        return this._serializationView;
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public SerializerProvider setAttribute(Object object, Object object2) {
        this._attributes = this._attributes.withPerCallAttribute(object, object2);
        return this;
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public final boolean hasSerializationFeatures(int n) {
        return this._config.hasSerializationFeatures(n);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(javaType.getRawClass());
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(javaType.getRawClass());
            return jsonSerializer;
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(Class<?> clazz, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> clazz, boolean bl, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(clazz, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, this._config.constructType(clazz));
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType javaType, boolean bl, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(javaType, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, javaType);
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(javaType, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findKeySerializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._serializerFactory.createKeySerializer(this._config, javaType, this._keySerializer);
        return this._handleContextualResolvable(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty beanProperty) throws JsonMappingException {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> clazz) {
        return this._unknownTypeSerializer;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    @Deprecated
    public JsonSerializer<?> handleContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) throws JsonMappingException {
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<?> handlePrimaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) throws JsonMappingException {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public JsonSerializer<?> handleSecondaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) throws JsonMappingException {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public final void defaultSerializeValue(Object object, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (object == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jsonGenerator, this);
            }
        } else {
            Class<?> clazz = object.getClass();
            this.findTypedValueSerializer(clazz, true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeField(String string, Object object, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        jsonGenerator.writeFieldName(string);
        if (object == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jsonGenerator, this);
            }
        } else {
            Class<?> clazz = object.getClass();
            this.findTypedValueSerializer(clazz, true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeDateValue(long l, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(l);
        } else {
            jsonGenerator.writeString(this._dateFormat().format(new Date(l)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(date.getTime());
        } else {
            jsonGenerator.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long l, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(l));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(new Date(l)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(date.getTime()));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNull(JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (this._stdNullValueSerializer) {
            jsonGenerator.writeNull();
        } else {
            this._nullValueSerializer.serialize(null, jsonGenerator, this);
        }
    }

    protected void _reportIncompatibleRootType(Object object, JavaType javaType) throws IOException, JsonProcessingException {
        Class<?> clazz;
        if (javaType.isPrimitive() && (clazz = ClassUtil.wrapperType(javaType.getRawClass())).isAssignableFrom(object.getClass())) {
            return;
        }
        throw new JsonMappingException("Incompatible types: declared root type (" + javaType + ") vs " + object.getClass().getName());
    }

    protected JsonSerializer<Object> _findExplicitUntypedSerializer(Class<?> clazz) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.untypedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        return this._createAndCacheUntypedSerializer(clazz);
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> clazz) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(this._config.constructType(clazz));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(clazz, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType javaType) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createUntypedSerializer(JavaType javaType) throws JsonMappingException {
        return this._serializerFactory.createSerializer(this, javaType);
    }

    protected JsonSerializer<Object> _handleContextualResolvable(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) throws JsonMappingException {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    protected JsonSerializer<Object> _handleResolvable(JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return jsonSerializer;
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }
}

