/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.yammer.metrics.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ThreadPools {
    private final ConcurrentMap<String, ScheduledExecutorService> threadPools = new ConcurrentHashMap<String, ScheduledExecutorService>(100);

    ThreadPools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScheduledExecutorService newScheduledThreadPool(int poolSize, String name) {
        ScheduledExecutorService existing = (ScheduledExecutorService)this.threadPools.get(name);
        if (ThreadPools.isValidExecutor(existing)) {
            return existing;
        }
        ThreadPools threadPools = this;
        synchronized (threadPools) {
            ScheduledExecutorService lastChance = (ScheduledExecutorService)this.threadPools.get(name);
            if (ThreadPools.isValidExecutor(lastChance)) {
                return lastChance;
            }
            ScheduledExecutorService service = Executors.newScheduledThreadPool(poolSize, new NamedThreadFactory(name));
            this.threadPools.put(name, service);
            return service;
        }
    }

    private static boolean isValidExecutor(ExecutorService executor) {
        return executor != null && !executor.isShutdown() && !executor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        ThreadPools threadPools = this;
        synchronized (threadPools) {
            for (ExecutorService executor : this.threadPools.values()) {
                executor.shutdown();
            }
            this.threadPools.clear();
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

