/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.yammer.metrics.core;

public abstract class HealthCheck {
    private final String name;

    protected HealthCheck(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract Result check() throws Exception;

    public Result execute() {
        try {
            return this.check();
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            return Result.unhealthy(e);
        }
    }

    public static class Result {
        private static final Result HEALTHY = new Result(true, null, null);
        private static final int PRIME = 31;
        private final boolean healthy;
        private final String message;
        private final Throwable error;

        public static Result healthy() {
            return HEALTHY;
        }

        public static Result healthy(String message) {
            return new Result(true, message, null);
        }

        public static Result healthy(String message, Object ... args) {
            return Result.healthy(String.format(message, args));
        }

        public static Result unhealthy(String message) {
            return new Result(false, message, null);
        }

        public static Result unhealthy(String message, Object ... args) {
            return Result.unhealthy(String.format(message, args));
        }

        public static Result unhealthy(Throwable error) {
            return new Result(false, error.getMessage(), error);
        }

        private Result(boolean isHealthy, String message, Throwable error) {
            this.healthy = isHealthy;
            this.message = message;
            this.error = error;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getError() {
            return this.error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.healthy == result.healthy && !(this.error == null ? result.error != null : !this.error.equals(result.error)) && !(this.message == null ? result.message != null : !this.message.equals(result.message));
        }

        public int hashCode() {
            int result = this.healthy ? 1 : 0;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Result{isHealthy=");
            builder.append(this.healthy);
            if (this.message != null) {
                builder.append(", message=").append(this.message);
            }
            if (this.error != null) {
                builder.append(", error=").append(this.error);
            }
            builder.append('}');
            return builder.toString();
        }
    }
}

