/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.ser;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import com.snowflake.client.jdbc.internal.joda.time.LocalDateTime;
import com.snowflake.client.jdbc.internal.joda.time.format.DateTimeFormatter;
import com.snowflake.client.jdbc.internal.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDateTimeSerializer
extends JodaSerializerBase<LocalDateTime> {
    static final DateTimeFormatter format = ISODateTimeFormat.dateTime();

    public LocalDateTimeSerializer() {
        super(LocalDateTime.class);
    }

    @Override
    public void serialize(LocalDateTime dt, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeStartArray();
            jgen.writeNumber(dt.year().get());
            jgen.writeNumber(dt.monthOfYear().get());
            jgen.writeNumber(dt.dayOfMonth().get());
            jgen.writeNumber(dt.hourOfDay().get());
            jgen.writeNumber(dt.minuteOfHour().get());
            jgen.writeNumber(dt.secondOfMinute().get());
            jgen.writeNumber(dt.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(format.print(dt));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }
}

