/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.deser;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.snowflake.client.jdbc.internal.joda.time.LocalDateTime;
import com.snowflake.client.jdbc.internal.joda.time.format.DateTimeFormatter;
import com.snowflake.client.jdbc.internal.joda.time.format.ISODateTimeFormat;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateTimeDeserializer
extends JodaDeserializerBase<LocalDateTime> {
    static final DateTimeFormatter parser = ISODateTimeFormat.localDateOptionalTimeParser();

    public LocalDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    @Override
    public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_ARRAY: {
                if (!jp.isExpectedStartArrayToken()) break;
                jp.nextToken();
                int year = jp.getIntValue();
                jp.nextToken();
                int month = jp.getIntValue();
                jp.nextToken();
                int day = jp.getIntValue();
                jp.nextToken();
                int hour = jp.getIntValue();
                jp.nextToken();
                int minute = jp.getIntValue();
                jp.nextToken();
                int second = jp.getIntValue();
                jp.nextToken();
                int millisecond = 0;
                if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    millisecond = jp.getIntValue();
                    jp.nextToken();
                }
                if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "after LocalDateTime ints");
                }
                return new LocalDateTime(year, month, day, hour, minute, second, millisecond);
            }
            case VALUE_NUMBER_INT: {
                return new LocalDateTime(jp.getLongValue());
            }
            case VALUE_STRING: {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return parser.parseLocalDateTime(str);
            }
        }
        throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }
}

