/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class ClassUtil {
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return ClassUtil.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ClassUtil._addSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl) {
        if (clazz == clazz2 || clazz == null || clazz == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(clazz)) {
                return;
            }
            collection.add(clazz);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            ClassUtil._addSuperTypes(clazz3, clazz2, collection, true);
        }
        ClassUtil._addSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (clazz.isEnum()) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl) {
        try {
            if (clazz.getEnclosingMethod() != null) {
                return "local/anonymous";
            }
            if (!bl && clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        try {
            if (clazz.getEnclosingMethod() != null) {
                return null;
            }
            if (!Modifier.isStatic(clazz.getModifiers())) {
                return clazz.getEnclosingClass();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> clazz) {
        String string = clazz.getName();
        return string.startsWith("net.sf.cglib.proxy.") || string.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        int n = clazz.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int n = member.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        return clazz.getName();
    }

    public static Class<?> findClass(String string) throws ClassNotFoundException {
        if (string.indexOf(46) < 0) {
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            if ("void".equals(string)) {
                return Void.TYPE;
            }
        }
        Throwable throwable = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (Exception exception) {
                throwable = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (throwable == null) {
                throwable = ClassUtil.getRootCause(exception);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ClassNotFoundException(throwable.getMessage(), throwable);
        }
    }

    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static void throwRootCause(Throwable throwable) throws Exception {
        if ((throwable = ClassUtil.getRootCause(throwable)) instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    public static void throwAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(throwable, throwable.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalArgumentException(string, throwable);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable), string);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl) throws IllegalArgumentException {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, bl);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + exception.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl) throws IllegalArgumentException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl) {
                ClassUtil.checkAndFixAccess(constructor);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception.getMessage());
        }
        return null;
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static void checkAndFixAccess(Member member) {
        block2: {
            AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
            try {
                accessibleObject.setAccessible(true);
            }
            catch (SecurityException securityException) {
                if (accessibleObject.isAccessible()) break block2;
                Class<?> clazz = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + clazz.getName() + "; failed to set access: " + securityException.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        Class<?> clazz = enum_.getClass();
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object != null && ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(JacksonStdImpl.class) != null;
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> enumSet) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(enumSet, this.enumSetTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> enumMap) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(enumMap, this.enumMapTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object object, Field field) {
            try {
                return field.get(object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        private static Field locateField(Class<?> clazz, String string, Class<?> clazz2) {
            Field[] fieldArray;
            Field field = null;
            for (Field field2 : fieldArray = clazz.getDeclaredFields()) {
                if (!string.equals(field2.getName()) || field2.getType() != clazz2) continue;
                field = field2;
                break;
            }
            if (field == null) {
                for (Field field2 : fieldArray) {
                    if (field2.getType() != clazz2) continue;
                    if (field != null) {
                        return null;
                    }
                    field = field2;
                }
            }
            if (field != null) {
                try {
                    field.setAccessible(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return field;
        }
    }
}

