/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.core.util;

public class BufferRecycler {
    public static final int DEFAULT_WRITE_CONCAT_BUFFER_LEN = 2000;
    protected final byte[][] _byteBuffers = new byte[ByteBufferType.values().length][];
    protected final char[][] _charBuffers = new char[CharBufferType.values().length][];

    public final byte[] allocByteBuffer(ByteBufferType byteBufferType) {
        int n = byteBufferType.ordinal();
        byte[] byArray = this._byteBuffers[n];
        if (byArray == null) {
            byArray = this.balloc(byteBufferType.size);
        } else {
            this._byteBuffers[n] = null;
        }
        return byArray;
    }

    public final void releaseByteBuffer(ByteBufferType byteBufferType, byte[] byArray) {
        this._byteBuffers[byteBufferType.ordinal()] = byArray;
    }

    public final char[] allocCharBuffer(CharBufferType charBufferType) {
        return this.allocCharBuffer(charBufferType, 0);
    }

    public final char[] allocCharBuffer(CharBufferType charBufferType, int n) {
        int n2;
        char[] cArray;
        if (charBufferType.size > n) {
            n = charBufferType.size;
        }
        if ((cArray = this._charBuffers[n2 = charBufferType.ordinal()]) == null || cArray.length < n) {
            cArray = this.calloc(n);
        } else {
            this._charBuffers[n2] = null;
        }
        return cArray;
    }

    public final void releaseCharBuffer(CharBufferType charBufferType, char[] cArray) {
        this._charBuffers[charBufferType.ordinal()] = cArray;
    }

    private byte[] balloc(int n) {
        return new byte[n];
    }

    private char[] calloc(int n) {
        return new char[n];
    }

    public static enum CharBufferType {
        TOKEN_BUFFER(2000),
        CONCAT_BUFFER(2000),
        TEXT_BUFFER(200),
        NAME_COPY_BUFFER(200);

        protected final int size;

        private CharBufferType(int n2) {
            this.size = n2;
        }
    }

    public static enum ByteBufferType {
        READ_IO_BUFFER(4000),
        WRITE_ENCODING_BUFFER(4000),
        WRITE_CONCAT_BUFFER(2000),
        BASE64_CODEC_BUFFER(2000);

        protected final int size;

        private ByteBufferType(int n2) {
            this.size = n2;
        }
    }
}

