/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.parser;

import com.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ParseContext
implements Serializable {
    private static final long serialVersionUID = -5921436862145826534L;
    private final Map<String, Object> context = new HashMap<String, Object>();

    public <T> void set(Class<T> key, T value) {
        if (value != null) {
            this.context.put(key.getName(), value);
        } else {
            this.context.remove(key.getName());
        }
    }

    public <T> T get(Class<T> key) {
        return (T)this.context.get(key.getName());
    }

    public <T> T get(Class<T> key, T defaultValue) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public SAXParser getSAXParser() throws TikaException {
        SAXParser parser = this.get(SAXParser.class);
        if (parser != null) {
            return parser;
        }
        try {
            return this.getSAXParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to configure a SAX parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create a SAX parser", e);
        }
    }

    public SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = this.get(SAXParserFactory.class);
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        return factory;
    }
}

