/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.http.impl.client;

import com.snowflake.client.jdbc.internal.apache.http.HttpException;
import com.snowflake.client.jdbc.internal.apache.http.HttpHost;
import com.snowflake.client.jdbc.internal.apache.http.HttpRequest;
import com.snowflake.client.jdbc.internal.apache.http.annotation.ThreadSafe;
import com.snowflake.client.jdbc.internal.apache.http.client.ClientProtocolException;
import com.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.Configurable;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.HttpExecutionAware;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestWrapper;
import com.snowflake.client.jdbc.internal.apache.http.client.protocol.HttpClientContext;
import com.snowflake.client.jdbc.internal.apache.http.conn.ClientConnectionManager;
import com.snowflake.client.jdbc.internal.apache.http.conn.ClientConnectionRequest;
import com.snowflake.client.jdbc.internal.apache.http.conn.HttpClientConnectionManager;
import com.snowflake.client.jdbc.internal.apache.http.conn.ManagedClientConnection;
import com.snowflake.client.jdbc.internal.apache.http.conn.routing.HttpRoute;
import com.snowflake.client.jdbc.internal.apache.http.conn.scheme.SchemeRegistry;
import com.snowflake.client.jdbc.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import com.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.snowflake.client.jdbc.internal.apache.http.impl.execchain.MinimalClientExec;
import com.snowflake.client.jdbc.internal.apache.http.params.BasicHttpParams;
import com.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import com.snowflake.client.jdbc.internal.apache.http.protocol.BasicHttpContext;
import com.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import com.snowflake.client.jdbc.internal.apache.http.protocol.HttpRequestExecutor;
import com.snowflake.client.jdbc.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

