/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.util;

import com.snowflake.client.jdbc.internal.amazonaws.internal.config.InternalConfig;
import com.snowflake.client.jdbc.internal.amazonaws.util.ClassLoaderHelper;
import com.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import com.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import com.snowflake.client.jdbc.internal.apache.http.annotation.ThreadSafe;
import java.io.InputStream;
import java.util.Properties;

@ThreadSafe
public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/snowflake/client/jdbc/internal/amazonaws/sdk/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/com/snowflake/client/jdbc/internal/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        String ua = InternalConfig.Factory.getInternalConfig().getUserAgentTemplate();
        if (ua == null) {
            return "aws-sdk-java";
        }
        ua = ua.replace("{platform}", VersionInfoUtils.getPlatform().toLowerCase()).replace("{version}", VersionInfoUtils.getVersion()).replace("{os.name}", VersionInfoUtils.replaceSpaces(System.getProperty("os.name"))).replace("{os.version}", VersionInfoUtils.replaceSpaces(System.getProperty("os.version"))).replace("{java.vm.name}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name"))).replace("{java.vm.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version"))).replace("{java.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.version")));
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        String languageAndRegion = "";
        if (language != null && region != null) {
            languageAndRegion = " " + VersionInfoUtils.replaceSpaces(language) + "_" + VersionInfoUtils.replaceSpaces(region);
        }
        ua = ua.replace("{language.and.region}", languageAndRegion);
        return ua;
    }

    private static String replaceSpaces(String input) {
        return input.replace(' ', '_');
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

