/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.http.impl.client;

import com.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetrics;
import com.snowflake.client.jdbc.internal.apache.http.annotation.ThreadSafe;
import com.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import java.io.IOException;

@ThreadSafe
public class SdkHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final SdkHttpRequestRetryHandler Singleton = new SdkHttpRequestRetryHandler();

    private SdkHttpRequestRetryHandler() {
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        AWSRequestMetrics awsRequestMetrics;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry && (awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName())) != null) {
            awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.HttpClientRetryCount);
        }
        return retry;
    }
}

