/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.SFSession;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeartbeatBackground
implements Runnable {
    private static HeartbeatBackground singleton = new HeartbeatBackground();
    private static final Logger LOGGER = Logger.getLogger(HeartbeatBackground.class.getName());
    private long masterTokenValidityInSecs = 14400L;
    private long heartbeatHeadroomBeforeTokenExpiration = 600L;
    private long heartBeatIntervalInSecs = this.masterTokenValidityInSecs - this.heartbeatHeadroomBeforeTokenExpiration;
    private ScheduledExecutorService scheduler = null;
    ScheduledFuture heartbeatFuture;
    WeakHashMap<SFSession, Boolean> sessions = new WeakHashMap();
    private long lastHeartbeatStartTimeInSecs = 0L;

    public static HeartbeatBackground getInstance() {
        return singleton;
    }

    private HeartbeatBackground() {
    }

    protected synchronized void addSession(SFSession session, long masterTokenValidityInSecs) {
        boolean requireReschedule = false;
        if (masterTokenValidityInSecs < this.masterTokenValidityInSecs) {
            long oldMasterTokenValidityInSecs = this.masterTokenValidityInSecs;
            long oldHeartbeatIntervalInSecs = this.heartBeatIntervalInSecs;
            this.heartBeatIntervalInSecs = masterTokenValidityInSecs > this.heartbeatHeadroomBeforeTokenExpiration ? masterTokenValidityInSecs - this.heartbeatHeadroomBeforeTokenExpiration : masterTokenValidityInSecs / 2L;
            this.masterTokenValidityInSecs = masterTokenValidityInSecs;
            LOGGER.log(Level.FINE, "update heartbeat interval, master token validity from {0} to {1}, heart beat interval from {2} to {3}", new Object[]{oldMasterTokenValidityInSecs, this.masterTokenValidityInSecs, oldHeartbeatIntervalInSecs, this.heartBeatIntervalInSecs});
            requireReschedule = true;
        }
        this.sessions.put(session, Boolean.TRUE);
        if (this.scheduler == null) {
            LOGGER.log(Level.FINE, "create heartbeat thread pool");
            this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setName("heartbeat (" + thread.getId() + ")");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        if (this.heartbeatFuture == null) {
            LOGGER.log(Level.FINE, "schedule heartbeat task");
            this.scheduleHeartbeat();
        } else if (requireReschedule) {
            LOGGER.log(Level.FINE, "Cancel existing heartbeat task");
            if (this.heartbeatFuture.cancel(false)) {
                LOGGER.log(Level.FINE, "Canceled existing heartbeat task, reschedule");
                this.scheduleHeartbeat();
            } else {
                LOGGER.log(Level.FINE, "Failed to cancel existing heartbeat task");
            }
        }
    }

    protected synchronized void removeSession(SFSession session) {
        this.sessions.remove(session);
    }

    private void scheduleHeartbeat() {
        long elapsedSecsSinceLastHeartBeat = System.currentTimeMillis() / 1000L - this.lastHeartbeatStartTimeInSecs;
        long initialDelay = Math.max(this.heartBeatIntervalInSecs - elapsedSecsSinceLastHeartBeat, 0L);
        LOGGER.log(Level.FINE, "schedule heartbeat task with initial delay of {0} seconds", initialDelay);
        this.heartbeatFuture = this.scheduler.schedule(this, initialDelay, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastHeartbeatStartTimeInSecs = System.currentTimeMillis() / 1000L;
        HashSet<SFSession> sessionsToHeartbeat = new HashSet<SFSession>();
        Object object = this;
        synchronized (object) {
            sessionsToHeartbeat.addAll(this.sessions.keySet());
        }
        for (SFSession session : sessionsToHeartbeat) {
            try {
                session.heartbeat();
            }
            catch (Throwable ex) {
                LOGGER.log(Level.SEVERE, "heartbeat error - message=" + ex.getMessage(), ex);
            }
        }
        object = this;
        synchronized (object) {
            if (this.sessions.size() > 0) {
                LOGGER.log(Level.FINE, "schedule next heartbeat run");
                this.scheduleHeartbeat();
            } else {
                LOGGER.log(Level.FINE, "no need for heartbeat since no more sessions");
                this.heartbeatFuture = null;
            }
        }
    }
}

