/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.yammer.metrics.reporting;

import com.snowflake.client.jdbc.internal.javax.servlet.ServletConfig;
import com.snowflake.client.jdbc.internal.javax.servlet.ServletContext;
import com.snowflake.client.jdbc.internal.javax.servlet.ServletException;
import com.snowflake.client.jdbc.internal.javax.servlet.ServletRequest;
import com.snowflake.client.jdbc.internal.javax.servlet.ServletResponse;
import com.snowflake.client.jdbc.internal.javax.servlet.http.HttpServlet;
import com.snowflake.client.jdbc.internal.javax.servlet.http.HttpServletRequest;
import com.snowflake.client.jdbc.internal.javax.servlet.http.HttpServletResponse;
import com.snowflake.client.jdbc.internal.yammer.metrics.reporting.HealthCheckServlet;
import com.snowflake.client.jdbc.internal.yammer.metrics.reporting.MetricsServlet;
import com.snowflake.client.jdbc.internal.yammer.metrics.reporting.PingServlet;
import com.snowflake.client.jdbc.internal.yammer.metrics.reporting.ThreadDumpServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1363903248255082791L;
    private static final String TEMPLATE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n        \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <title>Metrics</title>\n</head>\n<body>\n  <h1>Operational Menu</h1>\n  <ul>\n    <li><a href=\"{0}{1}?pretty=true\">Metrics</a></li>\n    <li><a href=\"{2}{3}\">Ping</a></li>\n    <li><a href=\"{4}{5}\">Threads</a></li>\n    <li><a href=\"{6}{7}\">Healthcheck</a></li>\n  </ul>\n</body>\n</html>";
    public static final String DEFAULT_HEALTHCHECK_URI = "/healthcheck";
    public static final String DEFAULT_METRICS_URI = "/metrics";
    public static final String DEFAULT_PING_URI = "/ping";
    public static final String DEFAULT_THREADS_URI = "/threads";
    private static final String CONTENT_TYPE = "text/html";
    private final HealthCheckServlet healthCheckServlet;
    private final MetricsServlet metricsServlet;
    private final PingServlet pingServlet;
    private final ThreadDumpServlet threadDumpServlet;
    private String metricsUri;
    private String pingUri;
    private String threadsUri;
    private String healthcheckUri;
    private String contextPath;

    public AdminServlet() {
        this(new HealthCheckServlet(), new MetricsServlet(), new PingServlet(), new ThreadDumpServlet(), DEFAULT_HEALTHCHECK_URI, DEFAULT_METRICS_URI, DEFAULT_PING_URI, DEFAULT_THREADS_URI);
    }

    public AdminServlet(HealthCheckServlet healthCheckServlet, MetricsServlet metricsServlet, PingServlet pingServlet, ThreadDumpServlet threadDumpServlet, String healthcheckUri, String metricsUri, String pingUri, String threadsUri) {
        this.healthCheckServlet = healthCheckServlet;
        this.metricsServlet = metricsServlet;
        this.pingServlet = pingServlet;
        this.threadDumpServlet = threadDumpServlet;
        this.metricsUri = metricsUri;
        this.pingUri = pingUri;
        this.threadsUri = threadsUri;
        this.healthcheckUri = healthcheckUri;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.healthCheckServlet.init(config);
        this.metricsServlet.init(config);
        this.pingServlet.init(config);
        this.threadDumpServlet.init(config);
        ServletContext context = config.getServletContext();
        this.contextPath = context.getContextPath();
        this.metricsUri = AdminServlet.getParam(config.getInitParameter("metrics-uri"), this.metricsUri);
        this.pingUri = AdminServlet.getParam(config.getInitParameter("ping-uri"), this.pingUri);
        this.threadsUri = AdminServlet.getParam(config.getInitParameter("threads-uri"), this.threadsUri);
        this.healthcheckUri = AdminServlet.getParam(config.getInitParameter("healthcheck-uri"), this.healthcheckUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        String uri = req.getPathInfo();
        String path = this.contextPath + req.getServletPath();
        if (uri == null || uri.equals("/")) {
            resp.setStatus(200);
            resp.setContentType(CONTENT_TYPE);
            PrintWriter writer = resp.getWriter();
            try {
                writer.println(MessageFormat.format(TEMPLATE, path, this.metricsUri, path, this.pingUri, path, this.threadsUri, path, this.healthcheckUri));
            }
            finally {
                writer.close();
            }
        } else if (uri.equals(this.healthcheckUri)) {
            this.healthCheckServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.startsWith(this.metricsUri)) {
            this.metricsServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.equals(this.pingUri)) {
            this.pingServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.equals(this.threadsUri)) {
            this.threadDumpServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendError(404);
        }
    }

    private static String getParam(String initParam, String defaultValue) {
        return initParam == null ? defaultValue : initParam;
    }
}

