/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MapperFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.NoClass;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.MapperConfig;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.Annotated;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ClassUtil;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;

public abstract class DatabindContext {
    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this.getConfig().isEnabled(mapperFeature);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.getConfig().canOverrideAccessModifiers();
    }

    public abstract Class<?> getActiveView();

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        return this.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType.getRawClass() == clazz) {
            return javaType;
        }
        return this.getConfig().constructSpecializedType(javaType, clazz);
    }

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        ObjectIdGenerator<?> objectIdGenerator;
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator2 = objectIdGenerator = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, annotated, clazz);
        if (objectIdGenerator == null) {
            objectIdGenerator = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object object) throws JsonMappingException {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || clazz == NoClass.class) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(mapperConfig, annotated, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return converter;
    }
}

