/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyMetadata;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyName;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Annotations;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Named;
import java.lang.annotation.Annotation;

public interface BeanProperty
extends Named {
    @Override
    public String getName();

    public PropertyName getFullName();

    public JavaType getType();

    public PropertyName getWrapperName();

    public PropertyMetadata getMetadata();

    public boolean isRequired();

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public <A extends Annotation> A getContextAnnotation(Class<A> var1);

    public AnnotatedMember getMember();

    public void depositSchemaProperty(JsonObjectFormatVisitor var1) throws JsonMappingException;

    public static class Std
    implements BeanProperty {
        protected final PropertyName _name;
        protected final JavaType _type;
        protected final PropertyName _wrapperName;
        protected final PropertyMetadata _metadata;
        protected final AnnotatedMember _member;
        protected final Annotations _contextAnnotations;

        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, Annotations annotations, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this._name = propertyName;
            this._type = javaType;
            this._wrapperName = propertyName2;
            this._metadata = propertyMetadata;
            this._member = annotatedMember;
            this._contextAnnotations = annotations;
        }

        @Deprecated
        public Std(String string, JavaType javaType, PropertyName propertyName, Annotations annotations, AnnotatedMember annotatedMember, boolean bl) {
            this(new PropertyName(string), javaType, propertyName, annotations, annotatedMember, bl ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL);
        }

        public Std withType(JavaType javaType) {
            return new Std(this._name, javaType, this._wrapperName, this._contextAnnotations, this._member, this._metadata);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return this._member == null ? null : (A)this._member.getAnnotation(clazz);
        }

        @Override
        public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
            return this._contextAnnotations == null ? null : (A)this._contextAnnotations.get(clazz);
        }

        @Override
        public String getName() {
            return this._name.getSimpleName();
        }

        @Override
        public PropertyName getFullName() {
            return this._name;
        }

        @Override
        public JavaType getType() {
            return this._type;
        }

        @Override
        public PropertyName getWrapperName() {
            return this._wrapperName;
        }

        @Override
        public boolean isRequired() {
            return this._metadata.isRequired();
        }

        @Override
        public PropertyMetadata getMetadata() {
            return this._metadata;
        }

        @Override
        public AnnotatedMember getMember() {
            return this._member;
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor) {
            throw new UnsupportedOperationException("Instances of " + this.getClass().getName() + " should not get visited");
        }
    }
}

