/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import com.snowflake.client.jdbc.internal.amazonaws.Request;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListKeysRequest;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListKeysRequestMarshaller
implements Marshaller<Request<ListKeysRequest>, ListKeysRequest> {
    @Override
    public Request<ListKeysRequest> marshall(ListKeysRequest listKeysRequest) {
        if (listKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListKeysRequest> request = new DefaultRequest<ListKeysRequest>(listKeysRequest, "AWSKMS");
        String target = "TrentService.ListKeys";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listKeysRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listKeysRequest.getLimit());
            }
            if (listKeysRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listKeysRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

