/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.http;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpResponse;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.IOUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.XpathUtils;
import com.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import com.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        Document document;
        String content = "";
        try {
            content = IOUtils.toString(errorResponse.getContent());
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Failed in reading the error response", ex);
            }
            return this.newAmazonServiceException("Unable to unmarshall error response", errorResponse, ex);
        }
        try {
            document = XpathUtils.documentFrom(content);
        }
        catch (Exception e) {
            return this.newAmazonServiceException(String.format("Unable to unmarshall error response (%s)", content), errorResponse, e);
        }
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        throw new AmazonClientException("Unable to unmarshall error response from service");
    }

    private AmazonServiceException newAmazonServiceException(String errmsg, HttpResponse httpResponse, Exception readFailure) {
        AmazonServiceException exception = new AmazonServiceException(errmsg, readFailure);
        int statusCode = httpResponse.getStatusCode();
        exception.setErrorCode(statusCode + " " + httpResponse.getStatusText());
        exception.setErrorType(AmazonServiceException.ErrorType.Unknown);
        exception.setStatusCode(statusCode);
        return exception;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

