/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.Event;
import com.snowflake.client.core.HttpUtil;
import com.snowflake.client.core.SFSessionProperty;
import com.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import com.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import com.snowflake.client.jdbc.internal.apache.http.entity.ByteArrayEntity;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import com.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class Incident
extends Event {
    private static final Logger logger = Logger.getLogger(Incident.class.getName());
    private static final String SF_PATH_CREATE_INCIDENT = "/incidents/create-incident";
    private static final Random randomGenerator = new Random();
    private final Map<String, Object> incident;

    public Incident(Event.EventType type, Map<String, Object> incident) {
        super(type, "");
        this.incident = incident;
    }

    public static String generateIncidentId() {
        return Integer.toString(randomGenerator.nextInt(8999999) + 1000000);
    }

    @Override
    public void flush() {
        URI incidentURI;
        String json;
        ObjectMapper mapper = new ObjectMapper();
        logger.log(Level.FINE, "Flushing incident, type={0}, msg={1}", new Object[]{this.getType().getDescription(), this.getMessage()});
        String sessionToken = (String)this.incident.get("Token");
        String serverUrl = (String)this.incident.get(SFSessionProperty.SERVER_URL.getPropertyKey());
        Map incidentInfo = (Map)this.incident.get("incidentInfo");
        if (sessionToken == null || serverUrl == null) {
            logger.log(Level.FINE, "Incident registration failed, sessionToken or serverUrl not specified");
            return;
        }
        try {
            json = mapper.writeValueAsString(incidentInfo);
        }
        catch (JsonProcessingException ex) {
            logger.log(Level.SEVERE, "Incident registration failed, could not map incident report to json string. Exception: {0}", ex.getMessage());
            return;
        }
        Preconditions.checkNotNull(json);
        HttpClient httpClient = HttpUtil.getHttpClient();
        try {
            URIBuilder uriBuilder = new URIBuilder(serverUrl);
            uriBuilder.setPath(SF_PATH_CREATE_INCIDENT);
            incidentURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Incident registration failed, URI could not be built. Exception: {0}", ex.getMessage());
            return;
        }
        logger.log(Level.FINE, "Creating new HTTP request, token={0}, URL={1}", new Object[]{sessionToken, incidentURI.toString()});
        HttpPost postRequest = new HttpPost(incidentURI);
        postRequest.setHeader("Authorization", "Snowflake Token=\"" + sessionToken + "\"");
        ByteArrayEntity input = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] bytes = json.getBytes("UTF-8");
            gzos.write(bytes);
            gzos.finish();
            input = new ByteArrayEntity(baos.toByteArray());
            input.setContentType("application/json");
        }
        catch (IOException exc) {
            logger.log(Level.WARNING, "Incident registration failed, could not compress payload. Exception: {0}", exc.getMessage());
        }
        postRequest.setEntity(input);
        postRequest.addHeader("content-encoding", "gzip");
        String response = null;
        try {
            response = HttpUtil.executeRequest(postRequest, httpClient, 1000, 0, null);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Incident registration request failed, response: {0}, exception: {1}", new Object[]{response, ex.getMessage()});
        }
    }
}

