/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SfTimestampUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.arrow.StructuredTypeDateTimeConverter;
import net.snowflake.client.core.json.BooleanConverter;
import net.snowflake.client.core.json.BytesConverter;
import net.snowflake.client.core.json.DateTimeConverter;
import net.snowflake.client.core.json.NumberConverter;
import net.snowflake.client.core.json.StringConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.util.Converter;

public class Converters {
    private final BooleanConverter booleanConverter = new BooleanConverter();
    private final NumberConverter numberConverter = new NumberConverter();
    private final DateTimeConverter dateTimeConverter;
    private final BytesConverter bytesConverter;
    private final StringConverter stringConverter;
    private final StructuredTypeDateTimeConverter structuredTypeDateTimeConverter;

    public Converters(TimeZone sessionTimeZone, SFBaseSession session, long resultVersion, boolean honorClientTZForTimestampNTZ, boolean treatNTZAsUTC, boolean useSessionTimezone, boolean formatDateWithTimeZone, SFBinaryFormat binaryFormatter, SnowflakeDateTimeFormat dateFormatter, SnowflakeDateTimeFormat timeFormatter, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter) {
        this.dateTimeConverter = new DateTimeConverter(sessionTimeZone, session, resultVersion, honorClientTZForTimestampNTZ, treatNTZAsUTC, useSessionTimezone, formatDateWithTimeZone);
        this.bytesConverter = new BytesConverter(this);
        this.stringConverter = new StringConverter(sessionTimeZone, binaryFormatter, dateFormatter, timeFormatter, timestampNTZFormatter, timestampLTZFormatter, timestampTZFormatter, resultVersion, session, this);
        this.structuredTypeDateTimeConverter = new StructuredTypeDateTimeConverter(sessionTimeZone, resultVersion, honorClientTZForTimestampNTZ, treatNTZAsUTC, useSessionTimezone, formatDateWithTimeZone);
    }

    @SnowflakeJdbcInternalApi
    public Converters(SFBaseSession session, SnowflakeResultSetSerializableV1 resultSetSerializable) {
        this(resultSetSerializable.getTimeZone(), session, resultSetSerializable.getResultVersion(), resultSetSerializable.isHonorClientTZForTimestampNTZ(), resultSetSerializable.getTreatNTZAsUTC(), resultSetSerializable.getUseSessionTimezone(), resultSetSerializable.getFormatDateWithTimeZone(), resultSetSerializable.getBinaryFormatter(), resultSetSerializable.getDateFormatter(), resultSetSerializable.getTimeFormatter(), resultSetSerializable.getTimestampNTZFormatter(), resultSetSerializable.getTimestampLTZFormatter(), resultSetSerializable.getTimestampTZFormatter());
    }

    public BooleanConverter getBooleanConverter() {
        return this.booleanConverter;
    }

    public NumberConverter getNumberConverter() {
        return this.numberConverter;
    }

    public DateTimeConverter getDateTimeConverter() {
        return this.dateTimeConverter;
    }

    public BytesConverter getBytesConverter() {
        return this.bytesConverter;
    }

    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    public StructuredTypeDateTimeConverter getStructuredTypeDateTimeConverter() {
        return this.structuredTypeDateTimeConverter;
    }

    @SnowflakeJdbcInternalApi
    public Converter integerConverter(int columnType) {
        return value -> this.getNumberConverter().getInt(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter smallIntConverter(int columnType) {
        return value -> this.getNumberConverter().getShort(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter tinyIntConverter(int columnType) {
        return value -> this.getNumberConverter().getByte(value);
    }

    @SnowflakeJdbcInternalApi
    public Converter bigIntConverter(int columnType) {
        return value -> this.getNumberConverter().getBigInt(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter longConverter(int columnType) {
        return value -> this.getNumberConverter().getLong(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter bigDecimalConverter(int columnType) {
        return value -> this.getNumberConverter().getBigDecimal(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter floatConverter(int columnType) {
        return value -> Float.valueOf(this.getNumberConverter().getFloat(value, columnType));
    }

    @SnowflakeJdbcInternalApi
    public Converter doubleConverter(int columnType) {
        return value -> this.getNumberConverter().getDouble(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter bytesConverter(int columnType, int scale) {
        return value -> {
            byte[] primitiveArray = this.getBytesConverter().getBytes(value, columnType, -2, scale);
            Byte[] newByteArray = new Byte[primitiveArray.length];
            Arrays.setAll(newByteArray, n -> primitiveArray[n]);
            return newByteArray;
        };
    }

    @SnowflakeJdbcInternalApi
    public Converter varcharConverter(int columnType, int columnSubType, int scale) {
        return value -> this.getStringConverter().getString(value, columnType, columnSubType, scale);
    }

    @SnowflakeJdbcInternalApi
    public Converter booleanConverter(int columnType) {
        return value -> this.getBooleanConverter().getBoolean(value, columnType);
    }

    @SnowflakeJdbcInternalApi
    public Converter dateStringConverter(SFBaseSession session) {
        return value -> {
            SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat((String)session.getCommonParameters().get("DATE_OUTPUT_FORMAT"));
            SFTimestamp timestamp = formatter.parse((String)value);
            return Date.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalDate());
        };
    }

    @SnowflakeJdbcInternalApi
    public Converter dateFromIntConverter(TimeZone tz) {
        return value -> this.structuredTypeDateTimeConverter.getDate((Integer)value, tz);
    }

    @SnowflakeJdbcInternalApi
    public Converter timeFromStringConverter(SFBaseSession session) {
        return value -> {
            SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat((String)session.getCommonParameters().get("TIME_OUTPUT_FORMAT"));
            SFTimestamp timestamp = formatter.parse((String)value);
            return Time.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalTime());
        };
    }

    public Converter timeFromIntConverter(int scale) {
        return value -> this.structuredTypeDateTimeConverter.getTime((Long)value, scale);
    }

    @SnowflakeJdbcInternalApi
    public Converter timestampFromStringConverter(int columnSubType, int columnType, int scale, SFBaseSession session, TimeZone tz, TimeZone sessionTimezone) {
        return value -> {
            Timestamp result = SfTimestampUtil.getTimestampFromType(columnSubType, (String)value, session, sessionTimezone, tz);
            if (result != null) {
                return result;
            }
            return this.getDateTimeConverter().getTimestamp(value, columnType, columnSubType, TimeZone.getDefault(), scale);
        };
    }

    public Converter timestampFromStructConverter(int columnType, int columnSubType, TimeZone tz, int scale) {
        return value -> this.structuredTypeDateTimeConverter.getTimestamp((Map)value, columnType, columnSubType, tz, scale);
    }

    @SnowflakeJdbcInternalApi
    public Converter structConverter(ObjectMapper objectMapper) {
        return value -> {
            try {
                return objectMapper.readValue((String)value, Map.class);
            }
            catch (JsonProcessingException e) {
                throw new SFException(e, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
            }
        };
    }

    @SnowflakeJdbcInternalApi
    public Converter arrayConverter(ObjectMapper objectMapper) {
        return value -> {
            try {
                return objectMapper.readValue((String)value, Map[].class);
            }
            catch (JsonProcessingException e) {
                throw new SFException(e, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
            }
        };
    }
}

