/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import net.minidev.json.JSONObject;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.AwsAttestationService;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestationCreator;
import net.snowflake.client.core.auth.wif.WorkloadIdentityProviderType;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class AwsIdentityAttestationCreator
implements WorkloadIdentityAttestationCreator {
    private static final SFLogger logger = SFLoggerFactory.getLogger(AwsIdentityAttestationCreator.class);
    public static final String API_VERSION = "2011-06-15";
    public static final String GET_CALLER_IDENTITY_ACTION = "GetCallerIdentity";
    private final AwsAttestationService attestationService;

    public AwsIdentityAttestationCreator(AwsAttestationService attestationService) {
        this.attestationService = attestationService;
    }

    @Override
    public WorkloadIdentityAttestation createAttestation() {
        logger.debug("Creating AWS identity attestation...", new Object[0]);
        AWSCredentials awsCredentials = this.attestationService.getAWSCredentials();
        if (awsCredentials == null) {
            logger.debug("No AWS credentials were found.", new Object[0]);
            return null;
        }
        String region = this.attestationService.getAWSRegion();
        if (region == null) {
            logger.debug("No AWS region was found.", new Object[0]);
            return null;
        }
        String arn = this.attestationService.getArn();
        if (arn == null) {
            logger.debug("No Caller Identity was found.", new Object[0]);
            return null;
        }
        String stsHostname = String.format("sts.%s.amazonaws.com", region);
        Request<Void> request = this.createStsRequest(stsHostname);
        this.attestationService.signRequestWithSigV4(request, awsCredentials);
        String credential = this.createBase64EncodedRequestCredential(request);
        return new WorkloadIdentityAttestation(WorkloadIdentityProviderType.AWS, credential, Collections.singletonMap("arn", arn));
    }

    private Request<Void> createStsRequest(String hostname) {
        DefaultRequest request = new DefaultRequest("sts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setEndpoint(URI.create(String.format("https://%s?Action=%s&Version=%s", hostname, GET_CALLER_IDENTITY_ACTION, API_VERSION)));
        request.addParameter("Action", GET_CALLER_IDENTITY_ACTION);
        request.addParameter("Version", API_VERSION);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        request.addHeader("Host", hostname);
        request.addHeader("X-Snowflake-Audience", "snowflakecomputing.com");
        return request;
    }

    private String createBase64EncodedRequestCredential(Request<Void> request) {
        JSONObject assertionJson = new JSONObject();
        JSONObject headers = new JSONObject();
        headers.putAll(request.getHeaders());
        assertionJson.put((Object)"url", (Object)request.getEndpoint().toString());
        assertionJson.put((Object)"method", (Object)request.getHttpMethod().toString());
        assertionJson.put((Object)"headers", (Object)headers);
        String assertionJsonString = assertionJson.toString();
        return Base64.getEncoder().encodeToString(assertionJsonString.getBytes(StandardCharsets.UTF_8));
    }
}

