/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.oauth;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.oauth.AccessTokenProvider;
import net.snowflake.client.core.auth.oauth.AuthorizationCodeRedirectRequestHandler;
import net.snowflake.client.core.auth.oauth.DPoPUtil;
import net.snowflake.client.core.auth.oauth.OAuthUtil;
import net.snowflake.client.core.auth.oauth.StateProvider;
import net.snowflake.client.core.auth.oauth.TokenResponseDTO;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeUseDPoPNonceException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;

@SnowflakeJdbcInternalApi
public class OAuthAuthorizationCodeAccessTokenProvider
implements AccessTokenProvider {
    private static final SFLogger logger = SFLoggerFactory.getLogger(OAuthAuthorizationCodeAccessTokenProvider.class);
    static final String DEFAULT_REDIRECT_HOST = "http://127.0.0.1";
    static final String DEFAULT_REDIRECT_URI_ENDPOINT = "/";
    private final SessionUtilExternalBrowser.AuthExternalBrowserHandlers browserHandler;
    private final StateProvider<String> stateProvider;
    private final DPoPUtil dpopUtil;
    private final long browserAuthorizationTimeoutSeconds;

    public OAuthAuthorizationCodeAccessTokenProvider(SessionUtilExternalBrowser.AuthExternalBrowserHandlers browserHandler, StateProvider<String> stateProvider, long browserAuthorizationTimeoutSeconds) throws SFException {
        this.browserHandler = browserHandler;
        this.stateProvider = stateProvider;
        this.dpopUtil = new DPoPUtil();
        this.browserAuthorizationTimeoutSeconds = browserAuthorizationTimeoutSeconds;
    }

    @Override
    public TokenResponseDTO getAccessToken(SFLoginInput loginInput) throws SFException {
        try {
            logger.info("Starting OAuth authorization code authentication flow...", new Object[0]);
            CodeVerifier pkceVerifier = new CodeVerifier();
            URI redirectUri = OAuthUtil.buildRedirectUri(loginInput.getOauthLoginInput());
            AuthorizationCode authorizationCode = this.requestAuthorizationCode(loginInput, pkceVerifier, redirectUri);
            return this.exchangeAuthorizationCodeForAccessToken(loginInput, authorizationCode, pkceVerifier, redirectUri, null, false);
        }
        catch (Exception e) {
            logger.error("Error during OAuth authorization code flow. Verify configuration passed to driver and IdP (URLs, grant types, scope, etc.)", e);
            throw new SFException(e, ErrorCode.OAUTH_AUTHORIZATION_CODE_FLOW_ERROR, e.getMessage());
        }
    }

    @Override
    public String getDPoPPublicKey() {
        return this.dpopUtil.getPublicKey();
    }

    private AuthorizationCode requestAuthorizationCode(SFLoginInput loginInput, CodeVerifier pkceVerifier, URI redirectUri) throws SFException, IOException {
        State state = new State(this.stateProvider.getState());
        AuthorizationRequest request = this.buildAuthorizationRequest(loginInput, pkceVerifier, state, redirectUri);
        URI authorizeRequestURI = request.toURI();
        HttpServer httpServer = OAuthAuthorizationCodeAccessTokenProvider.createHttpServer(redirectUri);
        CompletableFuture<String> codeFuture = OAuthAuthorizationCodeAccessTokenProvider.setupRedirectURIServerForAuthorizationCode(httpServer, state);
        logger.debug("Waiting for authorization code redirection to {}...", redirectUri);
        return this.letUserAuthorize(authorizeRequestURI, codeFuture, httpServer);
    }

    private TokenResponseDTO exchangeAuthorizationCodeForAccessToken(SFLoginInput loginInput, AuthorizationCode authorizationCode, CodeVerifier pkceVerifier, URI redirectUri, String dpopNonce, boolean retried) throws SFException {
        try {
            HttpRequestBase request = this.buildTokenRequest(loginInput, authorizationCode, pkceVerifier, redirectUri, dpopNonce);
            return OAuthUtil.sendTokenRequest(request, loginInput);
        }
        catch (SnowflakeUseDPoPNonceException e) {
            logger.debug("Received \"use_dpop_nonce\" error from IdP while performing token request", new Object[0]);
            if (!retried) {
                logger.debug("Retrying token request with DPoP nonce included...", new Object[0]);
                return this.exchangeAuthorizationCodeForAccessToken(loginInput, authorizationCode, pkceVerifier, redirectUri, e.getNonce(), true);
            }
            logger.debug("Skipping DPoP nonce retry as it has been already retried", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error during making OAuth access token request", e);
            throw new SFException(e, ErrorCode.OAUTH_AUTHORIZATION_CODE_FLOW_ERROR, e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthorizationCode letUserAuthorize(URI authorizeRequestURI, CompletableFuture<String> codeFuture, HttpServer httpServer) throws SFException {
        AuthorizationCode authorizationCode;
        try {
            logger.debug("Opening browser for authorization code request to: {}", authorizeRequestURI.getAuthority() + authorizeRequestURI.getPath());
            this.browserHandler.openBrowser(authorizeRequestURI.toString());
            String code = codeFuture.get(this.browserAuthorizationTimeoutSeconds, TimeUnit.SECONDS);
            authorizationCode = new AuthorizationCode(code);
        }
        catch (TimeoutException e) {
            try {
                throw new SFException(e, ErrorCode.OAUTH_AUTHORIZATION_CODE_FLOW_ERROR, "Authorization request timed out. Snowflake driver did not receive authorization code back to the redirect URI. Verify your security integration and driver configuration.");
                catch (Exception e2) {
                    throw new SFException(e2, ErrorCode.OAUTH_AUTHORIZATION_CODE_FLOW_ERROR, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                logger.debug("Stopping OAuth redirect URI server @ {}", httpServer.getAddress());
                httpServer.stop(1);
                throw throwable;
            }
        }
        logger.debug("Stopping OAuth redirect URI server @ {}", httpServer.getAddress());
        httpServer.stop(1);
        return authorizationCode;
    }

    private static CompletableFuture<String> setupRedirectURIServerForAuthorizationCode(HttpServer httpServer, State expectedState) {
        CompletableFuture<String> authorizationCodeFuture = new CompletableFuture<String>();
        httpServer.createContext(DEFAULT_REDIRECT_URI_ENDPOINT, exchange -> {
            Map<String, String> urlParams = URLEncodedUtils.parse((URI)exchange.getRequestURI(), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(urlParams, authorizationCodeFuture, expectedState);
            exchange.sendResponseHeaders(200, response.length());
            exchange.getResponseBody().write(response.getBytes(StandardCharsets.UTF_8));
            exchange.getResponseBody().close();
        });
        logger.debug("Starting OAuth redirect URI server @ {}", httpServer.getAddress());
        httpServer.start();
        return authorizationCodeFuture;
    }

    private static HttpServer createHttpServer(URI redirectUri) throws IOException {
        return HttpServer.create(new InetSocketAddress(redirectUri.getHost(), redirectUri.getPort()), 0);
    }

    private AuthorizationRequest buildAuthorizationRequest(SFLoginInput loginInput, CodeVerifier pkceVerifier, State state, URI redirectUri) throws SFException {
        SFOauthLoginInput oauthLoginInput = loginInput.getOauthLoginInput();
        ClientID clientID = new ClientID(oauthLoginInput.getClientId());
        String scope = OAuthUtil.getScope(loginInput.getOauthLoginInput(), loginInput.getRole());
        AuthorizationRequest.Builder builder = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), clientID).scope(new Scope(new String[]{scope})).state(state).redirectionURI(redirectUri).codeChallenge(pkceVerifier, CodeChallengeMethod.S256).endpointURI(OAuthUtil.getAuthorizationUrl(loginInput.getOauthLoginInput(), loginInput.getServerUrl()));
        if (loginInput.isDPoPEnabled()) {
            builder.dPoPJWKThumbprintConfirmation(new DPoPUtil().getThumbprint());
        }
        return builder.build();
    }

    private HttpRequestBase buildTokenRequest(SFLoginInput loginInput, AuthorizationCode authorizationCode, CodeVerifier pkceVerifier, URI redirectUri, String dpopNonce) throws SFException {
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authorizationCode, redirectUri, pkceVerifier);
        ClientSecretBasic clientAuthentication = new ClientSecretBasic(new ClientID(loginInput.getOauthLoginInput().getClientId()), new Secret(loginInput.getOauthLoginInput().getClientSecret()));
        Scope scope = new Scope(new String[]{OAuthUtil.getScope(loginInput.getOauthLoginInput(), loginInput.getRole())});
        TokenRequest.Builder tokenRequestBuilder = new TokenRequest.Builder(OAuthUtil.getTokenRequestUrl(loginInput.getOauthLoginInput(), loginInput.getServerUrl()), (ClientAuthentication)clientAuthentication, (AuthorizationGrant)codeGrant).scope(scope);
        if (loginInput.getOauthLoginInput().getEnableSingleUseRefreshTokens()) {
            tokenRequestBuilder.customParameter("enable_single_use_refresh_tokens", new String[]{"true"});
        }
        TokenRequest tokenRequest = tokenRequestBuilder.build();
        HTTPRequest tokenHttpRequest = tokenRequest.toHTTPRequest();
        HttpRequestBase convertedTokenRequest = OAuthUtil.convertToBaseRequest(tokenHttpRequest);
        if (loginInput.isDPoPEnabled()) {
            this.dpopUtil.addDPoPProofHeaderToRequest(convertedTokenRequest, dpopNonce);
        }
        return convertedTokenRequest;
    }
}

