/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.CancellationReason;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.QueryContextDTO;
import net.snowflake.client.core.QueryExecDTO;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;

public class StmtUtil {
    static final EventHandler eventHandler = EventUtil.getEventHandlerInstance();
    static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    static final String SF_PATH_QUERY_V1 = "/queries/v1/query-request";
    private static final String SF_PATH_ABORT_REQUEST_V1 = "/queries/v1/abort-request";
    private static final String SF_PATH_QUERY_RESULT = "/queries/%s/result";
    private static final String SF_QUERY_COMBINE_DESCRIBE_EXECUTE = "combinedDescribe";
    static final String SF_MEDIA_TYPE = "application/snowflake";
    static final int SF_CANCELING_RETRY_TIMEOUT_IN_MILLIS = 600000;
    private static final SFLogger logger = SFLoggerFactory.getLogger(StmtUtil.class);

    public static StmtOutput execute(StmtInput stmtInput, ExecTimeTelemetryData execTimeData) throws SFException, SnowflakeSQLException {
        HttpPost httpRequest = null;
        AssertUtil.assertTrue(stmtInput.serverUrl != null, "Missing server url for statement execution");
        AssertUtil.assertTrue(stmtInput.sql != null, "Missing sql for statement execution");
        AssertUtil.assertTrue(stmtInput.requestId != null, "Missing request id for statement execution");
        AssertUtil.assertTrue(stmtInput.sequenceId >= 0, "Negative sequence id for statement execution");
        AssertUtil.assertTrue(stmtInput.mediaType != null, "Missing media type for statement execution");
        try {
            String resultAsString = null;
            if (stmtInput.retry && stmtInput.prevGetResultURL != null) {
                logger.debug("Retrying statement execution with get result URL: {}", stmtInput.prevGetResultURL);
            } else {
                ByteArrayEntity input;
                URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
                uriBuilder.setPath(SF_PATH_QUERY_V1);
                uriBuilder.addParameter("requestId", stmtInput.requestId);
                if (stmtInput.combineDescribe) {
                    uriBuilder.addParameter(SF_QUERY_COMBINE_DESCRIBE_EXECUTE, Boolean.TRUE.toString());
                }
                httpRequest = new HttpPost(uriBuilder.build());
                HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)httpRequest, stmtInput.additionalHttpHeadersForSnowsight);
                QueryExecDTO sqlJsonBody = new QueryExecDTO(stmtInput.sql, stmtInput.describeOnly, stmtInput.sequenceId, stmtInput.bindValues, stmtInput.bindStage, stmtInput.parametersMap, stmtInput.queryContextDTO, stmtInput.querySubmissionTime, stmtInput.describeOnly || stmtInput.internal, stmtInput.asyncExec);
                if (!stmtInput.describeOnly) {
                    sqlJsonBody.setDescribedJobId(stmtInput.describedJobId);
                }
                String queryContextDTO = mapper.writeValueAsString((Object)stmtInput.queryContextDTO);
                logger.debug("queryContextDTO: {}", queryContextDTO);
                String json = mapper.writeValueAsString((Object)sqlJsonBody);
                logger.debug("JSON: {}", json);
                if (!stmtInput.httpClientSettingsKey.getGzipDisabled().booleanValue()) {
                    execTimeData.setGzipStart();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    byte[] bytes = json.getBytes("UTF-8");
                    gzos.write(bytes);
                    gzos.finish();
                    input = new ByteArrayEntity(baos.toByteArray());
                    httpRequest.addHeader("content-encoding", "gzip");
                    execTimeData.setGzipEnd();
                } else {
                    input = new ByteArrayEntity(json.getBytes("UTF-8"));
                }
                input.setContentType("application/json");
                httpRequest.setEntity((HttpEntity)input);
                httpRequest.addHeader("accept", stmtInput.mediaType);
                httpRequest.setHeader("Authorization", "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
                StmtUtil.setServiceNameHeader(stmtInput, (HttpRequestBase)httpRequest);
                eventHandler.triggerStateTransition(BasicEvent.QueryState.SENDING_QUERY, String.format(BasicEvent.QueryState.SENDING_QUERY.getArgString(), stmtInput.requestId));
                resultAsString = HttpUtil.executeRequest((HttpRequestBase)httpRequest, stmtInput.networkTimeoutInMillis / 1000, stmtInput.socketTimeout, 0, stmtInput.maxRetries, stmtInput.injectSocketTimeout, stmtInput.canceling, true, false, stmtInput.httpClientSettingsKey, execTimeData);
            }
            StmtOutput stmtOutput = StmtUtil.pollForOutput(resultAsString, stmtInput, httpRequest, execTimeData);
            return stmtOutput;
        }
        catch (Exception ex) {
            if (!(ex instanceof SnowflakeSQLException)) {
                if (ex instanceof IOException) {
                    logger.error("IOException encountered", ex);
                    throw new SFException(ex, ErrorCode.NETWORK_ERROR, "Exception encountered when executing statement: " + ex.getLocalizedMessage());
                }
                logger.error("Exception encountered", ex);
                throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
            }
            throw (SnowflakeSQLException)ex;
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
    }

    private static void setServiceNameHeader(StmtInput stmtInput, HttpRequestBase httpRequest) {
        if (!SnowflakeUtil.isNullOrEmpty(stmtInput.serviceName)) {
            httpRequest.setHeader("X-Snowflake-Service", stmtInput.serviceName);
        }
    }

    private static StmtOutput pollForOutput(String resultAsString, StmtInput stmtInput, HttpPost httpRequest, ExecTimeTelemetryData execTimeData) throws SFException, SnowflakeSQLException {
        JsonNode pingPongResponseJson;
        boolean queryInProgress;
        boolean firstResponse = !stmtInput.retry;
        String previousGetResultPath = stmtInput.retry ? stmtInput.prevGetResultURL : null;
        int retries = 0;
        int MAX_RETRIES = 3;
        do {
            pingPongResponseJson = null;
            if (resultAsString != null) {
                try {
                    pingPongResponseJson = mapper.readTree(resultAsString);
                }
                catch (Exception ex) {
                    logger.error("Bad result json: {}, JSON parsing exception: {}, http request: {}", resultAsString, ex.getLocalizedMessage(), httpRequest);
                    logger.error("Exception stack trace", ex);
                }
            }
            eventHandler.triggerStateTransition(BasicEvent.QueryState.WAITING_FOR_RESULT, "{requestId: " + stmtInput.requestId + ",pingNumber: " + retries + "}");
            if (pingPongResponseJson == null) {
                if (retries >= 3) {
                    throw new SFException(ErrorCode.BAD_RESPONSE, resultAsString);
                }
                logger.debug("Will retry get result. Retry count: {}", retries);
                execTimeData.incrementRetryCount();
                execTimeData.addRetryLocation("StmtUtil null response");
                ++retries;
            } else {
                retries = 0;
            }
            if (pingPongResponseJson != null) {
                SnowflakeUtil.checkErrorAndThrowException(pingPongResponseJson);
            }
            if (pingPongResponseJson != null && !"333333".equals(pingPongResponseJson.path("code").asText()) && !"333334".equals(pingPongResponseJson.path("code").asText())) {
                queryInProgress = false;
            } else if (stmtInput.asyncExec && "333334".equals(pingPongResponseJson.path("code").asText())) {
                queryInProgress = false;
            } else {
                queryInProgress = true;
                if (firstResponse && stmtInput.injectClientPause != 0) {
                    logger.debug("Inject client pause for {} seconds", stmtInput.injectClientPause);
                    try {
                        Thread.sleep(stmtInput.injectClientPause * 1000);
                    }
                    catch (InterruptedException ex) {
                        logger.debug("Exception encountered while injecting pause", false);
                    }
                }
                execTimeData.incrementRetryCount();
                execTimeData.addRetryLocation("StmtUtil queryInProgress");
                resultAsString = StmtUtil.getQueryResult(pingPongResponseJson, previousGetResultPath, stmtInput);
                if (pingPongResponseJson != null) {
                    stmtInput.prevGetResultURL = previousGetResultPath = pingPongResponseJson.path("data").path("getResultUrl").asText();
                }
            }
            if (!firstResponse) continue;
            firstResponse = false;
        } while (queryInProgress);
        logger.debug("Returning result", false);
        eventHandler.triggerStateTransition(BasicEvent.QueryState.PROCESSING_RESULT, String.format(BasicEvent.QueryState.PROCESSING_RESULT.getArgString(), stmtInput.requestId));
        return new StmtOutput(pingPongResponseJson);
    }

    protected static String getQueryResult(JsonNode inProgressResponse, String previousGetResultPath, StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        String getResultPath = null;
        if (inProgressResponse == null || inProgressResponse.path("data").path("getResultUrl").isMissingNode()) {
            if (previousGetResultPath == null) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "No query response or missing get result URL");
            }
            logger.debug("No query response or missing get result URL, use previous get result URL: {}", previousGetResultPath);
            getResultPath = previousGetResultPath;
        } else {
            getResultPath = inProgressResponse.path("data").path("getResultUrl").asText();
        }
        return StmtUtil.getQueryResult(getResultPath, stmtInput);
    }

    protected static String getQueryResult(String getResultPath, StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        HttpGet httpRequest = null;
        logger.debug("Get query result: {}", getResultPath);
        try {
            URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
            uriBuilder.setPath(getResultPath);
            uriBuilder.addParameter("requestId", UUIDUtils.getUUID().toString());
            httpRequest = new HttpGet(uriBuilder.build());
            HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)httpRequest, stmtInput.additionalHttpHeadersForSnowsight);
            httpRequest.addHeader("accept", stmtInput.mediaType);
            httpRequest.setHeader("Authorization", "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
            StmtUtil.setServiceNameHeader(stmtInput, (HttpRequestBase)httpRequest);
            return HttpUtil.executeRequest((HttpRequestBase)httpRequest, stmtInput.networkTimeoutInMillis / 1000, stmtInput.socketTimeout, 0, stmtInput.maxRetries, 0, stmtInput.canceling, false, false, stmtInput.httpClientSettingsKey, new ExecTimeTelemetryData());
        }
        catch (IOException | URISyntaxException ex) {
            logger.error("Exception encountered when getting result for " + httpRequest, ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
        }
    }

    protected static JsonNode getQueryResultJSON(String queryId, SFSession session) throws SFException, SnowflakeSQLException {
        String getResultPath = String.format(SF_PATH_QUERY_RESULT, queryId);
        StmtInput stmtInput = new StmtInput().setServerUrl(session.getServerUrl()).setSessionToken(session.getSessionToken()).setNetworkTimeoutInMillis(session.getNetworkTimeoutInMilli()).setSocketTimeout(session.getHttpClientSocketTimeout()).setMediaType(SF_MEDIA_TYPE).setServiceName(session.getServiceName()).setOCSPMode(session.getOCSPMode()).setHttpClientSettingsKey(session.getHttpClientKey()).setMaxRetries(session.getMaxHttpRetries());
        String resultAsString = StmtUtil.getQueryResult(getResultPath, stmtInput);
        StmtOutput stmtOutput = StmtUtil.pollForOutput(resultAsString, stmtInput, null, new ExecTimeTelemetryData());
        return stmtOutput.getResult();
    }

    @Deprecated
    public static void cancel(StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        StmtUtil.cancel(stmtInput, CancellationReason.UNKNOWN);
    }

    public static void cancel(StmtInput stmtInput, CancellationReason cancellationReason) throws SFException, SnowflakeSQLException {
        HttpPost httpRequest = null;
        AssertUtil.assertTrue(stmtInput.serverUrl != null, "Missing server url for statement execution");
        AssertUtil.assertTrue(stmtInput.sql != null, "Missing sql for statement execution");
        AssertUtil.assertTrue(stmtInput.mediaType != null, "Missing media type for statement execution");
        AssertUtil.assertTrue(stmtInput.requestId != null, "Missing request id for statement execution");
        AssertUtil.assertTrue(stmtInput.sessionToken != null, "Missing session token for statement execution");
        try {
            URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
            logger.warn("Cancelling query {} with reason {}", new Object[]{stmtInput.requestId, cancellationReason});
            logger.debug("Aborting query: {}", stmtInput.sql);
            uriBuilder.setPath(SF_PATH_ABORT_REQUEST_V1);
            uriBuilder.addParameter("requestId", UUIDUtils.getUUID().toString());
            httpRequest = new HttpPost(uriBuilder.build());
            HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)httpRequest, stmtInput.additionalHttpHeadersForSnowsight);
            HashMap<String, String> sqlJsonBody = new HashMap<String, String>();
            sqlJsonBody.put("sqlText", stmtInput.sql);
            sqlJsonBody.put("requestId", stmtInput.requestId);
            String json = mapper.writeValueAsString(sqlJsonBody);
            logger.debug("JSON for cancel request: {}", json);
            StringEntity input = new StringEntity(json, StandardCharsets.UTF_8);
            input.setContentType("application/json");
            httpRequest.setEntity((HttpEntity)input);
            httpRequest.addHeader("accept", stmtInput.mediaType);
            httpRequest.setHeader("Authorization", "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
            StmtUtil.setServiceNameHeader(stmtInput, (HttpRequestBase)httpRequest);
            String jsonString = HttpUtil.executeRequest((HttpRequestBase)httpRequest, 600000, 0, stmtInput.socketTimeout, 0, 0, null, false, false, stmtInput.httpClientSettingsKey, new ExecTimeTelemetryData());
            logger.debug("Json response: {}", jsonString);
            JsonNode rootNode = null;
            rootNode = mapper.readTree(jsonString);
            SnowflakeUtil.checkErrorAndThrowException(rootNode);
        }
        catch (IOException | URISyntaxException ex) {
            logger.error("Exception encountered when canceling " + httpRequest, ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
        }
    }

    public static SFStatementType checkStageManageCommand(String sql) {
        if (sql == null) {
            return null;
        }
        String trimmedSql = sql.trim();
        while (trimmedSql.startsWith("//")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping // comments in: \n{}", trimmedSql);
            }
            if (trimmedSql.indexOf(10) <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf(10));
            trimmedSql = trimmedSql.trim();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("New sql after skipping // comments: \n{}", trimmedSql);
        }
        while (trimmedSql.startsWith("/*")) {
            if (logger.isDebugEnabled()) {
                logger.debug("skipping /* */ comments in: \n{}", trimmedSql);
            }
            if (trimmedSql.indexOf("*/") <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf("*/") + 2);
            trimmedSql = trimmedSql.trim();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("New sql after skipping /* */ comments: \n{}", SecretDetector.maskSecrets(trimmedSql));
        }
        if ((trimmedSql = trimmedSql.toLowerCase()).startsWith("put ")) {
            return SFStatementType.PUT;
        }
        if (trimmedSql.startsWith("get ")) {
            return SFStatementType.GET;
        }
        if (trimmedSql.startsWith("ls ") || trimmedSql.startsWith("list ")) {
            return SFStatementType.LIST;
        }
        if (trimmedSql.startsWith("rm ") || trimmedSql.startsWith("remove ")) {
            return SFStatementType.REMOVE;
        }
        return null;
    }

    public static String truncateSQL(String sql) {
        return sql.length() > 20 ? sql.substring(0, 20) + "..." : sql;
    }

    public static class StmtOutput {
        JsonNode result;

        public StmtOutput(JsonNode result) {
            this.result = result;
        }

        public JsonNode getResult() {
            return this.result;
        }
    }

    static class StmtInput {
        String sql;
        String mediaType = "application/snowflake";
        Map<String, ParameterBindingDTO> bindValues;
        String bindStage;
        boolean describeOnly;
        String serverUrl;
        String requestId;
        int sequenceId = -1;
        boolean internal = false;
        boolean asyncExec = false;
        Map<String, Object> parametersMap;
        String sessionToken;
        int networkTimeoutInMillis;
        int socketTimeout;
        int injectSocketTimeout;
        int injectClientPause;
        int maxRetries;
        AtomicBoolean canceling = null;
        boolean retry;
        String prevGetResultURL = null;
        boolean combineDescribe = false;
        String describedJobId;
        long querySubmissionTime;
        String serviceName;
        OCSPMode ocspMode;
        HttpClientSettingsKey httpClientSettingsKey;
        QueryContextDTO queryContextDTO;
        Map<String, String> additionalHttpHeadersForSnowsight;

        StmtInput() {
        }

        public StmtInput setSql(String sql) {
            this.sql = sql;
            return this;
        }

        public StmtInput setMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public StmtInput setParametersMap(Map<String, Object> parametersMap) {
            this.parametersMap = parametersMap;
            return this;
        }

        public StmtInput setBindValues(Map<String, ParameterBindingDTO> bindValues) {
            this.bindValues = bindValues;
            return this;
        }

        public StmtInput setBindStage(String bindStage) {
            this.bindStage = bindStage;
            return this;
        }

        public StmtInput setDescribeOnly(boolean describeOnly) {
            this.describeOnly = describeOnly;
            return this;
        }

        public StmtInput setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public StmtInput setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public StmtInput setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public StmtInput setSequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public StmtInput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public StmtInput setNetworkTimeoutInMillis(int networkTimeoutInMillis) {
            this.networkTimeoutInMillis = networkTimeoutInMillis;
            return this;
        }

        public StmtInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public StmtInput setInjectSocketTimeout(int injectSocketTimeout) {
            this.injectSocketTimeout = injectSocketTimeout;
            return this;
        }

        public StmtInput setInjectClientPause(int injectClientPause) {
            this.injectClientPause = injectClientPause;
            return this;
        }

        public StmtInput setCanceling(AtomicBoolean canceling) {
            this.canceling = canceling;
            return this;
        }

        public StmtInput setRetry(boolean retry) {
            this.retry = retry;
            return this;
        }

        public StmtInput setCombineDescribe(boolean combineDescribe) {
            this.combineDescribe = combineDescribe;
            return this;
        }

        public StmtInput setDescribedJobId(String describedJobId) {
            this.describedJobId = describedJobId;
            return this;
        }

        public StmtInput setQuerySubmissionTime(long querySubmissionTime) {
            this.querySubmissionTime = querySubmissionTime;
            return this;
        }

        public StmtInput setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public StmtInput setOCSPMode(OCSPMode ocspMode) {
            this.ocspMode = ocspMode;
            return this;
        }

        public StmtInput setHttpClientSettingsKey(HttpClientSettingsKey key) {
            this.httpClientSettingsKey = key;
            return this;
        }

        public StmtInput setAsync(boolean async) {
            this.asyncExec = async;
            return this;
        }

        public StmtInput setQueryContextDTO(QueryContextDTO queryContext) {
            this.queryContextDTO = queryContext;
            return this;
        }

        public StmtInput setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public StmtInput setAdditionalHttpHeadersForSnowsight(Map<String, String> additionalHttpHeaders) {
            this.additionalHttpHeadersForSnowsight = additionalHttpHeaders;
            return this;
        }
    }
}

