/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;

public class TelemetryUtil {
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    public static final int NO_VENDOR_CODE = -1;
    @Deprecated
    public static final String TYPE = "type";
    @Deprecated
    public static final String QUERY_ID = "query_id";
    @Deprecated
    public static final String VALUE = "value";

    public static TelemetryData buildJobData(String queryId, TelemetryField field, long value) {
        ObjectNode obj = mapper.createObjectNode();
        obj.put(TelemetryField.TYPE.toString(), field.toString());
        obj.put(TelemetryField.QUERY_ID.toString(), queryId);
        obj.put(TelemetryField.VALUE.toString(), value);
        return new TelemetryData(obj, System.currentTimeMillis());
    }

    public static TelemetryData buildJobData(ObjectNode obj) {
        return new TelemetryData(obj, System.currentTimeMillis());
    }

    public static ObjectNode createIBValue(String queryId, String sqlState, int errorNumber, TelemetryField type, String errorMessage, String reason) {
        ObjectNode ibValue = mapper.createObjectNode();
        ibValue.put(TelemetryField.TYPE.toString(), type.toString());
        ibValue.put(TelemetryField.DRIVER_TYPE.toString(), "JDBC");
        ibValue.put(TelemetryField.DRIVER_VERSION.toString(), SnowflakeDriver.implementVersion);
        if (!SnowflakeUtil.isNullOrEmpty(queryId)) {
            ibValue.put(TelemetryField.QUERY_ID.toString(), queryId);
        }
        if (!SnowflakeUtil.isNullOrEmpty(sqlState)) {
            ibValue.put(TelemetryField.SQL_STATE.toString(), sqlState);
        }
        if (errorNumber != -1) {
            ibValue.put(TelemetryField.ERROR_NUMBER.toString(), errorNumber);
        }
        if (!SnowflakeUtil.isNullOrEmpty(errorMessage)) {
            ibValue.put(TelemetryField.ERROR_MESSAGE.toString(), errorMessage);
        }
        if (!SnowflakeUtil.isNullOrEmpty(reason)) {
            ibValue.put(TelemetryField.REASON.toString(), reason);
        }
        return ibValue;
    }
}

