/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.BatchCallback;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleGauge;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongGauge;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ThrottlingLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterSharedState;

class SdkObservableInstrument
implements ObservableDoubleCounter,
ObservableLongCounter,
ObservableDoubleGauge,
ObservableLongGauge,
ObservableDoubleUpDownCounter,
ObservableLongUpDownCounter,
BatchCallback {
    private static final Logger logger = Logger.getLogger(SdkObservableInstrument.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final MeterSharedState meterSharedState;
    private final CallbackRegistration callbackRegistration;
    private final AtomicBoolean removed = new AtomicBoolean(false);

    SdkObservableInstrument(MeterSharedState meterSharedState, CallbackRegistration callbackRegistration) {
        this.meterSharedState = meterSharedState;
        this.callbackRegistration = callbackRegistration;
    }

    @Override
    public void close() {
        if (!this.removed.compareAndSet(false, true)) {
            this.throttlingLogger.log(Level.WARNING, this.callbackRegistration + " has called close() multiple times.");
            return;
        }
        this.meterSharedState.removeCallback(this.callbackRegistration);
    }

    public String toString() {
        return "SdkObservableInstrument{callback=" + this.callbackRegistration + "}";
    }
}

