/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.util;

import java.util.Map;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.util.RoundRobinLoadBalancer;

final class SecretRoundRobinLoadBalancerProvider {
    private SecretRoundRobinLoadBalancerProvider() {
    }

    public static final class Provider
    extends LoadBalancerProvider {
        private static final String NO_CONFIG = "no service config";

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public int getPriority() {
            return 5;
        }

        @Override
        public String getPolicyName() {
            return "round_robin";
        }

        @Override
        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new RoundRobinLoadBalancer(helper);
        }

        @Override
        public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
            return NameResolver.ConfigOrError.fromConfig(NO_CONFIG);
        }
    }
}

