/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric;

import java.time.Duration;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceOptions;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.MetricServiceSettings;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.stub.MetricServiceStubSettings;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.AutoValue_MetricConfiguration;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.google.common.base.Suppliers;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.semconv.ResourceAttributes;

@AutoValue
@Immutable
public abstract class MetricConfiguration {
    static final String DEFAULT_PREFIX = "workload.googleapis.com";
    public static final Duration DEFAULT_DEADLINE = Duration.ofSeconds(12L, 0L);
    public static final String DEFAULT_METRIC_SERVICE_ENDPOINT = MetricServiceStubSettings.getDefaultEndpoint();
    public static final Predicate<AttributeKey<?>> NO_RESOURCE_ATTRIBUTES = attributeKey -> false;
    public static final MonitoredResourceDescription EMPTY_MONITORED_RESOURCE_DESCRIPTION = new MonitoredResourceDescription("", Collections.emptySet());
    public static final Predicate<AttributeKey<?>> DEFAULT_RESOURCE_ATTRIBUTES_FILTER = attributeKey -> (attributeKey.equals(ResourceAttributes.SERVICE_NAME) || attributeKey.equals(ResourceAttributes.SERVICE_NAMESPACE) || attributeKey.equals(ResourceAttributes.SERVICE_INSTANCE_ID)) && !attributeKey.getKey().isEmpty();

    MetricConfiguration() {
    }

    abstract Supplier<String> getProjectIdSupplier();

    @Nullable
    public abstract Credentials getCredentials();

    public final String getProjectId() {
        return this.getProjectIdSupplier().get();
    }

    public abstract String getPrefix();

    public abstract Duration getDeadline();

    public abstract MetricDescriptorStrategy getDescriptorStrategy();

    @Nullable
    public abstract String getMetricServiceEndpoint();

    public abstract Predicate<AttributeKey<?>> getResourceAttributesFilter();

    public abstract boolean getUseServiceTimeSeries();

    public abstract MonitoredResourceDescription getMonitoredResourceDescription();

    @Nullable
    public abstract MetricServiceSettings getMetricServiceSettings();

    public abstract boolean getInstrumentationLibraryLabelsEnabled();

    @VisibleForTesting
    abstract boolean getInsecureEndpoint();

    public static Builder builder() {
        return new AutoValue_MetricConfiguration.Builder().setProjectIdSupplier(Suppliers.memoize(ServiceOptions::getDefaultProjectId)).setPrefix(DEFAULT_PREFIX).setDeadline(DEFAULT_DEADLINE).setDescriptorStrategy(MetricDescriptorStrategy.SEND_ONCE).setInsecureEndpoint(false).setUseServiceTimeSeries(false).setInstrumentationLibraryLabelsEnabled(true).setResourceAttributesFilter(DEFAULT_RESOURCE_ATTRIBUTES_FILTER).setMonitoredResourceDescription(EMPTY_MONITORED_RESOURCE_DESCRIPTION).setMetricServiceEndpoint(DEFAULT_METRIC_SERVICE_ENDPOINT);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        abstract Duration getDeadline();

        abstract Builder setProjectIdSupplier(Supplier<String> var1);

        public final Builder setProjectId(String projectId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "Project ID cannot be null or empty.");
            this.setProjectIdSupplier(() -> projectId);
            return this;
        }

        public abstract Builder setPrefix(String var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setDeadline(Duration var1);

        public abstract Builder setDescriptorStrategy(MetricDescriptorStrategy var1);

        public abstract Builder setMetricServiceEndpoint(String var1);

        public abstract Builder setUseServiceTimeSeries(boolean var1);

        public abstract Builder setMonitoredResourceDescription(MonitoredResourceDescription var1);

        public abstract Builder setResourceAttributesFilter(Predicate<AttributeKey<?>> var1);

        public abstract Builder setMetricServiceSettings(MetricServiceSettings var1);

        public abstract Builder setInstrumentationLibraryLabelsEnabled(boolean var1);

        @VisibleForTesting
        abstract Builder setInsecureEndpoint(boolean var1);

        abstract MetricConfiguration autoBuild();

        public MetricConfiguration build() {
            Preconditions.checkArgument(this.getDeadline().compareTo(Duration.ZERO) > 0, "Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

