/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client;

import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.SuccessResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientInformation;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class ClientInformationResponse
extends ClientRegistrationResponse
implements SuccessResponse {
    private final ClientInformation clientInfo;
    private final boolean forNewClient;

    public ClientInformationResponse(ClientInformation clientInfo, boolean forNewClient) {
        this.clientInfo = Objects.requireNonNull(clientInfo);
        this.forNewClient = forNewClient;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ClientInformation getClientInformation() {
        return this.clientInfo;
    }

    public boolean isForNewClient() {
        return this.forNewClient;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(this.forNewClient ? 201 : 200);
        httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setBody(this.clientInfo.toJSONObject().toString());
        return httpResponse;
    }

    public static ClientInformationResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200, 201);
        ClientInformation clientInfo = ClientInformation.parse(httpResponse.getBodyAsJSONObject());
        boolean forNewClient = 201 == httpResponse.getStatusCode();
        return new ClientInformationResponse(clientInfo, forNewClient);
    }
}

