/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.PrivateKey;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.core.HeartbeatBackground;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.QueryContextCache;
import net.snowflake.client.core.QueryContextDTO;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.jdbc.DefaultSFConnectionHandler;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.QueryStatusV2;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.diagnostic.DiagnosticContext;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.SFLoggerUtil;
import net.snowflake.client.util.Stopwatch;

public class SFSession
extends SFBaseSession {
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFSession.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    private static final String SF_PATH_SESSION_HEARTBEAT = "/session/heartbeat";
    private static final String SF_PATH_QUERY_MONITOR = "/monitoring/queries/";
    private static final String CLIENT_STORE_TEMPORARY_CREDENTIAL = "CLIENT_STORE_TEMPORARY_CREDENTIAL";
    private static final int MAX_SESSION_PARAMETERS = 1000;
    public static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private final AtomicInteger sequenceId = new AtomicInteger(0);
    private final List<DriverPropertyInfo> missingProperties = new ArrayList<DriverPropertyInfo>();
    private Set<String> activeAsyncQueries = ConcurrentHashMap.newKeySet();
    private boolean isClosed = true;
    private String sessionToken;
    private String masterToken;
    private long masterTokenValidityInSeconds;
    private String idToken;
    private String mfaToken;
    private String oauthAccessToken;
    private String oauthRefreshToken;
    private String privateKeyFileLocation;
    private String privateKeyBase64;
    private String privateKeyPassword;
    private PrivateKey privateKey;
    private SFClientConfig sfClientConfig;
    private int loginTimeout = 300;
    private int networkTimeoutInMilli = 0;
    @Deprecated
    private int authTimeout = 0;
    private boolean enableCombineDescribe = false;
    private Duration httpClientConnectionTimeout = HttpUtil.getConnectionTimeout();
    private Duration httpClientSocketTimeout = HttpUtil.getSocketTimeout();
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private Map<String, Object> sessionParametersMap = new HashMap<String, Object>();
    private boolean passcodeInPassword = false;
    private Level tracingLevel = Level.INFO;
    private Telemetry telemetryClient;
    private SnowflakeConnectString sfConnStr;
    private QueryContextCache qcc;
    private int maxHttpRetries = 7;
    private int retryTimeout = 300;
    private boolean enableClientStoreTemporaryCredential = true;
    private boolean enableClientRequestMfaToken = true;
    private Duration browserResponseTimeout = Duration.ofSeconds(120L);
    private boolean javaUtilLoggingConsoleOut = false;
    private String javaUtilLoggingConsoleOutThreshold = null;
    private List<HttpHeadersCustomizer> httpHeadersCustomizers;

    @VisibleForTesting
    public SFSession() {
        this(new DefaultSFConnectionHandler(null));
    }

    public SFSession(DefaultSFConnectionHandler sfConnectionHandler) {
        super(sfConnectionHandler);
    }

    @Override
    public boolean isSafeToClose() {
        boolean canClose = true;
        if (this.activeAsyncQueries.isEmpty()) {
            return canClose;
        }
        for (String query : this.activeAsyncQueries) {
            try {
                QueryStatus qStatus = this.getQueryStatus(query);
                if (!QueryStatus.isStillRunning(qStatus)) continue;
                canClose = false;
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), true);
            }
        }
        return canClose;
    }

    public void addQueryToActiveQueryList(String queryID) {
        this.activeAsyncQueries.add(queryID);
    }

    private JsonNode getQueryMetadata(String queryID) throws SQLException {
        boolean sessionRenewed;
        String statusUrl = "";
        String sessionUrl = this.getUrl();
        statusUrl = sessionUrl.endsWith("/") ? sessionUrl.substring(0, sessionUrl.length() - 1) + SF_PATH_QUERY_MONITOR + queryID : sessionUrl + SF_PATH_QUERY_MONITOR + queryID;
        HttpGet get = new HttpGet(statusUrl);
        String response = null;
        JsonNode jsonNode = null;
        do {
            sessionRenewed = false;
            try {
                get.setHeader("Content-type", "application/json");
                get.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + this.sessionToken + "\"");
                response = HttpUtil.executeGeneralRequest((HttpRequestBase)get, this.loginTimeout, 0, (int)this.httpClientSocketTimeout.toMillis(), this.maxHttpRetries, this.getHttpClientKey(), (SFBaseSession)this);
                jsonNode = OBJECT_MAPPER.readTree(response);
            }
            catch (Exception e) {
                throw new SnowflakeSQLLoggedException(queryID, this, e.getMessage(), "No response or invalid response from GET request. Error: " + e.getMessage(), e);
            }
            if (jsonNode.path("success").asBoolean()) continue;
            logger.debug("Response: {}", response);
            int errorCode = jsonNode.path("code").asInt();
            if (errorCode == 390112) {
                try {
                    this.renewSession(this.sessionToken);
                }
                catch (SFException | SnowflakeReauthenticationRequest ex) {
                    if (ex instanceof SnowflakeReauthenticationRequest && this.isExternalbrowserOrOAuthFullFlowAuthenticator()) {
                        try {
                            this.open();
                        }
                        catch (SFException e) {
                            throw new SnowflakeSQLException(e);
                        }
                    } else {
                        if (ex instanceof SnowflakeReauthenticationRequest) {
                            throw (SnowflakeSQLException)ex;
                        }
                        if (ex instanceof SFException) {
                            throw new SnowflakeSQLException((SFException)ex);
                        }
                    }
                    throw new SnowflakeSQLException(queryID, ex.getMessage());
                }
                sessionRenewed = true;
                continue;
            }
            throw new SnowflakeSQLException(queryID, jsonNode.path("message").asText(), "08001", errorCode);
        } while (sessionRenewed);
        return jsonNode.path("data").path("queries");
    }

    @Override
    @Deprecated
    public QueryStatus getQueryStatus(String queryID) throws SQLException {
        JsonNode queryNode = this.getQueryMetadata(queryID);
        String queryStatus = "";
        String errorMessage = "";
        int errorCode = 0;
        if (queryNode.size() > 0) {
            queryStatus = queryNode.get(0).path("status").asText();
            errorMessage = queryNode.get(0).path("errorMessage").asText();
            errorCode = queryNode.get(0).path("errorCode").asInt();
        }
        logger.debug("Query status: {}", queryNode.asText());
        QueryStatus result = QueryStatus.getStatusFromString(queryStatus);
        if (errorCode != 0) {
            result.setErrorCode(errorCode);
        } else if (QueryStatus.isAnError(result)) {
            result.setErrorCode(ErrorCode.INTERNAL_ERROR.getMessageCode());
            result.setErrorMessage("no_error_code_from_server");
        } else if (!QueryStatus.isAnError(result)) {
            result.setErrorCode(0);
            result.setErrorMessage("No error reported");
        }
        if (!SnowflakeUtil.isNullOrEmpty(errorMessage) && !errorMessage.equalsIgnoreCase("null")) {
            result.setErrorMessage(errorMessage);
        } else {
            result.setErrorMessage("No error reported");
        }
        if (!QueryStatus.isStillRunning(result)) {
            this.activeAsyncQueries.remove(queryID);
        }
        return result;
    }

    @Override
    public QueryStatusV2 getQueryStatusV2(String queryID) throws SQLException {
        String warehouseServerType;
        String warehouseName;
        int warehouseId;
        String warehouseExternalSize;
        int totalDuration;
        String state;
        long startTime;
        String sqlText;
        long sessionId;
        String name;
        String id;
        String errorMessage;
        int errorCode;
        JsonNode queryNode = this.getQueryMetadata(queryID);
        logger.debug("Query status: {}", queryNode.asText());
        if (queryNode.isEmpty()) {
            return QueryStatusV2.empty();
        }
        JsonNode node = queryNode.get(0);
        long endTime = node.path("endTime").asLong(0L);
        QueryStatusV2 result = new QueryStatusV2(endTime, errorCode = node.path("errorCode").asInt(0), errorMessage = node.path("errorMessage").asText("No error reported"), id = node.path("id").asText(""), name = node.path("status").asText(""), sessionId = node.path("sessionId").asLong(0L), sqlText = node.path("sqlText").asText(""), startTime = node.path("startTime").asLong(0L), state = node.path("state").asText(""), totalDuration = node.path("totalDuration").asInt(0), warehouseExternalSize = node.path("warehouseExternalSize").asText(null), warehouseId = node.path("warehouseId").asInt(0), warehouseName = node.path("warehouseName").asText(null), warehouseServerType = node.path("warehouseServerType").asText(null));
        if (!result.isStillRunning()) {
            this.activeAsyncQueries.remove(queryID);
        }
        return result;
    }

    public void addSFSessionProperty(String propertyName, Object propertyValue) throws SFException {
        block64: {
            block63: {
                SFSessionProperty connectionProperty = SFSessionProperty.lookupByKey(propertyName);
                if (connectionProperty == null) break block63;
                this.addProperty(propertyName, propertyValue);
                propertyValue = SFSessionProperty.checkPropertyValue(connectionProperty, propertyValue);
                switch (connectionProperty) {
                    case LOGIN_TIMEOUT: {
                        if (propertyValue != null) {
                            this.loginTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case NETWORK_TIMEOUT: {
                        if (propertyValue != null) {
                            this.networkTimeoutInMilli = (Integer)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case INJECT_CLIENT_PAUSE: {
                        if (propertyValue != null) {
                            this.injectClientPause = (Integer)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case INJECT_SOCKET_TIMEOUT: {
                        if (propertyValue != null) {
                            this.injectSocketTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case PASSCODE_IN_PASSWORD: {
                        this.passcodeInPassword = propertyValue != null && (Boolean)propertyValue != false;
                        break;
                    }
                    case TRACING: {
                        if (propertyValue != null) {
                            this.tracingLevel = Level.parse(((String)propertyValue).toUpperCase());
                            break;
                        }
                        break block64;
                    }
                    case JAVA_LOGGING_CONSOLE_STD_OUT: {
                        if (propertyValue != null) {
                            this.javaUtilLoggingConsoleOut = (Boolean)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case JAVA_LOGGING_CONSOLE_STD_OUT_THRESHOLD: {
                        if (propertyValue != null) {
                            this.javaUtilLoggingConsoleOutThreshold = (String)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case DISABLE_SOCKS_PROXY: {
                        if (propertyValue != null) {
                            HttpUtil.setSocksProxyDisabled((Boolean)propertyValue);
                            break;
                        }
                        break block64;
                    }
                    case VALIDATE_DEFAULT_PARAMETERS: {
                        if (propertyValue != null) {
                            this.setValidateDefaultParameters(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case PRIVATE_KEY_FILE: {
                        if (propertyValue != null) {
                            this.privateKeyFileLocation = (String)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case PRIVATE_KEY_BASE64: {
                        if (propertyValue != null) {
                            this.privateKeyBase64 = (String)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case PRIVATE_KEY_FILE_PWD: 
                    case PRIVATE_KEY_PWD: {
                        if (propertyValue != null) {
                            this.privateKeyPassword = (String)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case MAX_HTTP_RETRIES: {
                        if (propertyValue != null) {
                            this.maxHttpRetries = (Integer)propertyValue;
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_PUT_GET: {
                        if (propertyValue != null) {
                            this.setEnablePutGet(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case RETRY_TIMEOUT: {
                        int timeoutValue;
                        if (propertyValue != null && ((timeoutValue = ((Integer)propertyValue).intValue()) >= 300 || timeoutValue == 0)) {
                            this.retryTimeout = timeoutValue;
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_PATTERN_SEARCH: {
                        if (propertyValue != null) {
                            this.setEnablePatternSearch(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_EXACT_SCHEMA_SEARCH_ENABLED: {
                        if (propertyValue != null) {
                            this.setEnableExactSchemaSearch(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_WILDCARDS_IN_SHOW_METADATA_COMMANDS: {
                        if (propertyValue != null) {
                            this.setEnableWildcardsInShowMetadataCommands(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case DISABLE_GCS_DEFAULT_CREDENTIALS: {
                        if (propertyValue != null) {
                            this.setDisableGcsDefaultCredentials(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case JDBC_ARROW_TREAT_DECIMAL_AS_INT: {
                        if (propertyValue != null) {
                            this.setJdbcArrowTreatDecimalAsInt(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case BROWSER_RESPONSE_TIMEOUT: {
                        if (propertyValue != null) {
                            this.browserResponseTimeout = Duration.ofSeconds(((Integer)propertyValue).intValue());
                            break;
                        }
                        break block64;
                    }
                    case JDBC_DEFAULT_FORMAT_DATE_WITH_TIMEZONE: {
                        if (propertyValue != null) {
                            this.setDefaultFormatDateWithTimezone(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case JDBC_GET_DATE_USE_NULL_TIMEZONE: {
                        if (propertyValue != null) {
                            this.setGetDateUseNullTimezone(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_CLIENT_STORE_TEMPORARY_CREDENTIAL: {
                        if (propertyValue != null) {
                            this.enableClientStoreTemporaryCredential = SFLoginInput.getBooleanValue(propertyValue);
                            break;
                        }
                        break block64;
                    }
                    case ENABLE_CLIENT_REQUEST_MFA_TOKEN: {
                        if (propertyValue != null) {
                            this.enableClientRequestMfaToken = SFLoginInput.getBooleanValue(propertyValue);
                            break;
                        }
                        break block64;
                    }
                    case IMPLICIT_SERVER_SIDE_QUERY_TIMEOUT: {
                        if (propertyValue != null) {
                            this.setImplicitServerSideQueryTimeout(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case CLEAR_BATCH_ONLY_AFTER_SUCCESSFUL_EXECUTION: {
                        if (propertyValue != null) {
                            this.setClearBatchOnlyAfterSuccessfulExecution(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case CLIENT_TREAT_TIME_AS_WALL_CLOCK_TIME: {
                        if (propertyValue != null) {
                            this.setTreatTimeAsWallClockTime(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                    case OWNER_ONLY_STAGE_FILE_PERMISSIONS_ENABLED: {
                        if (propertyValue != null) {
                            this.setOwnerOnlyStageFilePermissionsEnabled(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block64;
                    }
                }
                break block64;
            }
            if (this.sessionParametersMap.containsKey(propertyName)) {
                throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
            }
            this.sessionParametersMap.put(propertyName, propertyValue);
            if (this.sessionParametersMap.size() > 1000) {
                throw new SFException(ErrorCode.TOO_MANY_SESSION_PARAMETERS, 1000);
            }
        }
    }

    @SnowflakeJdbcInternalApi
    public void overrideConsoleHandlerWhenNecessary() {
        if (this.javaUtilLoggingConsoleOut) {
            JDK14Logger.useStdOutConsoleHandler(this.javaUtilLoggingConsoleOutThreshold);
        }
    }

    public boolean containProperty(String key) {
        return this.sessionParametersMap.containsKey(key);
    }

    public synchronized void open() throws SFException, SnowflakeSQLException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        this.performSanityCheckOnProperties();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        logger.info("Opening session with server: {}, account: {}, user: {}, password is {}, role: {}, database: {}, schema: {}, warehouse: {}, validate default parameters: {}, authenticator: {}, ocsp mode: {}, passcode in password: {}, passcode is {}, private key is {}, disable socks proxy: {}, application: {}, app id: {}, app version: {}, login timeout: {}, retry timeout: {}, network timeout: {}, query timeout: {}, connection timeout: {}, socket timeout: {}, tracing: {}, private key file: {}, private key base 64: {}, private key pwd is {}, enable_diagnostics: {}, diagnostics_allowlist_path: {}, session parameters: client store temporary credential: {}, gzip disabled: {}, browser response timeout: {}", connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL), connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT), connectionPropertiesMap.get((Object)SFSessionProperty.USER), SFLoggerUtil.isVariableProvided((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)), connectionPropertiesMap.get((Object)SFSessionProperty.ROLE), connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE), connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA), connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE), connectionPropertiesMap.get((Object)SFSessionProperty.VALIDATE_DEFAULT_PARAMETERS), connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR), this.getOCSPMode().name(), connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE_IN_PASSWORD), SFLoggerUtil.isVariableProvided((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)), SFLoggerUtil.isVariableProvided(connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY)), connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_SOCKS_PROXY), connectionPropertiesMap.get((Object)SFSessionProperty.APPLICATION), connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID), connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION), connectionPropertiesMap.get((Object)SFSessionProperty.LOGIN_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.RETRY_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.NETWORK_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.QUERY_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_CONNECTION_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_SOCKET_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.TRACING), connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE), SFLoggerUtil.isVariableProvided((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_BASE64)), SFLoggerUtil.isVariableProvided((String)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.PRIVATE_KEY_PWD, connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE_PWD))), connectionPropertiesMap.get((Object)SFSessionProperty.ENABLE_DIAGNOSTICS), connectionPropertiesMap.get((Object)SFSessionProperty.DIAGNOSTICS_ALLOWLIST_FILE), this.sessionParametersMap.get(CLIENT_STORE_TEMPORARY_CREDENTIAL), connectionPropertiesMap.get((Object)SFSessionProperty.GZIP_DISABLED), connectionPropertiesMap.get((Object)SFSessionProperty.BROWSER_RESPONSE_TIMEOUT));
        HttpClientSettingsKey httpClientSettingsKey = this.getHttpClientKey();
        logger.debug("Connection proxy parameters: use proxy: {}, proxy host: {}, proxy port: {}, proxy user: {}, proxy password is {}, non proxy hosts: {}, proxy protocol: {}", new Object[]{httpClientSettingsKey.usesProxy(), httpClientSettingsKey.getProxyHost(), httpClientSettingsKey.getProxyPort(), httpClientSettingsKey.getProxyUser(), SFLoggerUtil.isVariableProvided(httpClientSettingsKey.getProxyPassword()), httpClientSettingsKey.getNonProxyHosts(), httpClientSettingsKey.getProxyHttpProtocol()});
        SFLoginInput loginInput = new SFLoginInput();
        SFOauthLoginInput oauthLoginInput = new SFOauthLoginInput((String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_CLIENT_ID), (String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_CLIENT_SECRET), (String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_REDIRECT_URI), (String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_AUTHORIZATION_URL), (String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_TOKEN_REQUEST_URL), (String)connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_SCOPE), SFLoginInput.getBooleanValue(connectionPropertiesMap.get((Object)SFSessionProperty.OAUTH_ENABLE_SINGLE_USE_REFRESH_TOKENS)));
        loginInput.setServerUrl((String)connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setDatabaseName((String)connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE)).setSchemaName((String)connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA)).setWarehouse((String)connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE)).setRole((String)connectionPropertiesMap.get((Object)SFSessionProperty.ROLE)).setValidateDefaultParameters(connectionPropertiesMap.get((Object)SFSessionProperty.VALIDATE_DEFAULT_PARAMETERS)).setAuthenticator((String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR)).setOriginalAuthenticator((String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR)).setOKTAUserName((String)connectionPropertiesMap.get((Object)SFSessionProperty.OKTA_USERNAME)).setAccountName((String)connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT)).setLoginTimeout(this.loginTimeout).setRetryTimeout(this.retryTimeout).setAuthTimeout(this.authTimeout).setUserName((String)connectionPropertiesMap.get((Object)SFSessionProperty.USER)).setPassword((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)).setToken((String)connectionPropertiesMap.get((Object)SFSessionProperty.TOKEN)).setPasscodeInPassword(this.passcodeInPassword).setPasscode((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)).setConnectionTimeout(connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_CONNECTION_TIMEOUT) != null ? Duration.ofMillis(((Integer)connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_CONNECTION_TIMEOUT)).intValue()) : this.httpClientConnectionTimeout).setSocketTimeout(connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_SOCKET_TIMEOUT) != null ? Duration.ofMillis(((Integer)connectionPropertiesMap.get((Object)SFSessionProperty.HTTP_CLIENT_SOCKET_TIMEOUT)).intValue()) : this.httpClientSocketTimeout).setAppId((String)connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID)).setAppVersion((String)connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION)).setSessionParameters(this.sessionParametersMap).setPrivateKey((PrivateKey)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY)).setPrivateKeyFile((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE)).setOauthLoginInput(oauthLoginInput).setWorkloadIdentityProvider((String)connectionPropertiesMap.get((Object)SFSessionProperty.WORKLOAD_IDENTITY_PROVIDER)).setWorkloadIdentityEntraResource((String)connectionPropertiesMap.get((Object)SFSessionProperty.WORKLOAD_IDENTITY_ENTRA_RESOURCE)).setPrivateKeyBase64((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_BASE64)).setPrivateKeyPwd((String)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.PRIVATE_KEY_PWD, connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE_PWD))).setApplication((String)connectionPropertiesMap.get((Object)SFSessionProperty.APPLICATION)).setServiceName(this.getServiceName()).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(httpClientSettingsKey).setDisableConsoleLogin(connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_CONSOLE_LOGIN) != null ? SFLoginInput.getBooleanValue(connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_CONSOLE_LOGIN)) : true).setDisableSamlURLCheck(connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_SAML_URL_CHECK) != null ? SFLoginInput.getBooleanValue(connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_SAML_URL_CHECK)) : false).setEnableClientStoreTemporaryCredential(this.enableClientStoreTemporaryCredential).setEnableClientRequestMfaToken(this.enableClientRequestMfaToken).setBrowserResponseTimeout(this.browserResponseTimeout);
        logger.info("Connecting to {} Snowflake domain", loginInput.getHostFromServerUrl().toLowerCase().endsWith(".cn") ? "CHINA" : "GLOBAL");
        TelemetryService.disableOOBTelemetry();
        HttpUtil.initHttpClient(httpClientSettingsKey, null, this.httpHeadersCustomizers);
        HttpUtil.setConnectionTimeout(loginInput.getConnectionTimeoutInMillis());
        HttpUtil.setSocketTimeout(loginInput.getSocketTimeoutInMillis());
        this.runDiagnosticsIfEnabled();
        SFLoginOutput loginOutput = SessionUtil.openSession(loginInput, connectionPropertiesMap, this.tracingLevel.toString());
        this.isClosed = false;
        this.authTimeout = loginInput.getAuthTimeout();
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
        this.idToken = loginOutput.getIdToken();
        this.mfaToken = loginOutput.getMfaToken();
        this.oauthAccessToken = loginOutput.getOauthAccessToken();
        this.oauthRefreshToken = loginOutput.getOauthRefreshToken();
        this.setDatabaseVersion(loginOutput.getDatabaseVersion());
        this.setDatabaseMajorVersion(loginOutput.getDatabaseMajorVersion());
        this.setDatabaseMinorVersion(loginOutput.getDatabaseMinorVersion());
        this.httpClientSocketTimeout = loginOutput.getHttpClientSocketTimeout();
        this.httpClientConnectionTimeout = loginOutput.getHttpClientConnectionTimeout();
        this.masterTokenValidityInSeconds = loginOutput.getMasterTokenValidityInSeconds();
        this.setDatabase(loginOutput.getSessionDatabase());
        this.setSchema(loginOutput.getSessionSchema());
        this.setRole(loginOutput.getSessionRole());
        this.setWarehouse(loginOutput.getSessionWarehouse());
        this.setSessionId(loginOutput.getSessionId());
        this.setAutoCommit(loginOutput.getAutoCommit());
        SessionUtil.updateSfDriverParamValues(loginOutput.getCommonParams(), this);
        String loginDatabaseName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE);
        String loginSchemaName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA);
        String loginRole = (String)connectionPropertiesMap.get((Object)SFSessionProperty.ROLE);
        String loginWarehouse = (String)connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE);
        if (loginDatabaseName != null && !loginDatabaseName.equalsIgnoreCase(this.getDatabase())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Database", loginDatabaseName, this.getDatabase()));
        }
        if (loginSchemaName != null && !loginSchemaName.equalsIgnoreCase(this.getSchema())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Schema", loginSchemaName, this.getSchema()));
        }
        if (loginRole != null && !loginRole.equalsIgnoreCase(this.getRole())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Role", loginRole, this.getRole()));
        }
        if (loginWarehouse != null && !loginWarehouse.equalsIgnoreCase(this.getWarehouse())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Warehouse", loginWarehouse, this.getWarehouse()));
        }
        boolean disableQueryContextCache = this.getDisableQueryContextCacheOption();
        logger.debug("Query context cache is {}", disableQueryContextCache ? "disabled" : "enabled");
        this.qcc = !disableQueryContextCache ? new QueryContextCache(this.getQueryContextCacheSize()) : null;
        this.startHeartbeatForThisSession();
        stopwatch.stop();
        logger.debug("Session {} opened in {} ms.", this.getSessionId(), stopwatch.elapsedMillis());
    }

    private boolean isSnowflakeAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        PrivateKey privateKey = (PrivateKey)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY);
        return authenticator == null && privateKey == null && this.privateKeyFileLocation == null && this.privateKeyBase64 == null || AuthenticatorType.SNOWFLAKE.name().equalsIgnoreCase(authenticator);
    }

    boolean isExternalbrowserOrOAuthFullFlowAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return AuthenticatorType.EXTERNALBROWSER.name().equalsIgnoreCase(authenticator) || AuthenticatorType.OAUTH_AUTHORIZATION_CODE.name().equalsIgnoreCase(authenticator) || AuthenticatorType.OAUTH_CLIENT_CREDENTIALS.name().equalsIgnoreCase(authenticator);
    }

    boolean isOKTAAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return !SnowflakeUtil.isNullOrEmpty(authenticator) && authenticator.startsWith("https://");
    }

    boolean isUsernamePasswordMFAAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return AuthenticatorType.USERNAME_PASSWORD_MFA.name().equalsIgnoreCase(authenticator);
    }

    synchronized void renewSession(String prevSessionToken) throws SFException, SnowflakeSQLException {
        if (this.sessionToken != null && !this.sessionToken.equals(prevSessionToken)) {
            logger.debug("Not renewing session {} because session token has not been updated.", this.getSessionId());
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        logger.debug("Renewing session {}", this.getSessionId());
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setServerUrl(this.getServerUrl()).setSessionToken(this.sessionToken).setMasterToken(this.masterToken).setIdToken(this.idToken).setMfaToken(this.mfaToken).setOauthAccessToken(this.oauthAccessToken).setOauthRefreshToken(this.oauthRefreshToken).setLoginTimeout(this.loginTimeout).setRetryTimeout(this.retryTimeout).setDatabaseName(this.getDatabase()).setSchemaName(this.getSchema()).setRole(this.getRole()).setWarehouse(this.getWarehouse()).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(this.getHttpClientKey());
        SFLoginOutput loginOutput = SessionUtil.renewSession(loginInput, this);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
        stopwatch.stop();
        logger.debug("Session {} renewed successfully in {} ms", this.getSessionId(), stopwatch.elapsedMillis());
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void close() throws SFException, SnowflakeSQLException {
        logger.debug("Closing session {}", this.getSessionId());
        this.stopHeartbeatForThisSession();
        if (this.isClosed) {
            logger.debug("Session {} is already closed", this.getSessionId());
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setServerUrl(this.getServerUrl()).setSessionToken(this.sessionToken).setLoginTimeout(this.loginTimeout).setRetryTimeout(this.retryTimeout).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(this.getHttpClientKey());
        SessionUtil.closeSession(loginInput, this);
        this.closeTelemetryClient();
        this.getClientInfo().clear();
        if (this.qcc != null) {
            this.qcc.clearCache();
        }
        stopwatch.stop();
        logger.debug("Session {} has been successfully closed in {} ms", this.getSessionId(), stopwatch.elapsedMillis());
        this.isClosed = true;
    }

    @Override
    public void callHeartBeat(int timeout) throws Exception, SFException {
        if (timeout > 0) {
            this.callHeartBeatWithQueryTimeout(timeout);
        } else {
            this.heartbeat();
        }
    }

    private void callHeartBeatWithQueryTimeout(int timeout) throws Exception, SFException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        class HeartbeatTask
        implements Callable<Void> {
            HeartbeatTask() {
            }

            @Override
            public Void call() throws SQLException {
                try {
                    SFSession.this.heartbeat();
                }
                catch (SFException e) {
                    throw new SnowflakeSQLException((Throwable)e, e.getSqlState(), e.getVendorCode(), e.getParams());
                }
                return null;
            }
        }
        Future<Void> future = executor.submit(new HeartbeatTask());
        try {
            future.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected void startHeartbeatForThisSession() {
        if (this.getEnableHeartbeat() && !SnowflakeUtil.isNullOrEmpty(this.masterToken)) {
            logger.debug("Session {} start heartbeat, master token validity: {} s", this.getSessionId(), this.masterTokenValidityInSeconds);
            HeartbeatBackground.getInstance().addSession(this, this.masterTokenValidityInSeconds, this.heartbeatFrequency);
        } else {
            logger.debug("Heartbeat not enabled for the session {}", this.getSessionId());
        }
    }

    protected void stopHeartbeatForThisSession() {
        if (this.getEnableHeartbeat() && !SnowflakeUtil.isNullOrEmpty(this.masterToken)) {
            logger.debug("Session {} stop heartbeat", this.getSessionId());
            HeartbeatBackground.getInstance().removeSession(this);
        } else {
            logger.debug("Heartbeat not enabled for the session {}", this.getSessionId());
        }
    }

    protected void heartbeat() throws SFException, SQLException {
        logger.debug("Session {} heartbeat", this.getSessionId());
        if (this.isClosed) {
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        HttpPost postRequest = null;
        String requestId = UUIDUtils.getUUID().toString();
        boolean retry = false;
        do {
            try {
                URIBuilder uriBuilder = new URIBuilder(this.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, requestId);
                uriBuilder.setPath(SF_PATH_SESSION_HEARTBEAT);
                postRequest = new HttpPost(uriBuilder.build());
                String prevSessionToken = this.sessionToken;
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + prevSessionToken + "\"");
                logger.debug("Executing heartbeat request: {}", postRequest.toString());
                int SF_HEARTBEAT_TIMEOUT = 300;
                String theResponse = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, SF_HEARTBEAT_TIMEOUT, 0, (int)this.httpClientSocketTimeout.toMillis(), 0, this.getHttpClientKey(), (SFBaseSession)this);
                logger.debug("Connection heartbeat response: {}", theResponse);
                JsonNode rootNode = OBJECT_MAPPER.readTree(theResponse);
                if (rootNode != null && 390112 == rootNode.path("code").asInt()) {
                    logger.debug("Renew session and retry", false);
                    this.renewSession(prevSessionToken);
                    retry = true;
                    continue;
                }
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
                retry = false;
            }
            catch (Throwable ex) {
                if (ex instanceof SnowflakeSQLException) {
                    throw (SnowflakeSQLException)ex;
                }
                logger.error("Unexpected exception", ex);
                throw new SFException(ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("unexpected exception", ex));
            }
        } while (retry);
        stopwatch.stop();
        logger.debug("Session {} heartbeat successful in {} ms", this.getSessionId(), stopwatch.elapsedMillis());
    }

    void injectedDelay() {
        AtomicInteger injectedDelay = this.getInjectedDelay();
        int d = injectedDelay.get();
        if (d != 0) {
            injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
    }

    @Override
    public int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    @Override
    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public int getHttpClientSocketTimeout() {
        return (int)this.httpClientSocketTimeout.toMillis();
    }

    public int getHttpClientConnectionTimeout() {
        return (int)this.httpClientConnectionTimeout.toMillis();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getInjectClientPause() {
        return this.injectClientPause;
    }

    @Override
    public int getMaxHttpRetries() {
        return this.maxHttpRetries;
    }

    public void setInjectClientPause(int injectClientPause) {
        this.injectClientPause = injectClientPause;
    }

    protected int getAndIncrementSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    @Override
    public boolean getEnableCombineDescribe() {
        return this.enableCombineDescribe;
    }

    @Override
    public void setEnableCombineDescribe(boolean enable) {
        this.enableCombineDescribe = enable;
    }

    @Override
    public synchronized Telemetry getTelemetryClient() {
        if (this.telemetryClient == null) {
            if (this.getUrl() == null) {
                logger.error("Telemetry client created before session properties set.", false);
                return null;
            }
            this.telemetryClient = TelemetryClient.createTelemetry(this);
        }
        return this.telemetryClient;
    }

    public void closeTelemetryClient() {
        if (this.telemetryClient != null) {
            this.telemetryClient.close();
        }
    }

    public String getIdToken() {
        return this.idToken;
    }

    @SnowflakeJdbcInternalApi
    public String getAccessToken() {
        return this.oauthAccessToken;
    }

    public String getMfaToken() {
        return this.mfaToken;
    }

    @Override
    public SnowflakeConnectString getSnowflakeConnectionString() {
        return this.sfConnStr;
    }

    public void setSnowflakeConnectionString(SnowflakeConnectString connStr) {
        this.sfConnStr = connStr;
    }

    private void performSanityCheckOnProperties() throws SFException {
        boolean useProxy;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || connectionPropertiesMap.containsKey((Object)property)) continue;
            switch (property) {
                case SERVER_URL: {
                    throw new SFException(ErrorCode.MISSING_SERVER_URL, new Object[0]);
                }
            }
            throw new SFException(ErrorCode.MISSING_CONNECTION_PROPERTY, property.getPropertyKey());
        }
        if (this.isSnowflakeAuthenticator() || this.isOKTAAuthenticator() || this.isUsernamePasswordMFAAuthenticator()) {
            String userName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.USER);
            if (SnowflakeUtil.isNullOrEmpty(userName)) {
                throw new SFException(ErrorCode.MISSING_USERNAME, new Object[0]);
            }
            String password = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD);
            if (SnowflakeUtil.isNullOrEmpty(password)) {
                throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
            }
        }
        if ((useProxy = ((Boolean)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.USE_PROXY, false)).booleanValue()) && (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_HOST) || connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST) == null || ((String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST)).isEmpty() || !connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_PORT) || connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST) == null)) {
            throw new SFException(ErrorCode.INVALID_PROXY_PROPERTIES, "Both proxy host and port values are needed.");
        }
    }

    @Override
    public List<DriverPropertyInfo> checkProperties() {
        boolean useProxy;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || connectionPropertiesMap.containsKey((Object)property)) continue;
            this.missingProperties.add(this.addNewDriverProperty(property.getPropertyKey(), null));
        }
        if (this.isSnowflakeAuthenticator() || this.isOKTAAuthenticator()) {
            String password;
            String userName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.USER);
            if (SnowflakeUtil.isNullOrEmpty(userName)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.USER.getPropertyKey(), "username for account"));
            }
            if (SnowflakeUtil.isNullOrEmpty(password = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD))) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PASSWORD.getPropertyKey(), "password for account"));
            }
        }
        if (useProxy = ((Boolean)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.USE_PROXY, false)).booleanValue()) {
            if (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_HOST)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PROXY_HOST.getPropertyKey(), "proxy host name"));
            }
            if (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_PORT)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PROXY_PORT.getPropertyKey(), "proxy port; should be an integer"));
            }
        }
        return this.missingProperties;
    }

    private DriverPropertyInfo addNewDriverProperty(String name, String description) {
        DriverPropertyInfo info = new DriverPropertyInfo(name, null);
        info.description = description;
        return info;
    }

    @Override
    public boolean isAsyncSession() {
        return !this.activeAsyncQueries.isEmpty();
    }

    private boolean getDisableQueryContextCacheOption() {
        Boolean disableQueryContextCache = false;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        if (connectionPropertiesMap.containsKey((Object)SFSessionProperty.DISABLE_QUERY_CONTEXT_CACHE)) {
            disableQueryContextCache = (Boolean)connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_QUERY_CONTEXT_CACHE);
        }
        return disableQueryContextCache;
    }

    @Override
    public void setQueryContext(String queryContext) {
        boolean disableQueryContextCache = this.getDisableQueryContextCacheOption();
        if (!disableQueryContextCache) {
            this.qcc.deserializeQueryContextJson(queryContext);
        }
    }

    @Override
    public QueryContextDTO getQueryContextDTO() {
        boolean disableQueryContextCache = this.getDisableQueryContextCacheOption();
        if (!disableQueryContextCache) {
            QueryContextDTO res = this.qcc.serializeQueryContextDTO();
            return res;
        }
        return null;
    }

    public SFClientConfig getSfClientConfig() {
        return this.sfClientConfig;
    }

    public void setSfClientConfig(SFClientConfig sfClientConfig) {
        this.sfClientConfig = sfClientConfig;
    }

    private void runDiagnosticsIfEnabled() throws SnowflakeSQLException {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        boolean isDiagnosticsEnabled = Optional.ofNullable(connectionPropertiesMap.get((Object)SFSessionProperty.ENABLE_DIAGNOSTICS)).map(b -> (Boolean)b).orElse(false);
        if (!isDiagnosticsEnabled) {
            return;
        }
        logger.info("Running diagnostics tests", new Object[0]);
        String allowListFile = (String)connectionPropertiesMap.get((Object)SFSessionProperty.DIAGNOSTICS_ALLOWLIST_FILE);
        if (allowListFile == null || allowListFile.isEmpty()) {
            logger.error("Diagnostics was enabled but an allowlist file was not provided. Please provide an allowlist JSON file using the connection parameter {}", new Object[]{SFSessionProperty.DIAGNOSTICS_ALLOWLIST_FILE});
            throw new SnowflakeSQLException("Diagnostics was enabled but an allowlist file was not provided. Please provide an allowlist JSON file using the connection parameter " + (Object)((Object)SFSessionProperty.DIAGNOSTICS_ALLOWLIST_FILE));
        }
        DiagnosticContext diagnosticContext = new DiagnosticContext(allowListFile, connectionPropertiesMap);
        diagnosticContext.runDiagnostics();
        throw new SnowflakeSQLException("A connection was not created because the driver is running in diagnostics mode. If this is unintended then disable diagnostics check by removing the " + (Object)((Object)SFSessionProperty.ENABLE_DIAGNOSTICS) + " connection parameter");
    }

    public void setHttpHeadersCustomizers(List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        this.httpHeadersCustomizers = httpHeadersCustomizers;
    }

    public List<HttpHeadersCustomizer> getHttpHeadersCustomizers() {
        return this.httpHeadersCustomizers;
    }
}

