/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiExceptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.DownloadResult;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.ParallelDownloadConfig;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

public final class DownloadJob {
    private final @NonNull List<ApiFuture<DownloadResult>> downloadResults;
    private final @NonNull ParallelDownloadConfig parallelDownloadConfig;

    private DownloadJob(@NonNull List<ApiFuture<DownloadResult>> downloadResults, @NonNull ParallelDownloadConfig parallelDownloadConfig) {
        this.downloadResults = downloadResults;
        this.parallelDownloadConfig = parallelDownloadConfig;
    }

    public @NonNull List<DownloadResult> getDownloadResults() {
        return ApiExceptions.callAndTranslateApiException(ApiFutures.allAsList(this.downloadResults));
    }

    public @NonNull ParallelDownloadConfig getParallelDownloadConfig() {
        return this.parallelDownloadConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadJob)) {
            return false;
        }
        DownloadJob that = (DownloadJob)o;
        return this.downloadResults.equals(that.downloadResults) && this.parallelDownloadConfig.equals(that.parallelDownloadConfig);
    }

    public int hashCode() {
        return Objects.hash(this.downloadResults, this.parallelDownloadConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("downloadResults", this.downloadResults).add("parallelDownloadConfig", this.parallelDownloadConfig).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private @NonNull List<ApiFuture<DownloadResult>> downloadResults = ImmutableList.of();
        private @MonotonicNonNull ParallelDownloadConfig parallelDownloadConfig;

        private Builder() {
        }

        public Builder setDownloadResults(@NonNull List<ApiFuture<DownloadResult>> downloadResults) {
            this.downloadResults = ImmutableList.copyOf(downloadResults);
            return this;
        }

        public Builder setParallelDownloadConfig(@NonNull ParallelDownloadConfig parallelDownloadConfig) {
            this.parallelDownloadConfig = parallelDownloadConfig;
            return this;
        }

        public DownloadJob build() {
            Preconditions.checkNotNull(this.downloadResults);
            Preconditions.checkNotNull(this.parallelDownloadConfig);
            return new DownloadJob(this.downloadResults, this.parallelDownloadConfig);
        }
    }
}

