/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.core.BackgroundResource;
import net.snowflake.client.jdbc.internal.google.api.gax.paging.AbstractFixedSizeCollection;
import net.snowflake.client.jdbc.internal.google.api.gax.paging.AbstractPage;
import net.snowflake.client.jdbc.internal.google.api.gax.paging.AbstractPagedListResponse;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.PageContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.api.resourcenames.ResourceName;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.UptimeCheckServiceSettings;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.stub.UptimeCheckServiceStub;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.stub.UptimeCheckServiceStubSettings;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.CreateUptimeCheckConfigRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.DeleteUptimeCheckConfigRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.GetUptimeCheckConfigRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ListUptimeCheckConfigsRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ListUptimeCheckConfigsResponse;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ListUptimeCheckIpsRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ListUptimeCheckIpsResponse;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.OrganizationName;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ProjectName;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.UpdateUptimeCheckConfigRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.UptimeCheckConfig;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.UptimeCheckConfigName;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.UptimeCheckIp;
import net.snowflake.client.jdbc.internal.google.protobuf.Empty;

public class UptimeCheckServiceClient
implements BackgroundResource {
    private final UptimeCheckServiceSettings settings;
    private final UptimeCheckServiceStub stub;

    public static final UptimeCheckServiceClient create() throws IOException {
        return UptimeCheckServiceClient.create(UptimeCheckServiceSettings.newBuilder().build());
    }

    public static final UptimeCheckServiceClient create(UptimeCheckServiceSettings settings) throws IOException {
        return new UptimeCheckServiceClient(settings);
    }

    public static final UptimeCheckServiceClient create(UptimeCheckServiceStub stub) {
        return new UptimeCheckServiceClient(stub);
    }

    protected UptimeCheckServiceClient(UptimeCheckServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UptimeCheckServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected UptimeCheckServiceClient(UptimeCheckServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UptimeCheckServiceSettings getSettings() {
        return this.settings;
    }

    public UptimeCheckServiceStub getStub() {
        return this.stub;
    }

    public final ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(ResourceName parent) {
        ListUptimeCheckConfigsRequest request = ListUptimeCheckConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUptimeCheckConfigs(request);
    }

    public final ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(OrganizationName parent) {
        ListUptimeCheckConfigsRequest request = ListUptimeCheckConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUptimeCheckConfigs(request);
    }

    public final ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(ProjectName parent) {
        ListUptimeCheckConfigsRequest request = ListUptimeCheckConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUptimeCheckConfigs(request);
    }

    public final ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(String parent) {
        ListUptimeCheckConfigsRequest request = ListUptimeCheckConfigsRequest.newBuilder().setParent(parent).build();
        return this.listUptimeCheckConfigs(request);
    }

    public final ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(ListUptimeCheckConfigsRequest request) {
        return this.listUptimeCheckConfigsPagedCallable().call(request);
    }

    public final UnaryCallable<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsPagedCallable() {
        return this.stub.listUptimeCheckConfigsPagedCallable();
    }

    public final UnaryCallable<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse> listUptimeCheckConfigsCallable() {
        return this.stub.listUptimeCheckConfigsCallable();
    }

    public final UptimeCheckConfig getUptimeCheckConfig(UptimeCheckConfigName name) {
        GetUptimeCheckConfigRequest request = GetUptimeCheckConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig getUptimeCheckConfig(String name) {
        GetUptimeCheckConfigRequest request = GetUptimeCheckConfigRequest.newBuilder().setName(name).build();
        return this.getUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig getUptimeCheckConfig(GetUptimeCheckConfigRequest request) {
        return this.getUptimeCheckConfigCallable().call(request);
    }

    public final UnaryCallable<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigCallable() {
        return this.stub.getUptimeCheckConfigCallable();
    }

    public final UptimeCheckConfig createUptimeCheckConfig(ResourceName parent, UptimeCheckConfig uptimeCheckConfig) {
        CreateUptimeCheckConfigRequest request = CreateUptimeCheckConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.createUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig createUptimeCheckConfig(OrganizationName parent, UptimeCheckConfig uptimeCheckConfig) {
        CreateUptimeCheckConfigRequest request = CreateUptimeCheckConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.createUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig createUptimeCheckConfig(ProjectName parent, UptimeCheckConfig uptimeCheckConfig) {
        CreateUptimeCheckConfigRequest request = CreateUptimeCheckConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.createUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig createUptimeCheckConfig(String parent, UptimeCheckConfig uptimeCheckConfig) {
        CreateUptimeCheckConfigRequest request = CreateUptimeCheckConfigRequest.newBuilder().setParent(parent).setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.createUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig createUptimeCheckConfig(CreateUptimeCheckConfigRequest request) {
        return this.createUptimeCheckConfigCallable().call(request);
    }

    public final UnaryCallable<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigCallable() {
        return this.stub.createUptimeCheckConfigCallable();
    }

    public final UptimeCheckConfig updateUptimeCheckConfig(UptimeCheckConfig uptimeCheckConfig) {
        UpdateUptimeCheckConfigRequest request = UpdateUptimeCheckConfigRequest.newBuilder().setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.updateUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig updateUptimeCheckConfig(UpdateUptimeCheckConfigRequest request) {
        return this.updateUptimeCheckConfigCallable().call(request);
    }

    public final UnaryCallable<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigCallable() {
        return this.stub.updateUptimeCheckConfigCallable();
    }

    public final void deleteUptimeCheckConfig(UptimeCheckConfigName name) {
        DeleteUptimeCheckConfigRequest request = DeleteUptimeCheckConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteUptimeCheckConfig(request);
    }

    public final void deleteUptimeCheckConfig(String name) {
        DeleteUptimeCheckConfigRequest request = DeleteUptimeCheckConfigRequest.newBuilder().setName(name).build();
        this.deleteUptimeCheckConfig(request);
    }

    public final void deleteUptimeCheckConfig(DeleteUptimeCheckConfigRequest request) {
        this.deleteUptimeCheckConfigCallable().call(request);
    }

    public final UnaryCallable<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigCallable() {
        return this.stub.deleteUptimeCheckConfigCallable();
    }

    public final ListUptimeCheckIpsPagedResponse listUptimeCheckIps(ListUptimeCheckIpsRequest request) {
        return this.listUptimeCheckIpsPagedCallable().call(request);
    }

    public final UnaryCallable<ListUptimeCheckIpsRequest, ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsPagedCallable() {
        return this.stub.listUptimeCheckIpsPagedCallable();
    }

    public final UnaryCallable<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse> listUptimeCheckIpsCallable() {
        return this.stub.listUptimeCheckIpsCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUptimeCheckIpsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp, ListUptimeCheckIpsPage, ListUptimeCheckIpsFixedSizeCollection> {
        private ListUptimeCheckIpsFixedSizeCollection(List<ListUptimeCheckIpsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUptimeCheckIpsFixedSizeCollection createEmptyCollection() {
            return new ListUptimeCheckIpsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListUptimeCheckIpsFixedSizeCollection createCollection(List<ListUptimeCheckIpsPage> pages, int collectionSize) {
            return new ListUptimeCheckIpsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUptimeCheckIpsPage
    extends AbstractPage<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp, ListUptimeCheckIpsPage> {
        private ListUptimeCheckIpsPage(PageContext<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp> context, ListUptimeCheckIpsResponse response) {
            super(context, response);
        }

        private static ListUptimeCheckIpsPage createEmptyPage() {
            return new ListUptimeCheckIpsPage(null, null);
        }

        @Override
        protected ListUptimeCheckIpsPage createPage(PageContext<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp> context, ListUptimeCheckIpsResponse response) {
            return new ListUptimeCheckIpsPage(context, response);
        }

        @Override
        public ApiFuture<ListUptimeCheckIpsPage> createPageAsync(PageContext<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp> context, ApiFuture<ListUptimeCheckIpsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUptimeCheckIpsPagedResponse
    extends AbstractPagedListResponse<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp, ListUptimeCheckIpsPage, ListUptimeCheckIpsFixedSizeCollection> {
        public static ApiFuture<ListUptimeCheckIpsPagedResponse> createAsync(PageContext<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp> context, ApiFuture<ListUptimeCheckIpsResponse> futureResponse) {
            ApiFuture<ListUptimeCheckIpsPage> futurePage = ListUptimeCheckIpsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUptimeCheckIpsPagedResponse((ListUptimeCheckIpsPage)input), MoreExecutors.directExecutor());
        }

        private ListUptimeCheckIpsPagedResponse(ListUptimeCheckIpsPage page) {
            super(page, ListUptimeCheckIpsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListUptimeCheckConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig, ListUptimeCheckConfigsPage, ListUptimeCheckConfigsFixedSizeCollection> {
        private ListUptimeCheckConfigsFixedSizeCollection(List<ListUptimeCheckConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUptimeCheckConfigsFixedSizeCollection createEmptyCollection() {
            return new ListUptimeCheckConfigsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListUptimeCheckConfigsFixedSizeCollection createCollection(List<ListUptimeCheckConfigsPage> pages, int collectionSize) {
            return new ListUptimeCheckConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUptimeCheckConfigsPage
    extends AbstractPage<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig, ListUptimeCheckConfigsPage> {
        private ListUptimeCheckConfigsPage(PageContext<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig> context, ListUptimeCheckConfigsResponse response) {
            super(context, response);
        }

        private static ListUptimeCheckConfigsPage createEmptyPage() {
            return new ListUptimeCheckConfigsPage(null, null);
        }

        @Override
        protected ListUptimeCheckConfigsPage createPage(PageContext<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig> context, ListUptimeCheckConfigsResponse response) {
            return new ListUptimeCheckConfigsPage(context, response);
        }

        @Override
        public ApiFuture<ListUptimeCheckConfigsPage> createPageAsync(PageContext<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig> context, ApiFuture<ListUptimeCheckConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUptimeCheckConfigsPagedResponse
    extends AbstractPagedListResponse<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig, ListUptimeCheckConfigsPage, ListUptimeCheckConfigsFixedSizeCollection> {
        public static ApiFuture<ListUptimeCheckConfigsPagedResponse> createAsync(PageContext<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig> context, ApiFuture<ListUptimeCheckConfigsResponse> futureResponse) {
            ApiFuture<ListUptimeCheckConfigsPage> futurePage = ListUptimeCheckConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUptimeCheckConfigsPagedResponse((ListUptimeCheckConfigsPage)input), MoreExecutors.directExecutor());
        }

        private ListUptimeCheckConfigsPagedResponse(ListUptimeCheckConfigsPage page) {
            super(page, ListUptimeCheckConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

