/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.PartitionKey;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.ThresholdBatchReceiver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.Batch;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BatchedRequestIssuer;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BatchingDescriptor;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;

class BatchExecutor<RequestT, ResponseT>
implements ThresholdBatchReceiver<Batch<RequestT, ResponseT>> {
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final PartitionKey partitionKey;

    public BatchExecutor(BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, PartitionKey partitionKey) {
        this.batchingDescriptor = Preconditions.checkNotNull(batchingDescriptor);
        this.partitionKey = Preconditions.checkNotNull(partitionKey);
    }

    @Override
    public void validateBatch(Batch<RequestT, ResponseT> item) {
        PartitionKey itemPartitionKey = this.batchingDescriptor.getBatchPartitionKey(item.getRequest());
        if (!itemPartitionKey.equals(this.partitionKey)) {
            String requestClassName = item.getRequest().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("For type %s, invalid partition key: %s, should be: %s", requestClassName, itemPartitionKey, this.partitionKey));
        }
    }

    @Override
    public ApiFuture<ResponseT> processBatch(Batch<RequestT, ResponseT> batch) {
        UnaryCallable<RequestT, ResponseT> callable = batch.getCallable();
        RequestT request = batch.getRequest();
        final List<BatchedRequestIssuer<ResponseT>> requestIssuerList = batch.getRequestIssuerList();
        ApiFuture<ResponseT> future = callable.futureCall(request);
        ApiFutures.addCallback(future, new ApiFutureCallback<ResponseT>(){

            @Override
            public void onSuccess(ResponseT result) {
                BatchExecutor.this.batchingDescriptor.splitResponse(result, requestIssuerList);
                for (BatchedRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }

            @Override
            public void onFailure(Throwable t2) {
                BatchExecutor.this.batchingDescriptor.splitException(t2, requestIssuerList);
                for (BatchedRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }
        }, MoreExecutors.directExecutor());
        return future;
    }
}

