/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import java.util.Collections;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestationCreator;
import net.snowflake.client.core.auth.wif.WorkloadIdentityProviderType;
import net.snowflake.client.core.auth.wif.WorkloadIdentityUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class GcpIdentityAttestationCreator
implements WorkloadIdentityAttestationCreator {
    private static final String METADATA_FLAVOR_HEADER_NAME = "Metadata-Flavor";
    private static final String METADATA_FLAVOR = "Google";
    private final String gcpMetadataServiceBaseUrl;
    private static final SFLogger logger = SFLoggerFactory.getLogger(GcpIdentityAttestationCreator.class);
    private final SFLoginInput loginInput;

    public GcpIdentityAttestationCreator(SFLoginInput loginInput) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = "http://169.254.169.254";
    }

    GcpIdentityAttestationCreator(SFLoginInput loginInput, String gcpBaseUrl) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = gcpBaseUrl;
    }

    @Override
    public WorkloadIdentityAttestation createAttestation() {
        logger.debug("Creating GCP identity attestation...", new Object[0]);
        String token = this.fetchTokenFromMetadataService();
        if (token == null) {
            logger.debug("No GCP token was found.", new Object[0]);
            return null;
        }
        WorkloadIdentityUtil.SubjectAndIssuer claims = WorkloadIdentityUtil.extractClaimsWithoutVerifyingSignature(token);
        if (claims == null) {
            logger.error("Could not extract claims from token", new Object[0]);
            return null;
        }
        return new WorkloadIdentityAttestation(WorkloadIdentityProviderType.GCP, token, Collections.singletonMap("sub", claims.getSubject()));
    }

    private String fetchTokenFromMetadataService() {
        String uri = this.gcpMetadataServiceBaseUrl + "/computeMetadata/v1/instance/service-accounts/default/identity?audience=" + "snowflakecomputing.com";
        HttpGet tokenRequest = new HttpGet(uri);
        tokenRequest.setHeader(METADATA_FLAVOR_HEADER_NAME, METADATA_FLAVOR);
        try {
            return WorkloadIdentityUtil.performIdentityRequest(tokenRequest, this.loginInput);
        }
        catch (Exception e) {
            logger.debug("GCP metadata server request was not successful: {}" + e, new Object[0]);
            return null;
        }
    }
}

