/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.EnvironmentVariables;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWS4Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import net.snowflake.client.jdbc.internal.amazonaws.regions.InstanceMetadataRegionProvider;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class AwsAttestationService {
    public static final SFLogger logger = SFLoggerFactory.getLogger(AwsAttestationService.class);
    private static boolean regionInitialized = false;
    private static String region;
    private final AWS4Signer aws4Signer = new AWS4Signer();

    public AwsAttestationService() {
        this.aws4Signer.setRegionName(this.getAWSRegion());
    }

    AWSCredentials getAWSCredentials() {
        return DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
    }

    String getAWSRegion() {
        try {
            String envRegion;
            if (!regionInitialized) {
                envRegion = SnowflakeUtil.systemGetEnv(EnvironmentVariables.AWS_REGION.getName());
                region = envRegion != null ? envRegion : new InstanceMetadataRegionProvider().getRegion();
            }
            envRegion = region;
            return envRegion;
        }
        catch (Exception e) {
            logger.debug("Could not get AWS region", e);
            String string = null;
            return string;
        }
        finally {
            regionInitialized = true;
        }
    }

    void signRequestWithSigV4(Request<Void> signableRequest, AWSCredentials awsCredentials) {
        this.aws4Signer.setServiceName(signableRequest.getServiceName());
        this.aws4Signer.sign(signableRequest, awsCredentials);
    }
}

