/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverterUtil;
import net.snowflake.client.core.arrow.tostringhelpers.ArrowObjectStringRepresentationBuilder;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;

public class MapConverter
extends AbstractArrowVectorConverter {
    private final MapVector vector;

    public MapConverter(MapVector valueVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.MAP.name(), valueVector, columnIndex, context);
        this.vector = valueVector;
    }

    @Override
    public Object toObject(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        Object entriesList = this.vector.getObject(index);
        return entriesList.stream().collect(Collectors.toMap(entry -> entry.get("key").toString(), entry -> entry.get("value")));
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        return this.isNull(index) ? null : this.toString(index).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String toString(int index) throws SFException {
        ArrowVectorConverter valueConverter;
        ArrowVectorConverter keyConverter;
        ArrowObjectStringRepresentationBuilder builder = new ArrowObjectStringRepresentationBuilder();
        FieldVector vectorUnpacked = this.vector.getChildrenFromFields().get(0);
        FieldVector keys = vectorUnpacked.getChildrenFromFields().get(0);
        FieldVector values = vectorUnpacked.getChildrenFromFields().get(1);
        SnowflakeType valueLogicalType = ArrowVectorConverterUtil.getSnowflakeTypeFromFieldMetadata(values.getField());
        try {
            keyConverter = ArrowVectorConverterUtil.initConverter(keys, this.context, this.columnIndex);
            valueConverter = ArrowVectorConverterUtil.initConverter(values, this.context, this.columnIndex);
        }
        catch (SnowflakeSQLException e) {
            return this.vector.getObject(index).toString();
        }
        for (int i = this.vector.getElementStartIndex(index); i < this.vector.getElementEndIndex(index); ++i) {
            builder.appendKeyValue(keyConverter.toString(i), valueConverter.toString(i), valueLogicalType);
        }
        return builder.toString();
    }
}

