/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManager;
import net.snowflake.client.core.AttributeEnhancingHttpRequestRetryHandler;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HeaderCustomizerHttpRequestInterceptor;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpExecutingContext;
import net.snowflake.client.core.HttpExecutingContextBuilder;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSSLConnectionSocketFactory;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.SnowflakeMutableProxyRoutePlanner;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.core.URLUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.RetryContextManager;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.S3HttpUtil;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultRedirectStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLInitializationException;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.SFLoggerUtil;
import net.snowflake.client.util.SecretDetector;
import net.snowflake.client.util.Stopwatch;

public class HttpUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(HttpUtil.class);
    static final int DEFAULT_MAX_CONNECTIONS = 300;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 300;
    private static final int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT_IN_MS = 60000;
    static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS = 300000;
    static final int DEFAULT_TTL = 60;
    static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = 5;
    static final int DEFAULT_DOWNLOADED_CONDITION_TIMEOUT = 3600;
    public static final String JDBC_TTL = "net.snowflake.jdbc.ttl";
    public static final String JDBC_MAX_CONNECTIONS_PROPERTY = "net.snowflake.jdbc.max_connections";
    public static final String JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY = "net.snowflake.jdbc.max_connections_per_route";
    private static Duration connectionTimeout;
    private static Duration socketTimeout;
    public static Map<HttpClientSettingsKey, CloseableHttpClient> httpClient;
    private static Map<HttpClientSettingsKey, CloseableHttpClient> httpClientWithoutDecompression;
    static Map<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner> httpClientRoutePlanner;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static RequestConfig DefaultRequestConfig;
    private static boolean socksProxyDisabled;

    @SnowflakeJdbcInternalApi
    public static void reset() {
        httpClient.clear();
        httpClientWithoutDecompression.clear();
        httpClientRoutePlanner.clear();
    }

    @SnowflakeJdbcInternalApi
    public static Duration getConnectionTimeout() {
        return connectionTimeout != null ? connectionTimeout : Duration.ofMillis(60000L);
    }

    @SnowflakeJdbcInternalApi
    public static Duration getSocketTimeout() {
        return socketTimeout != null ? socketTimeout : Duration.ofMillis(300000L);
    }

    @SnowflakeJdbcInternalApi
    public static void setConnectionTimeout(int timeout) {
        connectionTimeout = Duration.ofMillis(timeout);
        HttpUtil.initDefaultRequestConfig(connectionTimeout.toMillis(), HttpUtil.getSocketTimeout().toMillis());
    }

    @SnowflakeJdbcInternalApi
    public static void setSocketTimeout(int timeout) {
        socketTimeout = Duration.ofMillis(timeout);
        HttpUtil.initDefaultRequestConfig(HttpUtil.getConnectionTimeout().toMillis(), socketTimeout.toMillis());
    }

    public static long getDownloadedConditionTimeoutInSeconds() {
        return 3600L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeExpiredAndIdleConnections() {
        if (connectionManager != null) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = connectionManager;
            synchronized (poolingHttpClientConnectionManager) {
                logger.debug("Connection pool stats: {}", connectionManager.getTotalStats());
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections(5L, TimeUnit.SECONDS);
            }
        }
    }

    @Deprecated
    public static void setProxyForS3(HttpClientSettingsKey key, ClientConfiguration clientConfig) {
        S3HttpUtil.setProxyForS3(key, clientConfig);
    }

    @Deprecated
    public static void setSessionlessProxyForS3(Properties proxyProperties, ClientConfiguration clientConfig) throws SnowflakeSQLException {
        S3HttpUtil.setSessionlessProxyForS3(proxyProperties, clientConfig);
    }

    public static void setSessionlessProxyForAzure(Properties proxyProperties, OperationContext opContext) throws SnowflakeSQLException {
        if (proxyProperties != null && proxyProperties.size() > 0 && proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null) {
            Boolean useProxy = Boolean.valueOf(proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()));
            if (useProxy.booleanValue()) {
                int proxyPort;
                String proxyHost = proxyProperties.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
                try {
                    proxyPort = Integer.parseInt(proxyProperties.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
                }
                Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                logger.debug("Setting sessionless Azure proxy. Host: {}, port: {}", proxyHost, proxyPort);
                opContext.setProxy(azProxy);
            } else {
                logger.debug("Omitting sessionless Azure proxy setup as proxy is disabled", new Object[0]);
            }
        } else {
            logger.debug("Omitting sessionless Azure proxy setup", new Object[0]);
        }
    }

    public static void setProxyForAzure(HttpClientSettingsKey key, OperationContext opContext) {
        if (key != null && key.usesProxy()) {
            Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(key.getProxyHost(), key.getProxyPort()));
            logger.debug("Setting Azure proxy. Host: {}, port: {}", key.getProxyHost(), key.getProxyPort());
            opContext.setProxy(azProxy);
        } else {
            logger.debug("Omitting Azure proxy setup", new Object[0]);
        }
    }

    @VisibleForTesting
    static String buildUserAgent(String customSuffix) {
        StringBuilder builder = new StringBuilder("JDBC/");
        builder.append(SnowflakeDriver.implementVersion);
        builder.append(" (");
        String osPlatform = SnowflakeUtil.systemGetProperty("os.name") != null ? SnowflakeUtil.systemGetProperty("os.name") : "";
        String osVersion = SnowflakeUtil.systemGetProperty("os.version") != null ? SnowflakeUtil.systemGetProperty("os.version") : "";
        builder.append(osPlatform);
        builder.append(" ");
        builder.append(osVersion);
        builder.append(") JAVA/");
        String languageVersion = SnowflakeUtil.systemGetProperty("java.version") != null ? SnowflakeUtil.systemGetProperty("java.version") : "";
        builder.append(languageVersion);
        if (!customSuffix.isEmpty()) {
            builder.append(" " + customSuffix);
        }
        String userAgent = builder.toString();
        return userAgent;
    }

    public static CloseableHttpClient buildHttpClient(@Nullable HttpClientSettingsKey key, File ocspCacheFile, boolean downloadUnCompressed) {
        return HttpUtil.buildHttpClient(key, ocspCacheFile, downloadUnCompressed, null);
    }

    public static CloseableHttpClient buildHttpClient(@Nullable HttpClientSettingsKey key, File ocspCacheFile, boolean downloadUnCompressed, List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        logger.debug("Building http client with client settings key: {}, ocsp cache file: {}, download uncompressed: {}", key != null ? key.toString() : null, ocspCacheFile, downloadUnCompressed);
        int timeToLive = SystemUtil.convertSystemPropertyToIntValue(JDBC_TTL, 60);
        long connectTimeout = HttpUtil.getConnectionTimeout().toMillis();
        long socketTimeout = HttpUtil.getSocketTimeout().toMillis();
        logger.debug("Connection pooling manager connect timeout: {} ms, socket timeout: {} ms, ttl: {} s", connectTimeout, socketTimeout, timeToLive);
        if (DefaultRequestConfig == null) {
            HttpUtil.initDefaultRequestConfig(connectTimeout, socketTimeout);
        }
        TrustManager[] trustManagers = null;
        if (key != null && key.getOcspMode() != OCSPMode.DISABLE_OCSP_CHECKS) {
            try {
                TrustManager[] tm;
                if (ocspCacheFile == null) {
                    logger.debug("Instantiating trust manager with default ocsp cache file", new Object[0]);
                } else {
                    logger.debug("Instantiating trust manager with ocsp cache file: {}", ocspCacheFile);
                }
                trustManagers = tm = new TrustManager[]{new SFTrustManager(key, ocspCacheFile)};
            }
            catch (Error | Exception err) {
                StringWriter errors = new StringWriter();
                err.printStackTrace(new PrintWriter(errors));
                logger.error(errors.toString(), true);
                throw new RuntimeException(err);
            }
        } else if (key != null) {
            logger.debug("Omitting trust manager instantiation as OCSP mode is set to {}", new Object[]{key.getOcspMode()});
        } else {
            logger.debug("Omitting trust manager instantiation as configuration is not provided", new Object[0]);
        }
        try {
            logger.debug("Registering https connection socket factory with socks proxy disabled: {} and http connection socket factory", socksProxyDisabled);
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", new SFSSLConnectionSocketFactory(trustManagers, socksProxyDisabled)).register("http", (SFSSLConnectionSocketFactory)((Object)new SFConnectionSocketFactory())).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry, null, null, null, timeToLive, TimeUnit.SECONDS);
            int maxConnections = SystemUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PROPERTY, 300);
            int maxConnectionsPerRoute = SystemUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY, 300);
            logger.debug("Max connections total in connection pooling manager: {}; max connections per route: {}", maxConnections, maxConnectionsPerRoute);
            connectionManager.setMaxTotal(maxConnections);
            connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
            logger.debug("Disabling cookie management for http client", new Object[0]);
            String userAgentSuffix = key != null ? key.getUserAgentSuffix() : "";
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).setUserAgent(HttpUtil.buildUserAgent(userAgentSuffix)).disableCookieManagement().setDefaultRequestConfig(DefaultRequestConfig);
            if (key != null && key.usesProxy()) {
                HttpHost proxy = new HttpHost(key.getProxyHost(), key.getProxyPort(), key.getProxyHttpProtocol().getScheme());
                logger.debug("Configuring proxy and route planner - host: {}, port: {}, scheme: {}, nonProxyHosts: {}", key.getProxyHost(), key.getProxyPort(), key.getProxyHttpProtocol().getScheme(), key.getNonProxyHosts());
                SnowflakeMutableProxyRoutePlanner sdkProxyRoutePlanner = httpClientRoutePlanner.computeIfAbsent(key, k -> new SnowflakeMutableProxyRoutePlanner(key.getProxyHost(), key.getProxyPort(), key.getProxyHttpProtocol(), key.getNonProxyHosts()));
                httpClientBuilder.setProxy(proxy).setRoutePlanner(sdkProxyRoutePlanner);
                if (!SnowflakeUtil.isNullOrEmpty(key.getProxyUser()) && !SnowflakeUtil.isNullOrEmpty(key.getProxyPassword())) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(key.getProxyUser(), key.getProxyPassword());
                    AuthScope authScope = new AuthScope(key.getProxyHost(), key.getProxyPort());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    logger.debug("Using user: {}, password is {} for proxy host: {}, port: {}", key.getProxyUser(), SFLoggerUtil.isVariableProvided(key.getProxyPassword()), key.getProxyHost(), key.getProxyPort());
                    credentialsProvider.setCredentials(authScope, credentials);
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
            }
            if (downloadUnCompressed) {
                logger.debug("Disabling content compression for http client", new Object[0]);
                httpClientBuilder.disableContentCompression();
            }
            if (httpHeadersCustomizers != null && !httpHeadersCustomizers.isEmpty()) {
                logger.debug("Setting up http headers customizers", new Object[0]);
                httpClientBuilder.setRetryHandler(new AttributeEnhancingHttpRequestRetryHandler());
                httpClientBuilder.addInterceptorLast(new HeaderCustomizerHttpRequestInterceptor(httpHeadersCustomizers));
            }
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    private static void initDefaultRequestConfig(long connectTimeout, long socketTimeout) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout((int)connectTimeout).setConnectionRequestTimeout((int)connectTimeout).setSocketTimeout((int)socketTimeout);
        logger.debug("Rebuilding request config. Connect timeout: {} ms, connection request timeout: {} ms, socket timeout: {} ms", connectTimeout, connectTimeout, socketTimeout);
        DefaultRequestConfig = builder.build();
    }

    public static void updateRoutePlanner(HttpClientSettingsKey key) {
        if (httpClientRoutePlanner.containsKey(key) && !httpClientRoutePlanner.get(key).getNonProxyHosts().equalsIgnoreCase(key.getNonProxyHosts())) {
            logger.debug("Updating route planner non-proxy hosts for proxy: {}:{} to: {}", key.getProxyHost(), key.getProxyPort(), key.getNonProxyHosts());
            httpClientRoutePlanner.get(key).setNonProxyHosts(key.getNonProxyHosts());
        }
    }

    public static CloseableHttpClient getHttpClient(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClient(ocspAndProxyKey, null, null);
    }

    public static CloseableHttpClient getHttpClientWithoutDecompression(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClientWithoutDecompression(ocspAndProxyKey, null, null);
    }

    public static CloseableHttpClient getHttpClient(HttpClientSettingsKey ocspAndProxyKey, List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        return HttpUtil.initHttpClient(ocspAndProxyKey, null, httpHeadersCustomizers);
    }

    public static CloseableHttpClient getHttpClientWithoutDecompression(HttpClientSettingsKey ocspAndProxyKey, List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        return HttpUtil.initHttpClientWithoutDecompression(ocspAndProxyKey, null, httpHeadersCustomizers);
    }

    public static CloseableHttpClient initHttpClientWithoutDecompression(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClientWithoutDecompression.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, true, null));
    }

    public static CloseableHttpClient initHttpClient(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClient.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, key.getGzipDisabled(), null));
    }

    public static CloseableHttpClient initHttpClientWithoutDecompression(HttpClientSettingsKey key, File ocspCacheFile, List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        HttpUtil.updateRoutePlanner(key);
        return httpClientWithoutDecompression.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, true, httpHeadersCustomizers));
    }

    public static CloseableHttpClient initHttpClient(HttpClientSettingsKey key, File ocspCacheFile, List<HttpHeadersCustomizer> httpHeadersCustomizers) {
        HttpUtil.updateRoutePlanner(key);
        return httpClient.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, key.getGzipDisabled(), httpHeadersCustomizers));
    }

    public static RequestConfig getDefaultRequestConfigWithSocketTimeout(int soTimeoutMs, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(soTimeoutMs).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getDefaultRequestConfigWithSocketAndConnectTimeout(int requestSocketAndConnectTimeout, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(requestSocketAndConnectTimeout).setConnectTimeout(requestSocketAndConnectTimeout).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getRequestConfigWithoutCookies() {
        return RequestConfig.copy(DefaultRequestConfig).setCookieSpec("ignoreCookies").build();
    }

    public static void setRequestConfig(RequestConfig requestConfig) {
        logger.debug("Setting default request config to: {}", requestConfig);
        DefaultRequestConfig = requestConfig;
    }

    private static String getHttpClientStats() {
        return connectionManager == null ? "" : connectionManager.getTotalStats().toString();
    }

    public static void setSocksProxyDisabled(boolean socksProxyDisabled) {
        logger.debug("Setting socks proxy disabled to {}", socksProxyDisabled);
        HttpUtil.socksProxyDisabled = socksProxyDisabled;
    }

    public static boolean isSocksProxyDisabled() {
        return socksProxyDisabled;
    }

    static String executeRequestWithoutCookies(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, int injectSocketTimeout, AtomicBoolean canceling, HttpClientSettingsKey ocspAndProxyKey) throws SnowflakeSQLException, IOException {
        logger.debug("Executing request without cookies", new Object[0]);
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, injectSocketTimeout, canceling, true, false, true, false, HttpUtil.getHttpClient(ocspAndProxyKey, null), new ExecTimeTelemetryData(), null);
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, HttpClientSettingsKey ocspAndProxyAndGzipKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeGeneralRequest(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, ocspAndProxyAndGzipKey, null);
    }

    @SnowflakeJdbcInternalApi
    public static String executeGeneralRequestOmitRequestGuid(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, HttpClientSettingsKey ocspAndProxyAndGzipKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, false, false, HttpUtil.getHttpClient(ocspAndProxyAndGzipKey, null), new ExecTimeTelemetryData(), null);
    }

    @SnowflakeJdbcInternalApi
    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, HttpClientSettingsKey ocspAndProxyAndGzipKey, RetryContextManager retryContextManager) throws SnowflakeSQLException, IOException {
        logger.debug("Executing general request", new Object[0]);
        return HttpUtil.executeRequest(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, ocspAndProxyAndGzipKey, new ExecTimeTelemetryData(), retryContextManager);
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, CloseableHttpClient httpClient) throws SnowflakeSQLException, IOException {
        logger.debug("Executing general request", new Object[0]);
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, true, false, httpClient, new ExecTimeTelemetryData(), null);
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean includeRetryParameters, boolean retryOnHTTP403, HttpClientSettingsKey ocspAndProxyKey, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequest(httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, includeRetryParameters, retryOnHTTP403, ocspAndProxyKey, execTimeData, null);
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean includeRetryParameters, boolean retryOnHTTP403, HttpClientSettingsKey ocspAndProxyKey, ExecTimeTelemetryData execTimeData, RetryContextManager retryContextManager) throws SnowflakeSQLException, IOException {
        boolean ocspEnabled = !ocspAndProxyKey.getOcspMode().equals((Object)OCSPMode.DISABLE_OCSP_CHECKS);
        logger.debug("Executing request with OCSP enabled: {}", ocspEnabled);
        execTimeData.setOCSPStatus(ocspEnabled);
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, false, includeRetryParameters, true, retryOnHTTP403, HttpUtil.getHttpClient(ocspAndProxyKey, null), execTimeData, retryContextManager);
    }

    private static String executeRequestInternal(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryOnHTTP403, CloseableHttpClient httpClient, ExecTimeTelemetryData execTimeData, RetryContextManager retryContextManager) throws SnowflakeSQLException, IOException {
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        String responseText = "";
        logger.debug("Pool: {} Executing: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        Object response = null;
        Stopwatch stopwatch = null;
        String requestIdStr = URLUtil.getRequestIdLogStr(httpRequest.getURI());
        HttpExecutingContext context = HttpExecutingContextBuilder.forSimpleRequest(requestIdStr, requestInfoScrubbed).retryTimeout(retryTimeout).authTimeout(authTimeout).origSocketTimeout(socketTimeout).maxRetries(maxRetries).injectSocketTimeout(injectSocketTimeout).canceling(canceling).withoutCookies(withoutCookies).includeRetryParameters(includeRetryParameters).includeRequestGuid(includeRequestGuid).retryHTTP403(retryOnHTTP403).unpackResponse(true).noRetry(false).loginRequest(SessionUtil.isNewRetryStrategyRequest(httpRequest)).build();
        responseText = RestRequest.executeWithRetries(httpClient, httpRequest, context, execTimeData, retryContextManager).getUnpackedCloseableHttpResponse();
        logger.debug("Pool: {} Request returned for: {} took {} ms", HttpUtil::getHttpClientStats, requestInfoScrubbed, stopwatch == null ? "n/a" : Long.valueOf(stopwatch.elapsedMillis()));
        return responseText;
    }

    static void applyAdditionalHeadersForSnowsight(HttpRequestBase request, Map<String, String> additionalHeaders) {
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            additionalHeaders.forEach(request::addHeader);
        }
    }

    static {
        httpClient = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
        httpClientWithoutDecompression = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
        httpClientRoutePlanner = new ConcurrentHashMap<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner>();
        connectionManager = null;
        DefaultRequestConfig = null;
        socksProxyDisabled = false;
    }

    static final class SFConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        SFConnectionSocketFactory() {
        }

        @Override
        public Socket createSocket(HttpContext ctx) throws IOException {
            if (socksProxyDisabled) {
                logger.trace("Creating socket with no proxy", new Object[0]);
                return new Socket(Proxy.NO_PROXY);
            }
            logger.trace("Creating socket with proxy", new Object[0]);
            return super.createSocket(ctx);
        }
    }

    public static final class HttpInputStream
    extends InputStream {
        private final InputStream httpIn;

        public HttpInputStream(InputStream httpIn) {
            this.httpIn = httpIn;
        }

        @Override
        public final int available() throws IOException {
            int available = this.httpIn.available();
            return available == 0 ? 1 : available;
        }

        @Override
        public final int read() throws IOException {
            return this.httpIn.read();
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.httpIn.read(b);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return this.httpIn.read(b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            return this.httpIn.skip(n);
        }

        @Override
        public final void close() throws IOException {
            this.httpIn.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.httpIn.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.httpIn.reset();
        }

        @Override
        public final boolean markSupported() {
            return this.httpIn.markSupported();
        }
    }
}

