/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal;

import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;

public class RateLimiter {
    private final Clock clock;
    private final double creditsPerNanosecond;
    private final long maxBalance;
    private final AtomicLong currentBalance;

    public RateLimiter(double creditsPerSecond, double maxBalance, Clock clock) {
        this.clock = clock;
        this.creditsPerNanosecond = creditsPerSecond / 1.0E9;
        this.maxBalance = (long)(maxBalance / this.creditsPerNanosecond);
        this.currentBalance = new AtomicLong(clock.nanoTime() - this.maxBalance);
    }

    public boolean trySpend(double itemCost) {
        long availableBalanceAfterWithdrawal;
        long currentNanos;
        long currentBalanceNanos;
        long cost = (long)(itemCost / this.creditsPerNanosecond);
        do {
            currentBalanceNanos = this.currentBalance.get();
            currentNanos = this.clock.nanoTime();
            long currentAvailableBalance = currentNanos - currentBalanceNanos;
            if (currentAvailableBalance > this.maxBalance) {
                currentAvailableBalance = this.maxBalance;
            }
            if ((availableBalanceAfterWithdrawal = currentAvailableBalance - cost) >= 0L) continue;
            return false;
        } while (!this.currentBalance.compareAndSet(currentBalanceNanos, currentNanos - availableBalanceAfterWithdrawal));
        return true;
    }
}

